/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.parse;

import com.hazelcast.jet.sql.impl.parse.SqlCreateMapping;
import com.hazelcast.shaded.com.google.common.collect.ImmutableMap;
import com.hazelcast.sql.impl.schema.Mapping;
import com.hazelcast.sql.impl.schema.MappingField;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class SqlCreateMappingTest {
    private static final String LE = System.lineSeparator();

    @Test
    public void test_unparse() {
        Mapping mapping = new Mapping("name", "external-name", null, "Type", null, Arrays.asList(new MappingField("field1", QueryDataType.VARCHAR, "__key.field1"), new MappingField("field2", QueryDataType.INT, "this.field2")), (Map)ImmutableMap.of((Object)"key1", (Object)"value1", (Object)"key2", (Object)"value2"));
        String sql = SqlCreateMapping.unparse((Mapping)mapping);
        Assertions.assertThat((String)sql).isEqualTo("CREATE OR REPLACE EXTERNAL MAPPING \"hazelcast\".\"public\".\"name\" EXTERNAL NAME \"external-name\" (" + LE + "  \"field1\" VARCHAR EXTERNAL NAME \"__key.field1\"," + LE + "  \"field2\" INTEGER EXTERNAL NAME \"this.field2\"" + LE + ")" + LE + "TYPE \"Type\"" + LE + "OPTIONS (" + LE + "  'key1'='value1'," + LE + "  'key2'='value2'" + LE + ")");
    }

    @Test
    public void test_unparse_quoting() {
        Mapping mapping = new Mapping("na\"me", "external\"name", null, "Type", null, Collections.singletonList(new MappingField("fi\"eld", QueryDataType.VARCHAR, "__key\"field")), (Map)ImmutableMap.of((Object)"ke'y", (Object)"val'ue"));
        String sql = SqlCreateMapping.unparse((Mapping)mapping);
        Assertions.assertThat((String)sql).isEqualTo("CREATE OR REPLACE EXTERNAL MAPPING \"hazelcast\".\"public\".\"na\"\"me\" EXTERNAL NAME \"external\"\"name\" (" + LE + "  \"fi\"\"eld\" VARCHAR EXTERNAL NAME \"__key\"\"field\"" + LE + ")" + LE + "TYPE \"Type\"" + LE + "OPTIONS (" + LE + "  'ke''y'='val''ue'" + LE + ")");
    }

    @Test
    public void test_unparse_external_name_with_schema() {
        Mapping mapping = new Mapping("name", new String[]{"external\"schema", "external\"name"}, null, "Type", null, Collections.singletonList(new MappingField("field", QueryDataType.VARCHAR, "__key.field")), (Map)ImmutableMap.of((Object)"key", (Object)"value"));
        String sql = SqlCreateMapping.unparse((Mapping)mapping);
        Assertions.assertThat((String)sql).isEqualTo("CREATE OR REPLACE EXTERNAL MAPPING \"hazelcast\".\"public\".\"name\" EXTERNAL NAME \"external\"\"schema\".\"external\"\"name\" (" + LE + "  \"field\" VARCHAR EXTERNAL NAME \"__key.field\"" + LE + ")" + LE + "TYPE \"Type\"" + LE + "OPTIONS (" + LE + "  'key'='value'" + LE + ")");
    }
}

