/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.prunability;

import com.hazelcast.config.IndexType;
import com.hazelcast.jet.sql.impl.HazelcastRexBuilder;
import com.hazelcast.jet.sql.impl.opt.OptimizerTestSupport;
import com.hazelcast.jet.sql.impl.opt.metadata.HazelcastRelMetadataQuery;
import com.hazelcast.jet.sql.impl.opt.physical.AggregateAccumulateByKeyPhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.AggregateCombineByKeyPhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.CalcPhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.FullScanPhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.IndexScanMapPhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.JoinNestedLoopPhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.PhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.SortPhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.UnionPhysicalRel;
import com.hazelcast.jet.sql.impl.schema.HazelcastTable;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastTypeFactory;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastTypeUtils;
import com.hazelcast.map.IMap;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.shaded.org.apache.calcite.rel.metadata.RelMetadataQuery;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataTypeFactory;
import com.hazelcast.shaded.org.apache.calcite.rex.RexLiteral;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.map.MapTableUtils;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class RelPrunabilityTest
extends OptimizerTestSupport {
    private static final RelDataType REL_TYPE_BIGINT = HazelcastTypeUtils.createType((RelDataTypeFactory)HazelcastTypeFactory.INSTANCE, (SqlTypeName)SqlTypeName.BIGINT, (boolean)true);
    private static final String MAP_NAME = "m";
    private HazelcastTable table;
    private HazelcastRelMetadataQuery query;
    List<TableField> mapTableFields;

    @BeforeClass
    public static void beforeClass() throws Exception {
        RelPrunabilityTest.initialize((int)1, null);
    }

    @Before
    public void before() throws Exception {
        this.mapTableFields = Arrays.asList(RelPrunabilityTest.mapField(QueryPath.KEY, QueryDataType.OBJECT, QueryPath.KEY_PATH), RelPrunabilityTest.mapField("comp0", QueryDataType.BIGINT, QueryPath.create((String)(QueryPath.KEY_PREFIX + "comp0"))), RelPrunabilityTest.mapField("comp1", QueryDataType.BIGINT, QueryPath.create((String)(QueryPath.KEY_PREFIX + "comp1"))), RelPrunabilityTest.mapField(QueryPath.VALUE, QueryDataType.BIGINT, QueryPath.VALUE_PATH));
        this.table = RelPrunabilityTest.partitionedTable(MAP_NAME, this.mapTableFields, Collections.emptyList(), 10L, Collections.singletonList("comp1"), true);
    }

    @Test
    public void test_fullScanWithDefaultKey() {
        this.mapTableFields = Arrays.asList(RelPrunabilityTest.mapField(QueryPath.KEY, QueryDataType.BIGINT, QueryPath.KEY_PATH), RelPrunabilityTest.mapField(QueryPath.VALUE, QueryDataType.BIGINT, QueryPath.VALUE_PATH));
        this.table = RelPrunabilityTest.partitionedTable(MAP_NAME, this.mapTableFields, Collections.emptyList(), 10L, Collections.emptyList(), true);
        PhysicalRel root = this.optimizePhysical("SELECT * FROM m WHERE __key = 10 AND this IS NOT NULL", Arrays.asList(QueryDataType.BIGINT, QueryDataType.BIGINT), this.table).getPhysical();
        RelPrunabilityTest.assertPlan((RelNode)root, RelPrunabilityTest.plan(RelPrunabilityTest.planRow(0, FullScanPhysicalRel.class)));
        this.query = HazelcastRelMetadataQuery.reuseOrCreate((RelMetadataQuery)RelMetadataQuery.instance());
        Map prunability = this.query.extractPrunability((RelNode)root);
        RexLiteral expectedLiteral = HazelcastRexBuilder.INSTANCE.makeLiteral((Object)10, REL_TYPE_BIGINT);
        Assert.assertEquals(Map.of(MAP_NAME, Collections.singletonList(Map.of("__key", expectedLiteral))), (Object)prunability);
    }

    @Test
    public void test_fullScanWithStrategy() {
        PhysicalRel root = this.optimizePhysical("SELECT * FROM m WHERE comp1 = 10", Arrays.asList(QueryDataType.BIGINT, QueryDataType.BIGINT), this.table).getPhysical();
        RelPrunabilityTest.assertPlan((RelNode)root, RelPrunabilityTest.plan(RelPrunabilityTest.planRow(0, FullScanPhysicalRel.class)));
        this.query = HazelcastRelMetadataQuery.reuseOrCreate((RelMetadataQuery)RelMetadataQuery.instance());
        Map prunability = this.query.extractPrunability((RelNode)root);
        RexLiteral expectedLiteral = HazelcastRexBuilder.INSTANCE.makeLiteral((Object)10, REL_TYPE_BIGINT);
        Assert.assertEquals(Map.of(MAP_NAME, Collections.singletonList(Map.of("comp1", expectedLiteral))), (Object)prunability);
    }

    @Test
    public void test_sort() {
        PhysicalRel root = this.optimizePhysical("SELECT * FROM m WHERE comp1 = 10 ORDER BY comp0", Arrays.asList(QueryDataType.BIGINT, QueryDataType.BIGINT), this.table).getPhysical();
        RelPrunabilityTest.assertPlan((RelNode)root, RelPrunabilityTest.plan(RelPrunabilityTest.planRow(0, SortPhysicalRel.class), RelPrunabilityTest.planRow(1, FullScanPhysicalRel.class)));
        this.query = HazelcastRelMetadataQuery.reuseOrCreate((RelMetadataQuery)RelMetadataQuery.instance());
        Map prunability = this.query.extractPrunability((RelNode)root);
        RexLiteral expectedLiteral = HazelcastRexBuilder.INSTANCE.makeLiteral((Object)10, REL_TYPE_BIGINT);
        Assert.assertEquals(Map.of(MAP_NAME, Collections.singletonList(Map.of("comp1", expectedLiteral))), (Object)prunability);
    }

    @Test
    @Ignore(value="Resolve later : There is no suitable accessor for 'comp1' on class 'java.lang.String'")
    public void test_indexScan_isNotSupported() {
        String mapName = RelPrunabilityTest.randomName();
        String indexName = RelPrunabilityTest.randomName();
        IMap map = RelPrunabilityTest.instance().getMap(mapName);
        RelPrunabilityTest.createMapping(mapName, CompoundKey.class, String.class);
        RelPrunabilityTest.createIndex(indexName, mapName, IndexType.HASH, "comp1");
        for (int i = 0; i < 100; ++i) {
            map.put((Object)new CompoundKey(i, i), (Object)String.valueOf(i));
        }
        this.table = RelPrunabilityTest.partitionedTable(mapName, this.mapTableFields, MapTableUtils.getPartitionedMapIndexes((MapContainer)RelPrunabilityTest.mapContainer(map), this.mapTableFields), 1L, Collections.singletonList("comp1"), true);
        PhysicalRel root = this.optimizePhysical("SELECT * FROM " + mapName + " WHERE comp1 = 10", Arrays.asList(QueryDataType.OBJECT, QueryDataType.INT, QueryDataType.INT, QueryDataType.VARCHAR), this.table).getPhysical();
        RelPrunabilityTest.assertPlan((RelNode)root, RelPrunabilityTest.plan(RelPrunabilityTest.planRow(0, IndexScanMapPhysicalRel.class)));
        this.query = HazelcastRelMetadataQuery.reuseOrCreate((RelMetadataQuery)RelMetadataQuery.instance());
        Map prunability = this.query.extractPrunability((RelNode)root);
        RexLiteral expectedLiteral = HazelcastRexBuilder.INSTANCE.makeLiteral((Object)10, REL_TYPE_BIGINT);
        Assert.assertEquals(Collections.emptyMap(), (Object)prunability);
    }

    @Test
    public void test_aggAndCalc_areNotSupported() {
        PhysicalRel root = this.optimizePhysical("SELECT this, COUNT(__key) FROM m WHERE comp1 = ? AND comp0 = 10 GROUP BY comp0, comp1, this", Arrays.asList(QueryDataType.BIGINT, QueryDataType.VARCHAR), this.table).getPhysical();
        RelPrunabilityTest.assertPlan((RelNode)root, RelPrunabilityTest.plan(RelPrunabilityTest.planRow(0, CalcPhysicalRel.class), RelPrunabilityTest.planRow(1, AggregateCombineByKeyPhysicalRel.class), RelPrunabilityTest.planRow(2, AggregateAccumulateByKeyPhysicalRel.class), RelPrunabilityTest.planRow(3, FullScanPhysicalRel.class)));
        this.query = HazelcastRelMetadataQuery.reuseOrCreate((RelMetadataQuery)RelMetadataQuery.instance());
        Map prunability = this.query.extractPrunability((RelNode)root);
        Assert.assertEquals(Collections.emptyMap(), (Object)prunability);
    }

    @Test
    public void test_joinAndCalc_areNotSupported() {
        PhysicalRel root = this.optimizePhysical("SELECT * FROM m AS m1 JOIN m AS m2 ON m1.comp1 = m2.comp1 WHERE m1.comp1 = 10 AND m1.this IS NOT NULL     AND m2.comp1 = 10 AND m2.this IS NOT NULL", Arrays.asList(QueryDataType.BIGINT, QueryDataType.VARCHAR), this.table).getPhysical();
        RelPrunabilityTest.assertPlan((RelNode)root, RelPrunabilityTest.plan(RelPrunabilityTest.planRow(0, JoinNestedLoopPhysicalRel.class), RelPrunabilityTest.planRow(1, FullScanPhysicalRel.class), RelPrunabilityTest.planRow(1, FullScanPhysicalRel.class)));
        this.query = HazelcastRelMetadataQuery.reuseOrCreate((RelMetadataQuery)RelMetadataQuery.instance());
        Map prunability = this.query.extractPrunability((RelNode)root);
        Assert.assertEquals(Collections.emptyMap(), (Object)prunability);
    }

    @Test
    public void test_union() {
        PhysicalRel root = this.optimizePhysical("(SELECT * FROM m WHERE comp1 = 10 AND this IS NOT NULL) UNION ALL (SELECT * FROM m WHERE comp1 = 10 AND this IS NULL)", Arrays.asList(QueryDataType.BIGINT, QueryDataType.VARCHAR), this.table).getPhysical();
        RelPrunabilityTest.assertPlan((RelNode)root, RelPrunabilityTest.plan(RelPrunabilityTest.planRow(0, UnionPhysicalRel.class), RelPrunabilityTest.planRow(1, FullScanPhysicalRel.class), RelPrunabilityTest.planRow(1, FullScanPhysicalRel.class)));
        this.query = HazelcastRelMetadataQuery.reuseOrCreate((RelMetadataQuery)RelMetadataQuery.instance());
        Map prunability = this.query.extractPrunability((RelNode)root);
        RexLiteral l = HazelcastRexBuilder.INSTANCE.makeLiteral((Object)10, REL_TYPE_BIGINT);
        Assert.assertEquals(Map.of(MAP_NAME, Arrays.asList(Map.of("comp1", l), Map.of("comp1", l))), (Object)prunability);
    }

    @Test
    public void shouldNotForwardPrunability_whenOneBranchIsNotPrunable() {
        PhysicalRel root = this.optimizePhysical("(SELECT * FROM m WHERE comp1 = 10 AND this IS NOT NULL) UNION ALL (SELECT * FROM m WHERE comp0 = 10 AND this IS NULL)", Arrays.asList(QueryDataType.BIGINT, QueryDataType.VARCHAR), this.table).getPhysical();
        RelPrunabilityTest.assertPlan((RelNode)root, RelPrunabilityTest.plan(RelPrunabilityTest.planRow(0, UnionPhysicalRel.class), RelPrunabilityTest.planRow(1, FullScanPhysicalRel.class), RelPrunabilityTest.planRow(1, FullScanPhysicalRel.class)));
        this.query = HazelcastRelMetadataQuery.reuseOrCreate((RelMetadataQuery)RelMetadataQuery.instance());
        Map prunability = this.query.extractPrunability((RelNode)root);
        Assert.assertEquals(Map.of(), (Object)prunability);
    }

    static class CompoundKey {
        public Integer comp0;
        public Integer comp1;

        CompoundKey(Integer comp0, Integer comp1) {
            this.comp0 = comp0;
            this.comp1 = comp1;
        }
    }
}

