/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.prunability;

import com.hazelcast.jet.sql.impl.opt.OptimizerTestSupport;
import com.hazelcast.jet.sql.impl.opt.prunability.PartitionStrategyConditionExtractor;
import com.hazelcast.jet.sql.impl.validate.HazelcastSqlOperatorTable;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastTypeFactory;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataTypeFactory;
import com.hazelcast.shaded.org.apache.calcite.rex.RexBuilder;
import com.hazelcast.shaded.org.apache.calcite.rex.RexCall;
import com.hazelcast.shaded.org.apache.calcite.rex.RexDynamicParam;
import com.hazelcast.shaded.org.apache.calcite.rex.RexInputRef;
import com.hazelcast.shaded.org.apache.calcite.rex.RexLiteral;
import com.hazelcast.shaded.org.apache.calcite.rex.RexNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.schema.Table;
import com.hazelcast.sql.impl.schema.map.PartitionedMapTable;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class PSConditionExtractorTest
extends OptimizerTestSupport {
    private PartitionStrategyConditionExtractor extractor;
    private HazelcastTypeFactory typeFactory;

    @Before
    public void setUp() throws Exception {
        this.extractor = new PartitionStrategyConditionExtractor();
        this.typeFactory = HazelcastTypeFactory.INSTANCE;
    }

    @Test
    public void test_singleEquals() {
        Table table = PSConditionExtractorTest.partitionedTable("m", Arrays.asList(PSConditionExtractorTest.mapField(QueryPath.KEY, QueryDataType.INT, QueryPath.KEY_PATH), PSConditionExtractorTest.mapField(QueryPath.VALUE, QueryDataType.VARCHAR, QueryPath.VALUE_PATH)), Collections.emptyList(), 10L, Collections.emptyList(), true).getTarget();
        RexBuilder b = new RexBuilder((RelDataTypeFactory)this.typeFactory);
        RexInputRef leftInputRef = b.makeInputRef(this.typeFactory.createSqlType(SqlTypeName.INTEGER), 0);
        RexLiteral rexLiteral = b.makeLiteral("1");
        RexCall call = (RexCall)b.makeCall((SqlOperator)HazelcastSqlOperatorTable.EQUALS, new RexNode[]{leftInputRef, rexLiteral});
        Map decomposedConds = this.extractor.extractCondition(table, call, Set.of(QueryPath.KEY));
        Assert.assertEquals(Map.of("m", Collections.singletonList(Map.of("__key", rexLiteral))), (Object)decomposedConds);
    }

    @Test
    public void test_multiEqualsAndWithCompleteFilter() {
        PartitionedMapTable table = (PartitionedMapTable)PSConditionExtractorTest.partitionedTable("m", Arrays.asList(PSConditionExtractorTest.mapField("comp0", QueryDataType.BIGINT, QueryPath.create((String)(QueryPath.KEY_PREFIX + "comp1"))), PSConditionExtractorTest.mapField("comp1", QueryDataType.BIGINT, QueryPath.create((String)(QueryPath.KEY_PREFIX + "comp2"))), PSConditionExtractorTest.mapField("comp2", QueryDataType.BIGINT, QueryPath.create((String)(QueryPath.KEY_PREFIX + "comp3"))), PSConditionExtractorTest.mapField(QueryPath.KEY, QueryDataType.OBJECT, QueryPath.KEY_PATH), PSConditionExtractorTest.mapField(QueryPath.VALUE, QueryDataType.VARCHAR, QueryPath.VALUE_PATH)), Collections.emptyList(), 10L, Arrays.asList("comp1", "comp2"), true).getTarget();
        RexBuilder b = new RexBuilder((RelDataTypeFactory)this.typeFactory);
        RexDynamicParam param0 = b.makeDynamicParam(this.typeFactory.createSqlType(SqlTypeName.BIGINT), 0);
        RexDynamicParam param1 = b.makeDynamicParam(this.typeFactory.createSqlType(SqlTypeName.BIGINT), 1);
        RexDynamicParam param2 = b.makeDynamicParam(this.typeFactory.createSqlType(SqlTypeName.BIGINT), 2);
        RexInputRef col0 = b.makeInputRef(this.typeFactory.createSqlType(SqlTypeName.BIGINT), 0);
        RexInputRef col1 = b.makeInputRef(this.typeFactory.createSqlType(SqlTypeName.BIGINT), 1);
        RexInputRef col2 = b.makeInputRef(this.typeFactory.createSqlType(SqlTypeName.BIGINT), 2);
        RexCall filter = (RexCall)b.makeCall((SqlOperator)HazelcastSqlOperatorTable.AND, new RexNode[]{b.makeCall((SqlOperator)HazelcastSqlOperatorTable.EQUALS, new RexNode[]{col0, param2}), b.makeCall((SqlOperator)HazelcastSqlOperatorTable.EQUALS, new RexNode[]{col1, param1}), b.makeCall((SqlOperator)HazelcastSqlOperatorTable.EQUALS, new RexNode[]{col2, param0})});
        Map decomposedConds = this.extractor.extractCondition((Table)table, filter, Set.of("comp1", "comp2"));
        Assert.assertEquals(Map.of("m", Collections.singletonList(Map.of("comp1", param1, "comp2", param0))), (Object)decomposedConds);
    }

    @Test
    public void whenOrConditionIsPresent_thenReturnNoVariants() {
        PartitionedMapTable table = (PartitionedMapTable)PSConditionExtractorTest.partitionedTable("m", Arrays.asList(PSConditionExtractorTest.mapField("comp0", QueryDataType.BIGINT, QueryPath.create((String)(QueryPath.KEY_PREFIX + "comp1"))), PSConditionExtractorTest.mapField("comp1", QueryDataType.BIGINT, QueryPath.create((String)(QueryPath.KEY_PREFIX + "comp2"))), PSConditionExtractorTest.mapField("comp2", QueryDataType.BIGINT, QueryPath.create((String)(QueryPath.KEY_PREFIX + "comp3"))), PSConditionExtractorTest.mapField(QueryPath.KEY, QueryDataType.OBJECT, QueryPath.KEY_PATH), PSConditionExtractorTest.mapField(QueryPath.VALUE, QueryDataType.VARCHAR, QueryPath.VALUE_PATH)), Collections.emptyList(), 10L, Arrays.asList("comp1", "comp2"), true).getTarget();
        RexBuilder b = new RexBuilder((RelDataTypeFactory)this.typeFactory);
        RexDynamicParam param0 = b.makeDynamicParam(this.typeFactory.createSqlType(SqlTypeName.BIGINT), 0);
        RexDynamicParam param1 = b.makeDynamicParam(this.typeFactory.createSqlType(SqlTypeName.BIGINT), 1);
        RexDynamicParam param2 = b.makeDynamicParam(this.typeFactory.createSqlType(SqlTypeName.BIGINT), 2);
        RexInputRef col0 = b.makeInputRef(this.typeFactory.createSqlType(SqlTypeName.BIGINT), 0);
        RexInputRef col1 = b.makeInputRef(this.typeFactory.createSqlType(SqlTypeName.BIGINT), 1);
        RexInputRef col2 = b.makeInputRef(this.typeFactory.createSqlType(SqlTypeName.BIGINT), 2);
        RexCall filter = (RexCall)b.makeCall((SqlOperator)HazelcastSqlOperatorTable.OR, new RexNode[]{b.makeCall((SqlOperator)HazelcastSqlOperatorTable.EQUALS, new RexNode[]{col0, param2}), b.makeCall((SqlOperator)HazelcastSqlOperatorTable.EQUALS, new RexNode[]{col1, param1}), b.makeCall((SqlOperator)HazelcastSqlOperatorTable.EQUALS, new RexNode[]{col2, param0})});
        Map decomposedConds = this.extractor.extractCondition((Table)table, filter, Set.of("comp1", "comp2"));
        Assert.assertEquals((long)0L, (long)decomposedConds.size());
    }

    @Test
    public void whenConditionIsIncomplete_thenReturnNoVariants() {
        PartitionedMapTable table = (PartitionedMapTable)PSConditionExtractorTest.partitionedTable("m", Arrays.asList(PSConditionExtractorTest.mapField("comp0", QueryDataType.BIGINT, QueryPath.create((String)(QueryPath.KEY_PREFIX + "comp1"))), PSConditionExtractorTest.mapField("comp1", QueryDataType.BIGINT, QueryPath.create((String)(QueryPath.KEY_PREFIX + "comp2"))), PSConditionExtractorTest.mapField("comp2", QueryDataType.BIGINT, QueryPath.create((String)(QueryPath.KEY_PREFIX + "comp3"))), PSConditionExtractorTest.mapField(QueryPath.KEY, QueryDataType.OBJECT, QueryPath.KEY_PATH), PSConditionExtractorTest.mapField(QueryPath.VALUE, QueryDataType.VARCHAR, QueryPath.VALUE_PATH)), Collections.emptyList(), 10L, Arrays.asList("comp1", "comp2"), true).getTarget();
        RexBuilder b = new RexBuilder((RelDataTypeFactory)this.typeFactory);
        RexDynamicParam param0 = b.makeDynamicParam(this.typeFactory.createSqlType(SqlTypeName.BIGINT), 0);
        RexDynamicParam param2 = b.makeDynamicParam(this.typeFactory.createSqlType(SqlTypeName.BIGINT), 2);
        RexInputRef col0 = b.makeInputRef(this.typeFactory.createSqlType(SqlTypeName.BIGINT), 0);
        RexInputRef col2 = b.makeInputRef(this.typeFactory.createSqlType(SqlTypeName.BIGINT), 2);
        RexCall filter = (RexCall)b.makeCall((SqlOperator)HazelcastSqlOperatorTable.AND, new RexNode[]{b.makeCall((SqlOperator)HazelcastSqlOperatorTable.EQUALS, new RexNode[]{col0, param2}), b.makeCall((SqlOperator)HazelcastSqlOperatorTable.EQUALS, new RexNode[]{col2, param0})});
        Map decomposedConds = this.extractor.extractCondition((Table)table, filter, Set.of("comp1", "comp2"));
        Assert.assertEquals((long)0L, (long)decomposedConds.size());
    }
}

