/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.logical;

import com.hazelcast.jet.sql.impl.opt.OptUtils;
import com.hazelcast.jet.sql.impl.opt.OptimizerTestSupport;
import com.hazelcast.jet.sql.impl.opt.logical.FullScanLogicalRel;
import com.hazelcast.jet.sql.impl.opt.logical.LogicalRel;
import com.hazelcast.jet.sql.impl.opt.logical.UpdateByKeyMapLogicalRel;
import com.hazelcast.jet.sql.impl.opt.logical.UpdateLogicalRel;
import com.hazelcast.jet.sql.impl.opt.logical.ValuesLogicalRel;
import com.hazelcast.jet.sql.impl.schema.HazelcastTable;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.shaded.org.apache.calcite.rex.RexInputRef;
import com.hazelcast.shaded.org.apache.calcite.rex.RexNode;
import com.hazelcast.shaded.org.apache.calcite.rex.RexVisitor;
import com.hazelcast.shaded.org.apache.calcite.rex.RexVisitorImpl;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import junitparams.JUnitParamsRunner;
import junitparams.Parameters;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JUnitParamsRunner.class)
public class LogicalUpdateTest
extends OptimizerTestSupport {
    @BeforeClass
    public static void setUpClass() {
        LogicalUpdateTest.initialize((int)1, null);
    }

    @Test
    public void test_requiresJob() {
        HazelcastTable table = LogicalUpdateTest.partitionedTable("m", Arrays.asList(LogicalUpdateTest.field(QueryPath.KEY, QueryDataType.INT), LogicalUpdateTest.field(QueryPath.VALUE, QueryDataType.VARCHAR)), 0L);
        LogicalUpdateTest.assertImapUpdateWithScanPlan((RelNode)this.optimizeLogical("UPDATE m SET this = '2' WHERE __key = 1", true, table), LogicalUpdateTest.plan(LogicalUpdateTest.planRow(0, UpdateLogicalRel.class), LogicalUpdateTest.planRow(1, FullScanLogicalRel.class)));
    }

    @Test
    public void test_updateWithoutWhere() {
        HazelcastTable table = LogicalUpdateTest.partitionedTable("m", Arrays.asList(LogicalUpdateTest.field(QueryPath.KEY, QueryDataType.INT), LogicalUpdateTest.field(QueryPath.VALUE, QueryDataType.VARCHAR)), 10L);
        LogicalRel logicalRel = this.optimizeLogical("UPDATE m SET this = '2'", table);
        LogicalUpdateTest.assertImapUpdateWithScanPlan((RelNode)logicalRel, LogicalUpdateTest.plan(LogicalUpdateTest.planRow(0, UpdateLogicalRel.class), LogicalUpdateTest.planRow(1, FullScanLogicalRel.class)));
    }

    @Test
    public void test_updateComplexKeyWithoutWhere() {
        HazelcastTable table = LogicalUpdateTest.complexKeyTable();
        LogicalRel logicalRel = this.optimizeLogical("UPDATE m SET this = '2'", table);
        LogicalUpdateTest.assertImapUpdateWithScanPlan((RelNode)logicalRel, LogicalUpdateTest.plan(LogicalUpdateTest.planRow(0, UpdateLogicalRel.class), LogicalUpdateTest.planRow(1, FullScanLogicalRel.class)), 2);
    }

    @Test
    public void test_updateComplexKeyWithoutWhereWithExpression() {
        HazelcastTable table = LogicalUpdateTest.complexKeyTable();
        LogicalRel logicalRel = this.optimizeLogical("UPDATE m SET this = TO_CHAR(k_field2, '9')", table);
        LogicalUpdateTest.assertImapUpdateWithScanPlan((RelNode)logicalRel, LogicalUpdateTest.plan(LogicalUpdateTest.planRow(0, UpdateLogicalRel.class), LogicalUpdateTest.planRow(1, FullScanLogicalRel.class)), 2);
        final boolean[] inputRefFound = new boolean[1];
        ((RexNode)((UpdateLogicalRel)logicalRel).getSourceExpressionList().get(0)).accept((RexVisitor)new RexVisitorImpl<Object>(true){

            public Object visitInputRef(RexInputRef inputRef) {
                Assertions.assertThat((int)inputRef.getIndex()).isEqualTo(1);
                inputRefFound[0] = true;
                return null;
            }
        });
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)inputRefFound[0]).as("Should reference input parameter", new Object[0])).isTrue();
    }

    @Test
    public void test_updateComplexKeyByKeyField() {
        HazelcastTable table = LogicalUpdateTest.partitionedTable("m", Arrays.asList(LogicalUpdateTest.field("k_field1", QueryDataType.INT), LogicalUpdateTest.field("k_field2", QueryDataType.VARCHAR), LogicalUpdateTest.field(QueryPath.KEY, QueryDataType.OBJECT), LogicalUpdateTest.field(QueryPath.VALUE, QueryDataType.VARCHAR)), 10L);
        LogicalRel logicalRel = this.optimizeLogical("UPDATE m SET k_field2 = '2'", table);
        LogicalUpdateTest.assertImapUpdateWithScanPlan((RelNode)logicalRel, LogicalUpdateTest.plan(LogicalUpdateTest.planRow(0, UpdateLogicalRel.class), LogicalUpdateTest.planRow(1, FullScanLogicalRel.class)), 2);
    }

    @Test
    public void test_updateByValue() {
        HazelcastTable table = LogicalUpdateTest.partitionedTable("m", Arrays.asList(LogicalUpdateTest.field(QueryPath.KEY, QueryDataType.INT), LogicalUpdateTest.field(QueryPath.VALUE, QueryDataType.VARCHAR)), 10L);
        LogicalUpdateTest.assertImapUpdateWithScanPlan((RelNode)this.optimizeLogical("UPDATE m SET this = '2' WHERE this = '1'", table), LogicalUpdateTest.plan(LogicalUpdateTest.planRow(0, UpdateLogicalRel.class), LogicalUpdateTest.planRow(1, FullScanLogicalRel.class)));
    }

    @Test
    public void test_updateByKeyAndValue() {
        HazelcastTable table = LogicalUpdateTest.partitionedTable("m", Arrays.asList(LogicalUpdateTest.field(QueryPath.KEY, QueryDataType.INT), LogicalUpdateTest.field(QueryPath.VALUE, QueryDataType.VARCHAR)), 10L);
        LogicalUpdateTest.assertImapUpdateWithScanPlan((RelNode)this.optimizeLogical("UPDATE m SET this = '2' WHERE __key = 1 AND this = '1'", table), LogicalUpdateTest.plan(LogicalUpdateTest.planRow(0, UpdateLogicalRel.class), LogicalUpdateTest.planRow(1, FullScanLogicalRel.class)));
    }

    @Test
    public void test_updateByKeyAndKey() {
        HazelcastTable table = LogicalUpdateTest.partitionedTable("m", Arrays.asList(LogicalUpdateTest.field(QueryPath.KEY, QueryDataType.INT), LogicalUpdateTest.field(QueryPath.VALUE, QueryDataType.VARCHAR)), 10L);
        LogicalUpdateTest.assertPlan((RelNode)this.optimizeLogical("UPDATE m SET this = '2' WHERE __key = 1 AND __key = 2", table), LogicalUpdateTest.plan(LogicalUpdateTest.planRow(0, UpdateLogicalRel.class), LogicalUpdateTest.planRow(1, ValuesLogicalRel.class)));
    }

    @Test
    public void test_updateByKeyOrKey() {
        HazelcastTable table = LogicalUpdateTest.partitionedTable("m", Arrays.asList(LogicalUpdateTest.field(QueryPath.KEY, QueryDataType.INT), LogicalUpdateTest.field(QueryPath.VALUE, QueryDataType.VARCHAR)), 10L);
        LogicalUpdateTest.assertImapUpdateWithScanPlan((RelNode)this.optimizeLogical("UPDATE m SET this = '2' WHERE __key = 1 OR __key = 2", table), LogicalUpdateTest.plan(LogicalUpdateTest.planRow(0, UpdateLogicalRel.class), LogicalUpdateTest.planRow(1, FullScanLogicalRel.class)));
    }

    @Test
    public void test_updateWithConstantCondition() {
        HazelcastTable table = LogicalUpdateTest.partitionedTable("m", Arrays.asList(LogicalUpdateTest.field(QueryPath.KEY, QueryDataType.INT), LogicalUpdateTest.field(QueryPath.VALUE, QueryDataType.VARCHAR)), 10L);
        LogicalUpdateTest.assertImapUpdateWithScanPlan((RelNode)this.optimizeLogical("UPDATE m SET this = '2' WHERE 1 = 1", table), LogicalUpdateTest.plan(LogicalUpdateTest.planRow(0, UpdateLogicalRel.class), LogicalUpdateTest.planRow(1, FullScanLogicalRel.class)));
    }

    private Object[] literals() {
        return new Object[]{new Object[]{QueryDataType.BOOLEAN, "true"}, new Object[]{QueryDataType.BOOLEAN, "false"}, new Object[]{QueryDataType.TINYINT, Character.valueOf('1')}, new Object[]{QueryDataType.SMALLINT, Character.valueOf('1')}, new Object[]{QueryDataType.INT, Character.valueOf('1')}, new Object[]{QueryDataType.BIGINT, Character.valueOf('1')}, new Object[]{QueryDataType.DECIMAL, Character.valueOf('1')}, new Object[]{QueryDataType.REAL, Character.valueOf('1')}, new Object[]{QueryDataType.DOUBLE, Character.valueOf('1')}, new Object[]{QueryDataType.VARCHAR, "'string'"}, new Object[]{QueryDataType.TIME, "'12:23:34'"}, new Object[]{QueryDataType.DATE, "'2021-07-01'"}, new Object[]{QueryDataType.TIMESTAMP, "'2021-07-01T12:23:34'"}, new Object[]{QueryDataType.TIMESTAMP_WITH_TZ_OFFSET_DATE_TIME, "'2021-07-01T12:23:34Z'"}, new Object[]{QueryDataType.OBJECT, "CAST(1 AS OBJECT)"}};
    }

    @Test
    @Parameters(method="literals")
    public void test_updateByKeyWithLiteral(QueryDataType type, String literalValue) {
        HazelcastTable table = LogicalUpdateTest.partitionedTable("m", Arrays.asList(LogicalUpdateTest.field(QueryPath.KEY, type), LogicalUpdateTest.field(QueryPath.VALUE, QueryDataType.VARCHAR)), 1L);
        LogicalUpdateTest.assertPlan((RelNode)this.optimizeLogical("UPDATE m SET this = '2' WHERE __key = " + literalValue, table), LogicalUpdateTest.plan(LogicalUpdateTest.planRow(0, UpdateByKeyMapLogicalRel.class)));
        LogicalUpdateTest.assertPlan((RelNode)this.optimizeLogical("UPDATE m SET this = '2' WHERE " + literalValue + " = __key", table), LogicalUpdateTest.plan(LogicalUpdateTest.planRow(0, UpdateByKeyMapLogicalRel.class)));
    }

    @Test
    public void test_updateByKeyWithLiteralExpression() {
        HazelcastTable table = LogicalUpdateTest.partitionedTable("m", Arrays.asList(LogicalUpdateTest.field(QueryPath.KEY, QueryDataType.INT), LogicalUpdateTest.field(QueryPath.VALUE, QueryDataType.VARCHAR)), 1L);
        LogicalUpdateTest.assertPlan((RelNode)this.optimizeLogical("UPDATE m SET this = '2' WHERE __key = 1 + 1", table), LogicalUpdateTest.plan(LogicalUpdateTest.planRow(0, UpdateByKeyMapLogicalRel.class)));
    }

    private Object[] types() {
        return new Object[]{new Object[]{QueryDataType.BOOLEAN}, new Object[]{QueryDataType.TINYINT}, new Object[]{QueryDataType.SMALLINT}, new Object[]{QueryDataType.INT}, new Object[]{QueryDataType.BIGINT}, new Object[]{QueryDataType.DECIMAL}, new Object[]{QueryDataType.REAL}, new Object[]{QueryDataType.DOUBLE}, new Object[]{QueryDataType.VARCHAR}, new Object[]{QueryDataType.TIME}, new Object[]{QueryDataType.DATE}, new Object[]{QueryDataType.TIMESTAMP}, new Object[]{QueryDataType.TIMESTAMP_WITH_TZ_OFFSET_DATE_TIME}, new Object[]{QueryDataType.OBJECT}};
    }

    @Test
    @Parameters(method="types")
    public void test_updateByKeyWithDynamicParam(QueryDataType type) {
        HazelcastTable table = LogicalUpdateTest.partitionedTable("m", Arrays.asList(LogicalUpdateTest.field(QueryPath.KEY, type), LogicalUpdateTest.field(QueryPath.VALUE, QueryDataType.VARCHAR)), 1L);
        LogicalUpdateTest.assertPlan((RelNode)this.optimizeLogical("UPDATE m SET this = '2' WHERE __key = ?", table), LogicalUpdateTest.plan(LogicalUpdateTest.planRow(0, UpdateByKeyMapLogicalRel.class)));
    }

    @Test
    public void test_updateByKeyWithDynamicParamAndImplicitCastOnKey() {
        HazelcastTable table = LogicalUpdateTest.partitionedTable("m", Arrays.asList(LogicalUpdateTest.field(QueryPath.KEY, QueryDataType.INT), LogicalUpdateTest.field(QueryPath.VALUE, QueryDataType.VARCHAR)), 1L);
        LogicalUpdateTest.assertImapUpdateWithScanPlan((RelNode)this.optimizeLogical("UPDATE m SET this = '2' WHERE __key = ? + 1", table), LogicalUpdateTest.plan(LogicalUpdateTest.planRow(0, UpdateLogicalRel.class), LogicalUpdateTest.planRow(1, FullScanLogicalRel.class)));
    }

    @Test
    public void test_updateByKeyWithDynamicParamExpression() {
        HazelcastTable table = LogicalUpdateTest.partitionedTable("m", Arrays.asList(LogicalUpdateTest.field(QueryPath.KEY, QueryDataType.INT), LogicalUpdateTest.field(QueryPath.VALUE, QueryDataType.VARCHAR)), 1L);
        LogicalUpdateTest.assertPlan((RelNode)this.optimizeLogical("UPDATE m SET this = '2' WHERE __key = CAST(? + 1 AS INT)", table), LogicalUpdateTest.plan(LogicalUpdateTest.planRow(0, UpdateByKeyMapLogicalRel.class)));
    }

    @Nonnull
    static HazelcastTable complexKeyTable() {
        return LogicalUpdateTest.partitionedTable("m", Arrays.asList(LogicalUpdateTest.field("k_field1", QueryDataType.INT), LogicalUpdateTest.field("k_field2", QueryDataType.INT), LogicalUpdateTest.field(QueryPath.KEY, QueryDataType.OBJECT), LogicalUpdateTest.field(QueryPath.VALUE, QueryDataType.VARCHAR)), 10L);
    }

    static void assertImapUpdateWithScanPlan(RelNode rel, OptimizerTestSupport.PlanRows expected) {
        LogicalUpdateTest.assertImapUpdateWithScanPlan(rel, expected, 0);
    }

    static void assertImapUpdateWithScanPlan(RelNode rel, OptimizerTestSupport.PlanRows expected, int keyFields) {
        LogicalUpdateTest.assertPlan(rel, expected);
        HazelcastTable updateInputTable = OptUtils.extractHazelcastTable((RelNode)rel.getInput(0));
        LogicalUpdateTest.assertThatScanProjectsOnlyKey(updateInputTable, keyFields);
    }

    static void assertThatScanProjectsOnlyKey(HazelcastTable updateInputTable, int keyFields) {
        ((ObjectAssert)((ListAssert)((ListAssert)Assertions.assertThat((List)updateInputTable.getProjects()).as("IMap should project only key for update", new Object[0])).hasSize(1)).element(0)).isInstanceOfSatisfying(RexInputRef.class, input -> ((AbstractIntegerAssert)Assertions.assertThat((int)input.getIndex()).as("Should project __key", new Object[0])).isEqualTo(keyFields));
    }
}

