/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.logical;

import com.hazelcast.jet.sql.impl.opt.OptUtils;
import com.hazelcast.jet.sql.impl.opt.OptimizerTestSupport;
import com.hazelcast.jet.sql.impl.opt.logical.DeleteByKeyMapLogicalRel;
import com.hazelcast.jet.sql.impl.opt.logical.DeleteLogicalRel;
import com.hazelcast.jet.sql.impl.opt.logical.FullScanLogicalRel;
import com.hazelcast.jet.sql.impl.opt.logical.LogicalRel;
import com.hazelcast.jet.sql.impl.opt.logical.LogicalUpdateTest;
import com.hazelcast.jet.sql.impl.opt.logical.ValuesLogicalRel;
import com.hazelcast.jet.sql.impl.schema.HazelcastTable;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.shaded.org.apache.calcite.rex.RexInputRef;
import com.hazelcast.shaded.org.apache.calcite.rex.RexVisitor;
import com.hazelcast.shaded.org.apache.calcite.rex.RexVisitorImpl;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.Arrays;
import junitparams.JUnitParamsRunner;
import junitparams.Parameters;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JUnitParamsRunner.class)
public class LogicalDeleteTest
extends OptimizerTestSupport {
    @BeforeClass
    public static void setUpClass() {
        LogicalDeleteTest.initialize((int)1, null);
    }

    @Test
    public void test_requiresJob() {
        HazelcastTable table = LogicalDeleteTest.partitionedTable("m", Arrays.asList(LogicalDeleteTest.field(QueryPath.KEY, QueryDataType.INT), LogicalDeleteTest.field(QueryPath.VALUE, QueryDataType.VARCHAR)), 0L);
        LogicalUpdateTest.assertImapUpdateWithScanPlan((RelNode)this.optimizeLogical("DELETE FROM m WHERE __key = 1", true, table), LogicalDeleteTest.plan(LogicalDeleteTest.planRow(0, DeleteLogicalRel.class), LogicalDeleteTest.planRow(1, FullScanLogicalRel.class)));
    }

    @Test
    public void test_deleteWithoutWhere() {
        HazelcastTable table = LogicalDeleteTest.partitionedTable("m", Arrays.asList(LogicalDeleteTest.field(QueryPath.KEY, QueryDataType.INT), LogicalDeleteTest.field(QueryPath.VALUE, QueryDataType.VARCHAR)), 10L);
        LogicalUpdateTest.assertImapUpdateWithScanPlan((RelNode)this.optimizeLogical("DELETE FROM m", table), LogicalDeleteTest.plan(LogicalDeleteTest.planRow(0, DeleteLogicalRel.class), LogicalDeleteTest.planRow(1, FullScanLogicalRel.class)));
    }

    @Test
    public void test_deleteComplexKeyWithoutWhere() {
        HazelcastTable table = LogicalUpdateTest.complexKeyTable();
        LogicalUpdateTest.assertImapUpdateWithScanPlan((RelNode)this.optimizeLogical("DELETE FROM m", table), LogicalDeleteTest.plan(LogicalDeleteTest.planRow(0, DeleteLogicalRel.class), LogicalDeleteTest.planRow(1, FullScanLogicalRel.class)), 2);
    }

    @Test
    public void test_deleteComplexKeyWithoutWhereWithExpression() {
        HazelcastTable table = LogicalUpdateTest.complexKeyTable();
        LogicalRel logicalRel = this.optimizeLogical("DELETE FROM m WHERE this = TO_CHAR(k_field2, '9')", table);
        LogicalUpdateTest.assertImapUpdateWithScanPlan((RelNode)logicalRel, LogicalDeleteTest.plan(LogicalDeleteTest.planRow(0, DeleteLogicalRel.class), LogicalDeleteTest.planRow(1, FullScanLogicalRel.class)), 2);
        final int[] inputRefFound = new int[1];
        OptUtils.extractHazelcastTable((RelNode)logicalRel.getInput(0)).getFilter().accept((RexVisitor)new RexVisitorImpl<Object>(true){

            public Object visitInputRef(RexInputRef inputRef) {
                Assertions.assertThat((int)inputRef.getIndex()).isIn(new Object[]{1, 3});
                inputRefFound[0] = inputRefFound[0] + 1;
                return null;
            }
        });
        ((AbstractIntegerAssert)Assertions.assertThat((int)inputRefFound[0]).as("Should reference input parameter", new Object[0])).isEqualTo(2);
    }

    @Test
    public void test_deleteComplexKeyByKeyField() {
        HazelcastTable table = LogicalDeleteTest.partitionedTable("m", Arrays.asList(LogicalDeleteTest.field("k_field1", QueryDataType.INT), LogicalDeleteTest.field("k_field2", QueryDataType.VARCHAR), LogicalDeleteTest.field(QueryPath.KEY, QueryDataType.OBJECT), LogicalDeleteTest.field(QueryPath.VALUE, QueryDataType.VARCHAR)), 10L);
        LogicalRel logicalRel = this.optimizeLogical("DELETE FROM m WHERE k_field2 = '2'", table);
        LogicalUpdateTest.assertImapUpdateWithScanPlan((RelNode)logicalRel, LogicalDeleteTest.plan(LogicalDeleteTest.planRow(0, DeleteLogicalRel.class), LogicalDeleteTest.planRow(1, FullScanLogicalRel.class)), 2);
    }

    @Test
    public void test_deleteByValue() {
        HazelcastTable table = LogicalDeleteTest.partitionedTable("m", Arrays.asList(LogicalDeleteTest.field(QueryPath.KEY, QueryDataType.INT), LogicalDeleteTest.field(QueryPath.VALUE, QueryDataType.VARCHAR)), 10L);
        LogicalUpdateTest.assertImapUpdateWithScanPlan((RelNode)this.optimizeLogical("DELETE FROM m WHERE this = '1'", table), LogicalDeleteTest.plan(LogicalDeleteTest.planRow(0, DeleteLogicalRel.class), LogicalDeleteTest.planRow(1, FullScanLogicalRel.class)));
    }

    @Test
    public void test_deleteByKeyAndValue() {
        HazelcastTable table = LogicalDeleteTest.partitionedTable("m", Arrays.asList(LogicalDeleteTest.field(QueryPath.KEY, QueryDataType.INT), LogicalDeleteTest.field(QueryPath.VALUE, QueryDataType.VARCHAR)), 10L);
        LogicalUpdateTest.assertImapUpdateWithScanPlan((RelNode)this.optimizeLogical("DELETE FROM m WHERE __key = 1 AND this = '1'", table), LogicalDeleteTest.plan(LogicalDeleteTest.planRow(0, DeleteLogicalRel.class), LogicalDeleteTest.planRow(1, FullScanLogicalRel.class)));
    }

    @Test
    public void test_deleteByKeyAndKey() {
        HazelcastTable table = LogicalDeleteTest.partitionedTable("m", Arrays.asList(LogicalDeleteTest.field(QueryPath.KEY, QueryDataType.INT), LogicalDeleteTest.field(QueryPath.VALUE, QueryDataType.VARCHAR)), 10L);
        LogicalDeleteTest.assertPlan((RelNode)this.optimizeLogical("DELETE FROM m WHERE __key = 1 AND __key = 2", table), LogicalDeleteTest.plan(LogicalDeleteTest.planRow(0, DeleteLogicalRel.class), LogicalDeleteTest.planRow(1, ValuesLogicalRel.class)));
    }

    @Test
    public void test_deleteByKeyOrKey() {
        HazelcastTable table = LogicalDeleteTest.partitionedTable("m", Arrays.asList(LogicalDeleteTest.field(QueryPath.KEY, QueryDataType.INT), LogicalDeleteTest.field(QueryPath.VALUE, QueryDataType.VARCHAR)), 10L);
        LogicalUpdateTest.assertImapUpdateWithScanPlan((RelNode)this.optimizeLogical("DELETE FROM m WHERE __key = 1 OR __key = 2", table), LogicalDeleteTest.plan(LogicalDeleteTest.planRow(0, DeleteLogicalRel.class), LogicalDeleteTest.planRow(1, FullScanLogicalRel.class)));
    }

    @Test
    public void test_deleteWithConstantCondition() {
        HazelcastTable table = LogicalDeleteTest.partitionedTable("m", Arrays.asList(LogicalDeleteTest.field(QueryPath.KEY, QueryDataType.INT), LogicalDeleteTest.field(QueryPath.VALUE, QueryDataType.VARCHAR)), 10L);
        LogicalUpdateTest.assertImapUpdateWithScanPlan((RelNode)this.optimizeLogical("DELETE FROM m WHERE 1 = 1", table), LogicalDeleteTest.plan(LogicalDeleteTest.planRow(0, DeleteLogicalRel.class), LogicalDeleteTest.planRow(1, FullScanLogicalRel.class)));
    }

    private Object[] literals() {
        return new Object[]{new Object[]{QueryDataType.BOOLEAN, "true"}, new Object[]{QueryDataType.BOOLEAN, "false"}, new Object[]{QueryDataType.TINYINT, Character.valueOf('1')}, new Object[]{QueryDataType.SMALLINT, Character.valueOf('1')}, new Object[]{QueryDataType.INT, Character.valueOf('1')}, new Object[]{QueryDataType.BIGINT, Character.valueOf('1')}, new Object[]{QueryDataType.DECIMAL, Character.valueOf('1')}, new Object[]{QueryDataType.REAL, Character.valueOf('1')}, new Object[]{QueryDataType.DOUBLE, Character.valueOf('1')}, new Object[]{QueryDataType.VARCHAR, "'string'"}, new Object[]{QueryDataType.TIME, "'12:23:34'"}, new Object[]{QueryDataType.DATE, "'2021-07-01'"}, new Object[]{QueryDataType.TIMESTAMP, "'2021-07-01T12:23:34'"}, new Object[]{QueryDataType.TIMESTAMP_WITH_TZ_OFFSET_DATE_TIME, "'2021-07-01T12:23:34Z'"}, new Object[]{QueryDataType.OBJECT, "CAST(1 AS OBJECT)"}};
    }

    @Test
    @Parameters(method="literals")
    public void test_deleteByKeyWithLiteral(QueryDataType type, String literalValue) {
        HazelcastTable table = LogicalDeleteTest.partitionedTable("m", Arrays.asList(LogicalDeleteTest.field(QueryPath.KEY, type), LogicalDeleteTest.field(QueryPath.VALUE, QueryDataType.VARCHAR)), 1L);
        LogicalDeleteTest.assertPlan((RelNode)this.optimizeLogical("DELETE FROM m WHERE __key = " + literalValue, table), LogicalDeleteTest.plan(LogicalDeleteTest.planRow(0, DeleteByKeyMapLogicalRel.class)));
        LogicalDeleteTest.assertPlan((RelNode)this.optimizeLogical("DELETE FROM m WHERE " + literalValue + " = __key", table), LogicalDeleteTest.plan(LogicalDeleteTest.planRow(0, DeleteByKeyMapLogicalRel.class)));
    }

    @Test
    public void test_deleteByKeyWithLiteralExpression() {
        HazelcastTable table = LogicalDeleteTest.partitionedTable("m", Arrays.asList(LogicalDeleteTest.field(QueryPath.KEY, QueryDataType.INT), LogicalDeleteTest.field(QueryPath.VALUE, QueryDataType.VARCHAR)), 1L);
        LogicalDeleteTest.assertPlan((RelNode)this.optimizeLogical("DELETE FROM m WHERE __key = 1 + 1", table), LogicalDeleteTest.plan(LogicalDeleteTest.planRow(0, DeleteByKeyMapLogicalRel.class)));
    }

    private Object[] types() {
        return new Object[]{new Object[]{QueryDataType.BOOLEAN}, new Object[]{QueryDataType.TINYINT}, new Object[]{QueryDataType.SMALLINT}, new Object[]{QueryDataType.INT}, new Object[]{QueryDataType.BIGINT}, new Object[]{QueryDataType.DECIMAL}, new Object[]{QueryDataType.REAL}, new Object[]{QueryDataType.DOUBLE}, new Object[]{QueryDataType.VARCHAR}, new Object[]{QueryDataType.TIME}, new Object[]{QueryDataType.DATE}, new Object[]{QueryDataType.TIMESTAMP}, new Object[]{QueryDataType.TIMESTAMP_WITH_TZ_OFFSET_DATE_TIME}, new Object[]{QueryDataType.OBJECT}};
    }

    @Test
    @Parameters(method="types")
    public void test_deleteByKeyWithDynamicParam(QueryDataType type) {
        HazelcastTable table = LogicalDeleteTest.partitionedTable("m", Arrays.asList(LogicalDeleteTest.field(QueryPath.KEY, type), LogicalDeleteTest.field(QueryPath.VALUE, QueryDataType.VARCHAR)), 1L);
        LogicalDeleteTest.assertPlan((RelNode)this.optimizeLogical("DELETE FROM m WHERE __key = ?", table), LogicalDeleteTest.plan(LogicalDeleteTest.planRow(0, DeleteByKeyMapLogicalRel.class)));
    }

    @Test
    public void test_deleteByKeyWithDynamicParamAndImplicitCastOnKey() {
        HazelcastTable table = LogicalDeleteTest.partitionedTable("m", Arrays.asList(LogicalDeleteTest.field(QueryPath.KEY, QueryDataType.INT), LogicalDeleteTest.field(QueryPath.VALUE, QueryDataType.VARCHAR)), 1L);
        LogicalUpdateTest.assertImapUpdateWithScanPlan((RelNode)this.optimizeLogical("DELETE FROM m WHERE __key = ? + 1", table), LogicalDeleteTest.plan(LogicalDeleteTest.planRow(0, DeleteLogicalRel.class), LogicalDeleteTest.planRow(1, FullScanLogicalRel.class)));
    }

    @Test
    public void test_deleteByKeyWithDynamicParamExpression() {
        HazelcastTable table = LogicalDeleteTest.partitionedTable("m", Arrays.asList(LogicalDeleteTest.field(QueryPath.KEY, QueryDataType.INT), LogicalDeleteTest.field(QueryPath.VALUE, QueryDataType.VARCHAR)), 1L);
        LogicalDeleteTest.assertPlan((RelNode)this.optimizeLogical("DELETE FROM m WHERE __key = CAST(? + 1 AS INT)", table), LogicalDeleteTest.plan(LogicalDeleteTest.planRow(0, DeleteByKeyMapLogicalRel.class)));
    }
}

