/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.misc;

import com.hazelcast.config.Config;
import com.hazelcast.config.IndexType;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.opt.OptimizerTestSupport;
import com.hazelcast.jet.sql.impl.opt.logical.FullScanLogicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.FullScanPhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.IndexScanMapPhysicalRel;
import com.hazelcast.jet.sql.impl.schema.HazelcastTable;
import com.hazelcast.map.IMap;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.SqlStatement;
import com.hazelcast.sql.impl.SqlServiceImpl;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.map.MapTableField;
import com.hazelcast.sql.impl.schema.map.MapTableUtils;
import com.hazelcast.sql.impl.security.SqlSecurityContext;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.test.HazelcastParametrizedRunner;
import com.hazelcast.test.HazelcastSerialParametersRunnerFactory;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=HazelcastParametrizedRunner.class)
@Parameterized.UseParametersRunnerFactory(value=HazelcastSerialParametersRunnerFactory.class)
public class SqlSecurityCallbackTest
extends OptimizerTestSupport {
    private static final int mapSize = 1000;
    @Parameterized.Parameter
    public boolean useIndex;
    private String mapName;

    @BeforeClass
    public static void beforeClass() {
        SqlSecurityCallbackTest.initialize((int)2, (Config)SqlSecurityCallbackTest.smallInstanceConfig());
    }

    @Parameterized.Parameters(name="useIndex:{0}")
    public static Collection<Object[]> parameters() {
        ArrayList<Object[]> res = new ArrayList<Object[]>();
        res.add(new Boolean[]{false});
        res.add(new Boolean[]{true});
        return res;
    }

    @Before
    public void before() {
        this.mapName = SqlTestSupport.randomName();
        SqlSecurityCallbackTest.createMapping(this.mapName, Integer.TYPE, Integer.TYPE);
        IMap map = SqlSecurityCallbackTest.instance().getMap(this.mapName);
        if (this.useIndex) {
            map.addIndex(IndexType.HASH, new String[]{"this"});
        }
        this.populate(this.mapName, 1000);
    }

    @Test
    public void test() {
        this.check("SELECT * FROM " + this.mapName + " WHERE this = 500", this.useIndex);
    }

    private void check(String sql, boolean useIndex) {
        for (int i = 0; i < 2; ++i) {
            TestSqlSecurityContext securityContext = new TestSqlSecurityContext();
            try (SqlResult ignored = ((SqlServiceImpl)SqlSecurityCallbackTest.instance().getSql()).execute(new SqlStatement(sql), (SqlSecurityContext)securityContext);){
                this.checkIndexUsage(sql, useIndex);
                Assertions.assertThat(securityContext.getPermissions()).contains((Object[])new Permission[]{new MapPermission(this.mapName, new String[]{"read"})});
                continue;
            }
        }
    }

    private void checkIndexUsage(String sql, boolean expectedIndexUsage) {
        List<QueryDataType> parameterTypes = Arrays.asList(QueryDataType.INT, QueryDataType.INT);
        List<TableField> mapTableFields = Arrays.asList(new MapTableField("__key", QueryDataType.INT, false, QueryPath.KEY_PATH), new MapTableField("this", QueryDataType.INT, false, QueryPath.VALUE_PATH));
        HazelcastTable table = SqlSecurityCallbackTest.partitionedTable(this.mapName, mapTableFields, MapTableUtils.getPartitionedMapIndexes((MapContainer)SqlSecurityCallbackTest.mapContainer(SqlSecurityCallbackTest.instance().getMap(this.mapName)), mapTableFields), 1000L);
        OptimizerTestSupport.Result optimizationResult = this.optimizePhysical(sql, parameterTypes, table);
        SqlSecurityCallbackTest.assertPlan((RelNode)optimizationResult.getLogical(), SqlSecurityCallbackTest.plan(SqlSecurityCallbackTest.planRow(0, FullScanLogicalRel.class)));
        SqlSecurityCallbackTest.assertPlan((RelNode)optimizationResult.getPhysical(), SqlSecurityCallbackTest.plan(SqlSecurityCallbackTest.planRow(0, expectedIndexUsage ? IndexScanMapPhysicalRel.class : FullScanPhysicalRel.class)));
    }

    protected void populate(String mapName, int size) {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        for (int i = 0; i < size; ++i) {
            map.put(i, i);
        }
        SqlSecurityCallbackTest.instance().getMap(mapName).putAll(map);
    }

    private static class TestSqlSecurityContext
    implements SqlSecurityContext {
        private final List<Permission> permissions = new ArrayList<Permission>();

        private TestSqlSecurityContext() {
        }

        public boolean isSecurityEnabled() {
            return true;
        }

        public void checkPermission(Permission permission) {
            this.permissions.add(permission);
        }

        @Nullable
        public Subject subject() {
            return null;
        }

        private List<Permission> getPermissions() {
            return this.permissions;
        }
    }
}

