/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.inject;

import com.hazelcast.internal.serialization.ReflectionClassNameFilter;
import com.hazelcast.jet.sql.impl.inject.PojoUpsertTarget;
import com.hazelcast.jet.sql.impl.inject.UpsertInjector;
import com.hazelcast.nio.serialization.ClassNameFilter;
import com.hazelcast.shaded.com.google.common.collect.ImmutableMap;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Map;
import java.util.Objects;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class PojoUpsertTargetTest {
    @Test
    public void test_set() {
        PojoUpsertTarget target = new PojoUpsertTarget(Pojo.class.getName(), (Map)ImmutableMap.of((Object)"intField", (Object)Integer.TYPE.getName(), (Object)"longField", (Object)Long.TYPE.getName(), (Object)"stringField", (Object)String.class.getName()), null);
        UpsertInjector intFieldInjector = target.createInjector("intField", QueryDataType.INT);
        UpsertInjector longFieldInjector = target.createInjector("longField", QueryDataType.BIGINT);
        UpsertInjector stringFieldInjector = target.createInjector("stringField", QueryDataType.VARCHAR);
        target.init();
        intFieldInjector.set((Object)1);
        longFieldInjector.set((Object)2L);
        stringFieldInjector.set((Object)"3");
        Object pojo = target.conclude();
        Assertions.assertThat((Object)pojo).isEqualTo((Object)new Pojo(1, 2L, "3"));
    }

    @Test
    public void when_injectNullValueWithPrimitiveField_then_throws() {
        PojoUpsertTarget target = new PojoUpsertTarget(Pojo.class.getName(), (Map)ImmutableMap.of((Object)"intField", (Object)Integer.TYPE.getName()), null);
        UpsertInjector injector = target.createInjector("intField", QueryDataType.INT);
        target.init();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> injector.set(null)).isInstanceOf(QueryException.class)).hasMessageContaining("Cannot set NULL to a primitive field");
    }

    @Test
    public void when_injectNullValueWithPrimitiveSetter_then_throws() {
        PojoUpsertTarget target = new PojoUpsertTarget(Pojo.class.getName(), (Map)ImmutableMap.of((Object)"longField", (Object)Long.TYPE.getName()), null);
        UpsertInjector injector = target.createInjector("longField", QueryDataType.BIGINT);
        target.init();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> injector.set(null)).isInstanceOf(QueryException.class)).hasMessageContaining("Cannot pass NULL to a method with a primitive argument");
    }

    @Test
    public void when_injectNonExistingPropertyValue_then_throws() {
        PojoUpsertTarget target = new PojoUpsertTarget(Object.class.getName(), (Map)ImmutableMap.of((Object)"field", (Object)Integer.TYPE.getName()), null);
        UpsertInjector injector = target.createInjector("field", QueryDataType.INT);
        target.init();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> injector.set((Object)1)).isInstanceOf(QueryException.class)).hasMessageContaining("Cannot set property \"field\" to class java.lang.Object: no set-method or public field available");
    }

    @Test
    public void when_injectNonExistingPropertyNullValue_then_succeeds() {
        PojoUpsertTarget target = new PojoUpsertTarget(Object.class.getName(), (Map)ImmutableMap.of((Object)"field", (Object)Integer.TYPE.getName()), null);
        UpsertInjector injector = target.createInjector("field", QueryDataType.INT);
        target.init();
        injector.set(null);
        Object pojo = target.conclude();
        Assertions.assertThat((Object)pojo).isNotNull();
    }

    @Test
    public void when_filterThrowsException_then_init_failed() {
        SecurityException expected = new SecurityException("failed");
        ReflectionClassNameFilter filter = (ReflectionClassNameFilter)Mockito.mock(ReflectionClassNameFilter.class);
        ((ReflectionClassNameFilter)Mockito.doThrow((Throwable[])new Throwable[]{expected}).when((Object)filter)).filter(ArgumentMatchers.anyString());
        Assertions.assertThatThrownBy(() -> new PojoUpsertTarget(Object.class.getName(), (Map)ImmutableMap.of((Object)"field", (Object)Integer.TYPE.getName()), (ClassNameFilter)filter)).isEqualTo((Object)expected);
    }

    @Test
    public void when_filterPassed_then_init_succcess() {
        ReflectionClassNameFilter filter = (ReflectionClassNameFilter)Mockito.mock(ReflectionClassNameFilter.class);
        PojoUpsertTarget target = new PojoUpsertTarget(Object.class.getName(), (Map)ImmutableMap.of((Object)"field", (Object)Integer.TYPE.getName()), (ClassNameFilter)filter);
        target.init();
        ((ReflectionClassNameFilter)Mockito.verify((Object)filter)).filter((String)ArgumentMatchers.eq((Object)Object.class.getName()));
    }

    private static final class Pojo {
        public int intField;
        private long longField;
        private String stringField;

        Pojo() {
        }

        private Pojo(int intField, long longField, String stringField) {
            this.intField = intField;
            this.longField = longField;
            this.stringField = stringField;
        }

        public long getLongField() {
            return this.longField;
        }

        public void setLongField(long longField) {
            this.longField = longField;
        }

        public String getStringField() {
            return this.stringField;
        }

        public void setStringField(String stringField) {
            this.stringField = stringField;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Pojo pojo = (Pojo)o;
            return this.intField == pojo.intField && this.longField == pojo.longField && Objects.equals(this.stringField, pojo.stringField);
        }

        public int hashCode() {
            return Objects.hash(this.intField, this.longField, this.stringField);
        }
    }
}

