/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.index;

import com.hazelcast.jet.sql.impl.index.IndexFilterTestSupport;
import com.hazelcast.sql.impl.exec.scan.index.IndexFilterValue;
import com.hazelcast.sql.impl.exec.scan.index.IndexRangeFilter;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class IndexRangeFilterTest
extends IndexFilterTestSupport {
    @Test
    public void testContent() {
        IndexFilterValue from = IndexRangeFilterTest.intValue(1, true);
        IndexFilterValue to = IndexRangeFilterTest.intValue(2, true);
        IndexRangeFilter filter = new IndexRangeFilter(from, true, to, true);
        Assert.assertSame((Object)from, (Object)filter.getFrom());
        Assert.assertTrue((boolean)filter.isFromInclusive());
        Assert.assertSame((Object)to, (Object)filter.getTo());
        Assert.assertTrue((boolean)filter.isToInclusive());
    }

    @Test
    public void testEquals() {
        IndexRangeFilter filter = new IndexRangeFilter(IndexRangeFilterTest.intValue(1, true), true, IndexRangeFilterTest.intValue(2, true), true);
        IndexRangeFilterTest.checkEquals(filter, new IndexRangeFilter(IndexRangeFilterTest.intValue(1, true), true, IndexRangeFilterTest.intValue(2, true), true), true);
        IndexRangeFilterTest.checkEquals(filter, new IndexRangeFilter(IndexRangeFilterTest.intValue(2, true), true, IndexRangeFilterTest.intValue(2, true), true), false);
        IndexRangeFilterTest.checkEquals(filter, new IndexRangeFilter(null, false, IndexRangeFilterTest.intValue(2, true), true), false);
        IndexRangeFilterTest.checkEquals(filter, new IndexRangeFilter(IndexRangeFilterTest.intValue(1, true), false, IndexRangeFilterTest.intValue(2, true), true), false);
        IndexRangeFilterTest.checkEquals(filter, new IndexRangeFilter(IndexRangeFilterTest.intValue(1, true), true, IndexRangeFilterTest.intValue(3, true), true), false);
        IndexRangeFilterTest.checkEquals(filter, new IndexRangeFilter(IndexRangeFilterTest.intValue(1, true), true, null, false), false);
        IndexRangeFilterTest.checkEquals(filter, new IndexRangeFilter(IndexRangeFilterTest.intValue(1, true), true, IndexRangeFilterTest.intValue(2, true), false), false);
    }

    @Test
    public void testSerialization() {
        IndexRangeFilter original = new IndexRangeFilter(IndexRangeFilterTest.intValue(1, true), true, IndexRangeFilterTest.intValue(2, true), true);
        IndexRangeFilter restored = (IndexRangeFilter)IndexRangeFilterTest.serializeAndCheck(original, 29);
        IndexRangeFilterTest.checkEquals(original, restored, true);
    }
}

