/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.expression.string;

import com.hazelcast.jet.sql.impl.expression.ExpressionTestSupport;
import com.hazelcast.jet.sql.impl.support.expressions.ExpressionBiValue;
import com.hazelcast.jet.sql.impl.support.expressions.ExpressionType;
import com.hazelcast.jet.sql.impl.support.expressions.ExpressionTypes;
import com.hazelcast.sql.HazelcastSqlException;
import com.hazelcast.sql.SqlColumnType;
import com.hazelcast.sql.impl.expression.ConstantExpression;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.string.ConcatWSFunction;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class ConcatWSFunctionIntegrationTest
extends ExpressionTestSupport {
    @Test
    public void testColumn() {
        ExpressionType<?>[] allTypes = ExpressionTypes.all();
        for (int i = 0; i < allTypes.length; ++i) {
            for (int j = i; j < allTypes.length; ++j) {
                ExpressionType<?> type1 = allTypes[i];
                ExpressionType<?> type2 = allTypes[j];
                Class<? extends ExpressionBiValue> clazz = ExpressionBiValue.createBiClass(type1.typeName(), type2.typeName());
                Object[] values = new ExpressionBiValue[]{ExpressionBiValue.createBiValue(clazz, 0, type1.valueFrom(), type2.valueFrom()), ExpressionBiValue.createBiValue(clazz, 0, null, type2.valueFrom()), ExpressionBiValue.createBiValue(clazz, 0, type1.valueFrom(), null), ExpressionBiValue.createBiValue(clazz, 0, null, null)};
                Object[] expectedResults = new String[]{String.valueOf(type1.valueFrom()) + "-" + String.valueOf(type2.valueFrom()), type2.valueFrom().toString(), type1.valueFrom().toString(), ""};
                this.checkColumns(values, expectedResults);
            }
        }
    }

    @Test
    public void testLiteral() {
        this.put("1");
        this.check(this.getConcatWsExpression("-", "this", "2"), "1-2", new Object[0]);
        this.check(this.getConcatWsExpression("-", "this", "'2'"), "1-2", new Object[0]);
        this.check(this.getConcatWsExpression("-", "this", "2e0"), "1-2E0", new Object[0]);
        this.check(this.getConcatWsExpression("-", "this", "true"), "1-true", new Object[0]);
        this.check(this.getConcatWsExpression("-", "this", "null"), "1", new Object[0]);
        this.check(this.getConcatWsExpression("-", "1", "2"), "1-2", new Object[0]);
        this.check(this.getConcatWsExpression("-", "'1'", "2"), "1-2", new Object[0]);
    }

    @Test
    public void testNull() {
        this.put("1");
        this.check(this.getConcatWsExpression("null", false, "3", "2"), null, new Object[0]);
        this.check(this.getConcatWsExpression("-", "1", "null", "3"), "1-3", new Object[0]);
        this.check(this.getConcatWsExpression("-", "null", "null"), "", new Object[0]);
        this.check(this.getConcatWsExpression("-", "null", "2", "'3'"), "2-3", new Object[0]);
    }

    @Test
    public void testEmpty() {
        this.put("1");
        this.check(this.getConcatWsExpression("", "3", "2"), "32", new Object[0]);
        this.check(this.getConcatWsExpression("", "3", "null", "2"), "32", new Object[0]);
        this.check(this.getConcatWsExpression("-", "3", "''", "2"), "3--2", new Object[0]);
    }

    @Test
    public void testNonStringSeparator() {
        this.put("1");
        this.checkFail(this.getConcatWsExpression("5", false, "3", "2"), new Object[0]);
    }

    @Test
    public void testParameter() {
        this.put("1");
        this.check(this.getConcatWsExpression("-", "this", "?"), "1-2", 2);
        this.check(this.getConcatWsExpression("-", "this", "?"), "1-2", "2");
        this.check(this.getConcatWsExpression("-", "this", "?"), "1-2", Character.valueOf('2'));
        this.check(this.getConcatWsExpression("-", "this", "?"), "1", new Object[]{null});
        this.check(this.getConcatWsExpression("-", "this", "?"), "1-" + String.valueOf(LOCAL_DATE_VAL), LOCAL_DATE_VAL);
        this.check(this.getConcatWsExpression("-", "this", "?"), "1-" + String.valueOf(LOCAL_TIME_VAL), LOCAL_TIME_VAL);
        this.check(this.getConcatWsExpression("-", "this", "?"), "1-" + String.valueOf(LOCAL_DATE_TIME_VAL), LOCAL_DATE_TIME_VAL);
        this.check(this.getConcatWsExpression("-", "this", "?"), "1-" + String.valueOf(OFFSET_DATE_TIME_VAL), OFFSET_DATE_TIME_VAL);
        this.check(this.getConcatWsExpression("-", "?", "?"), "1-2", 1, 2);
        this.check(this.getConcatWsExpression("-", "?", "?"), "1", 1, null);
        this.check(this.getConcatWsExpression("-", "?", "?"), "2", null, Character.valueOf('2'));
        this.check(this.getConcatWsExpression("-", "?", "?"), "", null, null);
        this.check(this.getConcatWsExpression("?", false, "?", "?"), "", "-", null, null);
        this.checkFail(this.getConcatWsExpression("?", false, "?", "?"), 1, null, null);
        this.check(this.getConcatWsExpression("?", false, "?", "?"), null, null, null, null);
    }

    @Test
    public void testOperandCount() {
        this.put(1, new ExpressionBiValue.StringStringVal().fields("2", "3"));
        this.checkFail(this.getConcatWsExpression("-", new String[0]), new Object[0]);
        this.check(this.getConcatWsExpression("-", "__key", "field1", "field2"), "1-2-3", new Object[0]);
        this.check(this.getConcatWsExpression("-", "1", "2", "3", "'4'"), "1-2-3-4", new Object[0]);
    }

    @Test
    public void testEquals() {
        ConcatWSFunction function = ConcatWSFunction.create((Expression[])new Expression[]{ConstantExpression.create((Object)"-", (QueryDataType)QueryDataType.VARCHAR), ConstantExpression.create((Object)"1", (QueryDataType)QueryDataType.VARCHAR), ConstantExpression.create((Object)"2", (QueryDataType)QueryDataType.VARCHAR)});
        ConcatWSFunctionIntegrationTest.checkEquals(function, ConcatWSFunction.create((Expression[])new Expression[]{ConstantExpression.create((Object)"-", (QueryDataType)QueryDataType.VARCHAR), ConstantExpression.create((Object)"1", (QueryDataType)QueryDataType.VARCHAR), ConstantExpression.create((Object)"2", (QueryDataType)QueryDataType.VARCHAR)}), true);
        ConcatWSFunctionIntegrationTest.checkEquals(function, ConcatWSFunction.create((Expression[])new Expression[]{ConstantExpression.create((Object)"-", (QueryDataType)QueryDataType.VARCHAR), ConstantExpression.create((Object)"1", (QueryDataType)QueryDataType.INT), ConstantExpression.create((Object)"2", (QueryDataType)QueryDataType.VARCHAR)}), false);
        ConcatWSFunctionIntegrationTest.checkEquals(function, ConcatWSFunction.create((Expression[])new Expression[]{ConstantExpression.create((Object)"-", (QueryDataType)QueryDataType.VARCHAR), ConstantExpression.create((Object)"1", (QueryDataType)QueryDataType.VARCHAR), ConstantExpression.create((Object)"20", (QueryDataType)QueryDataType.VARCHAR)}), false);
        ConcatWSFunctionIntegrationTest.checkEquals(function, ConcatWSFunction.create((Expression[])new Expression[]{ConstantExpression.create((Object)"-", (QueryDataType)QueryDataType.VARCHAR), ConstantExpression.create((Object)"2", (QueryDataType)QueryDataType.VARCHAR)}), false);
        ConcatWSFunctionIntegrationTest.checkEquals(function, ConcatWSFunction.create((Expression[])new Expression[]{ConstantExpression.create((Object)"1", (QueryDataType)QueryDataType.VARCHAR), ConstantExpression.create((Object)"2", (QueryDataType)QueryDataType.VARCHAR)}), false);
    }

    @Test
    public void testSerialization() {
        ConcatWSFunction original = ConcatWSFunction.create((Expression[])new Expression[]{ConstantExpression.create((Object)"-", (QueryDataType)QueryDataType.VARCHAR), ConstantExpression.create((Object)"1", (QueryDataType)QueryDataType.VARCHAR), ConstantExpression.create((Object)"2", (QueryDataType)QueryDataType.VARCHAR)});
        ConcatWSFunction corrupted1 = ConcatWSFunction.create((Expression[])new Expression[]{ConstantExpression.create((Object)"===", (QueryDataType)QueryDataType.VARCHAR), ConstantExpression.create((Object)"1", (QueryDataType)QueryDataType.VARCHAR), ConstantExpression.create((Object)"2", (QueryDataType)QueryDataType.VARCHAR)});
        ConcatWSFunction corrupted2 = ConcatWSFunction.create((Expression[])new Expression[]{ConstantExpression.create((Object)"-", (QueryDataType)QueryDataType.VARCHAR), ConstantExpression.create((Object)"10", (QueryDataType)QueryDataType.VARCHAR), ConstantExpression.create((Object)"2", (QueryDataType)QueryDataType.VARCHAR)});
        ConcatWSFunction corrupted3 = ConcatWSFunction.create((Expression[])new Expression[]{ConstantExpression.create((Object)"-", (QueryDataType)QueryDataType.VARCHAR), ConstantExpression.create((Object)"1", (QueryDataType)QueryDataType.INT), ConstantExpression.create((Object)"2", (QueryDataType)QueryDataType.VARCHAR)});
        ConcatWSFunction corrupted4 = ConcatWSFunction.create((Expression[])new Expression[]{ConstantExpression.create((Object)"-", (QueryDataType)QueryDataType.VARCHAR), ConstantExpression.create((Object)"1", (QueryDataType)QueryDataType.VARCHAR), ConstantExpression.create(null, (QueryDataType)QueryDataType.VARCHAR)});
        ConcatWSFunction restored = (ConcatWSFunction)ConcatWSFunctionIntegrationTest.serializeAndCheck(original, 67);
        ConcatWSFunctionIntegrationTest.checkEquals(original, restored, true);
        ConcatWSFunctionIntegrationTest.checkEquals(corrupted1, restored, false);
        ConcatWSFunctionIntegrationTest.checkEquals(corrupted2, restored, false);
        ConcatWSFunctionIntegrationTest.checkEquals(corrupted3, restored, false);
        ConcatWSFunctionIntegrationTest.checkEquals(corrupted4, restored, false);
    }

    private void checkColumns(Object[] values, Object[] expectedResults) {
        this.putAll(values);
        this.checkValues0("SELECT Concat_WS('-', field1, field2) FROM map", SqlColumnType.VARCHAR, expectedResults, new Object[0]);
    }

    private void check(String operands, String expectedResult, Object ... params) {
        String sql = "SELECT " + operands + " FROM map";
        this.checkValue0(sql, SqlColumnType.VARCHAR, expectedResult, params);
    }

    private void checkFail(String expression, Object ... params) {
        try {
            String sql = "SELECT " + expression + " FROM map";
            ConcatWSFunctionIntegrationTest.execute(sql, params);
            Assert.fail((String)("Following query should have caused an error!  ===> " + sql));
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof HazelcastSqlException));
        }
    }

    private String getConcatWsExpression(String separator, String ... operands) {
        return this.getConcatWsExpression(separator, true, operands);
    }

    private String getConcatWsExpression(String separator, boolean quoteSeparator, String ... operands) {
        if (quoteSeparator) {
            separator = "'" + (String)separator + "'";
        }
        StringBuilder expression = new StringBuilder("Concat_WS(" + (String)separator);
        for (String operand : operands) {
            expression.append(", ").append(operand);
        }
        expression.append(")");
        return expression.toString();
    }
}

