/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.expression.math;

import com.hazelcast.jet.sql.impl.expression.ExpressionTestSupport;
import com.hazelcast.sql.SqlColumnType;
import com.hazelcast.sql.impl.expression.ConstantExpression;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.math.SignFunction;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class SignFunctionIntegrationTest
extends ExpressionTestSupport {
    @Test
    public void testColumn() {
        this.checkColumn((byte)0, SqlColumnType.TINYINT, (byte)0);
        this.checkColumn((byte)1, SqlColumnType.TINYINT, (byte)1);
        this.checkColumn((byte)-1, SqlColumnType.TINYINT, (byte)-1);
        this.checkColumn((byte)127, SqlColumnType.TINYINT, (byte)1);
        this.checkColumn((byte)-128, SqlColumnType.TINYINT, (byte)-1);
        this.checkColumn((short)0, SqlColumnType.SMALLINT, (short)0);
        this.checkColumn((short)1, SqlColumnType.SMALLINT, (short)1);
        this.checkColumn((short)-1, SqlColumnType.SMALLINT, (short)-1);
        this.checkColumn((short)Short.MAX_VALUE, SqlColumnType.SMALLINT, (short)1);
        this.checkColumn((short)Short.MIN_VALUE, SqlColumnType.SMALLINT, (short)-1);
        this.checkColumn(0, SqlColumnType.INTEGER, 0);
        this.checkColumn(1, SqlColumnType.INTEGER, 1);
        this.checkColumn(-1, SqlColumnType.INTEGER, -1);
        this.checkColumn(Integer.MAX_VALUE, SqlColumnType.INTEGER, 1);
        this.checkColumn(Integer.MIN_VALUE, SqlColumnType.INTEGER, -1);
        this.checkColumn(0L, SqlColumnType.BIGINT, 0L);
        this.checkColumn(1L, SqlColumnType.BIGINT, 1L);
        this.checkColumn(-1L, SqlColumnType.BIGINT, -1L);
        this.checkColumn(Long.MAX_VALUE, SqlColumnType.BIGINT, 1L);
        this.checkColumn(Long.MIN_VALUE, SqlColumnType.BIGINT, -1L);
        this.checkColumn(BigInteger.ZERO, SqlColumnType.DECIMAL, BigDecimal.ZERO);
        this.checkColumn(BigInteger.ONE, SqlColumnType.DECIMAL, BigDecimal.ONE);
        this.checkColumn(BigInteger.ONE.negate(), SqlColumnType.DECIMAL, BigDecimal.ONE.negate());
        this.checkColumn(BigDecimal.ZERO, SqlColumnType.DECIMAL, BigDecimal.ZERO);
        this.checkColumn(BigDecimal.ONE, SqlColumnType.DECIMAL, BigDecimal.ONE);
        this.checkColumn(BigDecimal.ONE.negate(), SqlColumnType.DECIMAL, BigDecimal.ONE.negate());
        this.checkColumn(Float.valueOf(0.0f), SqlColumnType.REAL, Float.valueOf(0.0f));
        this.checkColumn(Float.valueOf(1.1f), SqlColumnType.REAL, Float.valueOf(1.0f));
        this.checkColumn(Float.valueOf(-1.1f), SqlColumnType.REAL, Float.valueOf(-1.0f));
        this.checkColumn(Float.valueOf(Float.POSITIVE_INFINITY), SqlColumnType.REAL, Float.valueOf(1.0f));
        this.checkColumn(Float.valueOf(Float.NEGATIVE_INFINITY), SqlColumnType.REAL, Float.valueOf(-1.0f));
        this.checkColumn(Float.valueOf(Float.NaN), SqlColumnType.REAL, Float.valueOf(Float.NaN));
        this.checkColumn(0.0, SqlColumnType.DOUBLE, 0.0);
        this.checkColumn(1.1, SqlColumnType.DOUBLE, 1.0);
        this.checkColumn(-1.1, SqlColumnType.DOUBLE, -1.0);
        this.checkColumn(Double.POSITIVE_INFINITY, SqlColumnType.DOUBLE, 1.0);
        this.checkColumn(Double.NEGATIVE_INFINITY, SqlColumnType.DOUBLE, -1.0);
        this.checkColumn(Double.NaN, SqlColumnType.DOUBLE, Double.NaN);
        this.checkColumnFailure("0", 1008, SignFunctionIntegrationTest.signatureError(SqlColumnType.VARCHAR));
        this.checkColumnFailure(true, 1008, SignFunctionIntegrationTest.signatureError(SqlColumnType.BOOLEAN));
        this.checkColumnFailure(LOCAL_DATE_VAL, 1008, SignFunctionIntegrationTest.signatureError(SqlColumnType.DATE));
        this.checkColumnFailure(LOCAL_TIME_VAL, 1008, SignFunctionIntegrationTest.signatureError(SqlColumnType.TIME));
        this.checkColumnFailure(LOCAL_DATE_TIME_VAL, 1008, SignFunctionIntegrationTest.signatureError(SqlColumnType.TIMESTAMP));
        this.checkColumnFailure(OFFSET_DATE_TIME_VAL, 1008, SignFunctionIntegrationTest.signatureError(SqlColumnType.TIMESTAMP_WITH_TIME_ZONE));
        this.checkColumnFailure(OBJECT_VAL, 1008, SignFunctionIntegrationTest.signatureError(SqlColumnType.OBJECT));
    }

    private void checkColumn(Object value, SqlColumnType expectedType, Object expectedResult) {
        this.put(value);
        this.checkValue("this", expectedType, expectedResult, new Object[0]);
    }

    private void checkColumnFailure(Object value, int expectedErrorCode, String expectedErrorMessage) {
        this.put(value);
        this.checkFailure("this", expectedErrorCode, expectedErrorMessage, new Object[0]);
    }

    @Test
    public void testParameter() {
        this.put(0);
        long zero = 0L;
        long positive = 1L;
        long negative = -1L;
        this.checkParameter((byte)0, zero);
        this.checkParameter((byte)1, positive);
        this.checkParameter((byte)-1, negative);
        this.checkParameter((byte)127, positive);
        this.checkParameter((byte)-128, negative);
        this.checkParameter((short)0, zero);
        this.checkParameter((short)1, positive);
        this.checkParameter((short)-1, negative);
        this.checkParameter((short)Short.MAX_VALUE, positive);
        this.checkParameter((short)Short.MIN_VALUE, negative);
        this.checkParameter(0, zero);
        this.checkParameter(1, positive);
        this.checkParameter(-1, negative);
        this.checkParameter(Integer.MAX_VALUE, positive);
        this.checkParameter(Integer.MIN_VALUE, negative);
        this.checkParameter(0L, zero);
        this.checkParameter(1L, positive);
        this.checkParameter(-1L, negative);
        this.checkParameter(Long.MAX_VALUE, positive);
        this.checkParameter(Long.MIN_VALUE, negative);
        this.checkFailure("?", 2000, SignFunctionIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.VARCHAR), "foo");
        this.checkFailure("?", 2000, SignFunctionIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.BOOLEAN), true);
        this.checkFailure("?", 2000, SignFunctionIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DECIMAL), BigInteger.ZERO);
        this.checkFailure("?", 2000, SignFunctionIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DECIMAL), BigDecimal.ZERO);
        this.checkFailure("?", 2000, SignFunctionIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.REAL), Float.valueOf(0.0f));
        this.checkFailure("?", 2000, SignFunctionIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DOUBLE), 0.0);
        this.checkFailure("?", 2000, SignFunctionIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DATE), LOCAL_DATE_VAL);
        this.checkFailure("?", 2000, SignFunctionIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIME), LOCAL_TIME_VAL);
        this.checkFailure("?", 2000, SignFunctionIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIMESTAMP), LOCAL_DATE_TIME_VAL);
        this.checkFailure("?", 2000, SignFunctionIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), OFFSET_DATE_TIME_VAL);
        this.checkFailure("?", 2000, SignFunctionIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.OBJECT), OBJECT_VAL);
    }

    private void checkParameter(Object parameterValue, Object expectedValue) {
        this.checkValue("?", SqlColumnType.BIGINT, expectedValue, parameterValue);
    }

    @Test
    public void testLiteral() {
        this.put(0);
        this.checkValue("null", SqlColumnType.BIGINT, null, new Object[0]);
        this.checkValue(0, SqlColumnType.TINYINT, (byte)0, new Object[0]);
        this.checkValue(1, SqlColumnType.TINYINT, (byte)1, new Object[0]);
        this.checkValue(-1, SqlColumnType.TINYINT, (byte)-1, new Object[0]);
        this.checkValue((byte)127, SqlColumnType.TINYINT, (byte)1, new Object[0]);
        this.checkValue((byte)-128, SqlColumnType.TINYINT, (byte)-1, new Object[0]);
        this.checkValue((short)Short.MAX_VALUE, SqlColumnType.SMALLINT, (short)1, new Object[0]);
        this.checkValue((short)Short.MIN_VALUE, SqlColumnType.SMALLINT, (short)-1, new Object[0]);
        this.checkValue(Integer.MAX_VALUE, SqlColumnType.INTEGER, 1, new Object[0]);
        this.checkValue(Integer.MIN_VALUE, SqlColumnType.INTEGER, -1, new Object[0]);
        this.checkValue(Long.MAX_VALUE, SqlColumnType.BIGINT, 1L, new Object[0]);
        this.checkValue(Long.MIN_VALUE, SqlColumnType.BIGINT, -1L, new Object[0]);
        this.checkValue("1.1", SqlColumnType.DECIMAL, new BigDecimal("1"), new Object[0]);
        this.checkValue("0.0", SqlColumnType.DECIMAL, new BigDecimal("0"), new Object[0]);
        this.checkValue("-1.1", SqlColumnType.DECIMAL, new BigDecimal("-1"), new Object[0]);
        this.checkValue("1.1E0", SqlColumnType.DOUBLE, 1.0, new Object[0]);
        this.checkValue("0.0E0", SqlColumnType.DOUBLE, 0.0, new Object[0]);
        this.checkValue("-1.1E0", SqlColumnType.DOUBLE, -1.0, new Object[0]);
        this.checkFailure("'\fooa'", 1008, SignFunctionIntegrationTest.signatureError(SqlColumnType.VARCHAR), new Object[0]);
        this.checkFailure("true", 1008, SignFunctionIntegrationTest.signatureError(SqlColumnType.BOOLEAN), new Object[0]);
    }

    private static String signatureError(SqlColumnType type) {
        return SignFunctionIntegrationTest.signatureErrorFunction("SIGN", type);
    }

    private void checkValue(Object operand, SqlColumnType expectedType, Object expectedValue, Object ... params) {
        String sql = "SELECT SIGN(" + String.valueOf(operand) + ") FROM map";
        this.checkValue0(sql, expectedType, expectedValue, params);
    }

    private void checkFailure(Object operand, int expectedErrorCode, String expectedErrorMessage, Object ... params) {
        String sql = "SELECT SIGN(" + String.valueOf(operand) + ") FROM map";
        this.checkFailure0(sql, expectedErrorCode, expectedErrorMessage, params);
    }

    @Test
    public void testEquals() {
        SignFunction function = SignFunction.create((Expression)ConstantExpression.create((Object)1, (QueryDataType)QueryDataType.INT), (QueryDataType)QueryDataType.INT);
        SignFunctionIntegrationTest.checkEquals(function, SignFunction.create((Expression)ConstantExpression.create((Object)1, (QueryDataType)QueryDataType.INT), (QueryDataType)QueryDataType.INT), true);
        SignFunctionIntegrationTest.checkEquals(function, SignFunction.create((Expression)ConstantExpression.create((Object)2, (QueryDataType)QueryDataType.INT), (QueryDataType)QueryDataType.INT), false);
        SignFunctionIntegrationTest.checkEquals(function, SignFunction.create((Expression)ConstantExpression.create((Object)1, (QueryDataType)QueryDataType.BIGINT), (QueryDataType)QueryDataType.BIGINT), false);
    }

    @Test
    public void testSerialization() {
        SignFunction original = SignFunction.create((Expression)ConstantExpression.create((Object)1, (QueryDataType)QueryDataType.INT), (QueryDataType)QueryDataType.INT);
        SignFunction restored = (SignFunction)SignFunctionIntegrationTest.serializeAndCheck(original, 52);
        SignFunctionIntegrationTest.checkEquals(original, restored, true);
    }
}

