/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.expression.math;

import com.hazelcast.jet.sql.impl.expression.ExpressionTestSupport;
import com.hazelcast.jet.sql.impl.support.expressions.ExpressionValue;
import com.hazelcast.sql.SqlColumnType;
import com.hazelcast.sql.impl.expression.ConstantExpression;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.math.DoubleFunction;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.test.HazelcastParametrizedRunner;
import com.hazelcast.test.HazelcastSerialParametersRunnerFactory;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=HazelcastParametrizedRunner.class)
@Parameterized.UseParametersRunnerFactory(value=HazelcastSerialParametersRunnerFactory.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class DoubleFunctionIntegrationTest
extends ExpressionTestSupport {
    @Parameterized.Parameter
    public FunctionInfo function;

    @Parameterized.Parameters(name="function: {0}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({new FunctionInfo("COS")}, {new FunctionInfo("SIN")}, {new FunctionInfo("TAN")}, {new FunctionInfo("COT")}, {new FunctionInfo("ACOS")}, {new FunctionInfo("ASIN")}, {new FunctionInfo("ATAN")}, {new FunctionInfo("EXP")}, {new FunctionInfo("LN")}, {new FunctionInfo("LOG10")}, {new FunctionInfo("DEGREES")}, {new FunctionInfo("RADIANS")}, {new FunctionInfo("SQUARE")}, {new FunctionInfo("SQRT")}, {new FunctionInfo("CBRT")});
    }

    @Test
    public void testColumn() {
        this.putAndCheckValue(new ExpressionValue.DoubleVal(), this.sql("field1"), SqlColumnType.DOUBLE, null, new Object[0]);
        this.putAndCheckValue((byte)1, this.sql("this"), SqlColumnType.DOUBLE, this.function.process(1.0), new Object[0]);
        this.putAndCheckValue((short)1, this.sql("this"), SqlColumnType.DOUBLE, this.function.process(1.0), new Object[0]);
        this.putAndCheckValue(1, this.sql("this"), SqlColumnType.DOUBLE, this.function.process(1.0), new Object[0]);
        this.putAndCheckValue(1L, this.sql("this"), SqlColumnType.DOUBLE, this.function.process(1.0), new Object[0]);
        this.putAndCheckValue(1L, this.sql("this"), SqlColumnType.DOUBLE, this.function.process(1.0), new Object[0]);
        this.putAndCheckValue(BigInteger.ONE, this.sql("this"), SqlColumnType.DOUBLE, this.function.process(1.0), new Object[0]);
        this.putAndCheckValue(BigDecimal.ONE, this.sql("this"), SqlColumnType.DOUBLE, this.function.process(1.0), new Object[0]);
        this.putAndCheckValue(Float.valueOf(1.0f), this.sql("this"), SqlColumnType.DOUBLE, this.function.process(1.0), new Object[0]);
        this.putAndCheckValue(1.0, this.sql("this"), SqlColumnType.DOUBLE, this.function.process(1.0), new Object[0]);
        this.putAndCheckFailure(Character.valueOf('1'), this.sql("this"), 1008, DoubleFunctionIntegrationTest.signatureErrorFunction(this.function.name, SqlColumnType.VARCHAR), new Object[0]);
        this.putAndCheckFailure("1", this.sql("this"), 1008, DoubleFunctionIntegrationTest.signatureErrorFunction(this.function.name, SqlColumnType.VARCHAR), new Object[0]);
        this.putAndCheckFailure(true, this.sql("this"), 1008, DoubleFunctionIntegrationTest.signatureErrorFunction(this.function.name, SqlColumnType.BOOLEAN), new Object[0]);
        this.putAndCheckFailure(LOCAL_DATE_VAL, this.sql("this"), 1008, DoubleFunctionIntegrationTest.signatureErrorFunction(this.function.name, SqlColumnType.DATE), new Object[0]);
        this.putAndCheckFailure(LOCAL_TIME_VAL, this.sql("this"), 1008, DoubleFunctionIntegrationTest.signatureErrorFunction(this.function.name, SqlColumnType.TIME), new Object[0]);
        this.putAndCheckFailure(LOCAL_DATE_TIME_VAL, this.sql("this"), 1008, DoubleFunctionIntegrationTest.signatureErrorFunction(this.function.name, SqlColumnType.TIMESTAMP), new Object[0]);
        this.putAndCheckFailure(OFFSET_DATE_TIME_VAL, this.sql("this"), 1008, DoubleFunctionIntegrationTest.signatureErrorFunction(this.function.name, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), new Object[0]);
        this.putAndCheckFailure(OBJECT_VAL, this.sql("this"), 1008, DoubleFunctionIntegrationTest.signatureErrorFunction(this.function.name, SqlColumnType.OBJECT), new Object[0]);
    }

    @Test
    public void testLiteral() {
        this.put(0);
        this.checkValue0(this.sql("null"), SqlColumnType.DOUBLE, null, new Object[0]);
        this.checkValue0(this.sql("1"), SqlColumnType.DOUBLE, this.function.process(1.0), new Object[0]);
        this.checkValue0(this.sql("1.0"), SqlColumnType.DOUBLE, this.function.process(1.0), new Object[0]);
        this.checkValue0(this.sql("1.5"), SqlColumnType.DOUBLE, this.function.process(1.5), new Object[0]);
        this.checkValue0(this.sql("0.001"), SqlColumnType.DOUBLE, this.function.process(0.001), new Object[0]);
        this.checkValue0(this.sql("1E0"), SqlColumnType.DOUBLE, this.function.process(1.0), new Object[0]);
        this.checkFailure0(this.sql("true"), 1008, DoubleFunctionIntegrationTest.signatureErrorFunction(this.function.name, SqlColumnType.BOOLEAN), new Object[0]);
        this.checkFailure0(this.sql("'1'"), 1008, DoubleFunctionIntegrationTest.signatureErrorFunction(this.function.name, SqlColumnType.VARCHAR), new Object[0]);
    }

    @Test
    public void testParameter() {
        this.put(0);
        this.checkValue0(this.sql("?"), SqlColumnType.DOUBLE, null, new Object[]{null});
        this.checkValue0(this.sql("?"), SqlColumnType.DOUBLE, this.function.process(1.0), (byte)1);
        this.checkValue0(this.sql("?"), SqlColumnType.DOUBLE, this.function.process(1.0), (short)1);
        this.checkValue0(this.sql("?"), SqlColumnType.DOUBLE, this.function.process(1.0), 1);
        this.checkValue0(this.sql("?"), SqlColumnType.DOUBLE, this.function.process(1.0), 1L);
        this.checkValue0(this.sql("?"), SqlColumnType.DOUBLE, this.function.process(1.0), BigInteger.ONE);
        this.checkValue0(this.sql("?"), SqlColumnType.DOUBLE, this.function.process(1.0), BigDecimal.ONE);
        this.checkValue0(this.sql("?"), SqlColumnType.DOUBLE, this.function.process(1.0), Float.valueOf(1.0f));
        this.checkValue0(this.sql("?"), SqlColumnType.DOUBLE, this.function.process(1.0), 1.0);
        this.checkValue0(this.sql("?"), SqlColumnType.DOUBLE, this.function.process(0.001), 0.001);
        this.checkFailure0(this.sql("?"), 2000, DoubleFunctionIntegrationTest.parameterError(0, SqlColumnType.DOUBLE, SqlColumnType.VARCHAR), Character.valueOf('1'));
        this.checkFailure0(this.sql("?"), 2000, DoubleFunctionIntegrationTest.parameterError(0, SqlColumnType.DOUBLE, SqlColumnType.VARCHAR), "1");
        this.checkFailure0(this.sql("?"), 2000, DoubleFunctionIntegrationTest.parameterError(0, SqlColumnType.DOUBLE, SqlColumnType.BOOLEAN), true);
        this.checkFailure0(this.sql("?"), 2000, DoubleFunctionIntegrationTest.parameterError(0, SqlColumnType.DOUBLE, SqlColumnType.DATE), LOCAL_DATE_VAL);
        this.checkFailure0(this.sql("?"), 2000, DoubleFunctionIntegrationTest.parameterError(0, SqlColumnType.DOUBLE, SqlColumnType.TIME), LOCAL_TIME_VAL);
        this.checkFailure0(this.sql("?"), 2000, DoubleFunctionIntegrationTest.parameterError(0, SqlColumnType.DOUBLE, SqlColumnType.TIMESTAMP), LOCAL_DATE_TIME_VAL);
        this.checkFailure0(this.sql("?"), 2000, DoubleFunctionIntegrationTest.parameterError(0, SqlColumnType.DOUBLE, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), OFFSET_DATE_TIME_VAL);
        this.checkFailure0(this.sql("?"), 2000, DoubleFunctionIntegrationTest.parameterError(0, SqlColumnType.DOUBLE, SqlColumnType.OBJECT), OBJECT_VAL);
    }

    private String sql(String operand) {
        return "SELECT " + this.function.name + "(" + operand + ") FROM map";
    }

    @Test
    public void testEquals() {
        DoubleFunction function = DoubleFunction.create((Expression)ConstantExpression.create((Object)1.0, (QueryDataType)QueryDataType.DOUBLE), (int)0);
        DoubleFunctionIntegrationTest.checkEquals(function, DoubleFunction.create((Expression)ConstantExpression.create((Object)1.0, (QueryDataType)QueryDataType.DOUBLE), (int)0), true);
        DoubleFunctionIntegrationTest.checkEquals(function, DoubleFunction.create((Expression)ConstantExpression.create((Object)2.0, (QueryDataType)QueryDataType.DOUBLE), (int)0), false);
        DoubleFunctionIntegrationTest.checkEquals(function, DoubleFunction.create((Expression)ConstantExpression.create((Object)1.0, (QueryDataType)QueryDataType.DOUBLE), (int)1), false);
    }

    @Test
    public void testSerialization() {
        DoubleFunction original = DoubleFunction.create((Expression)ConstantExpression.create((Object)1.0, (QueryDataType)QueryDataType.DOUBLE), (int)0);
        DoubleFunction restored = (DoubleFunction)DoubleFunctionIntegrationTest.serializeAndCheck(original, 54);
        DoubleFunctionIntegrationTest.checkEquals(original, restored, true);
    }

    private static final class FunctionInfo {
        private final String name;

        private FunctionInfo(String name) {
            this.name = name;
        }

        public Double process(Double arg) {
            if (arg == null) {
                return null;
            }
            switch (this.name) {
                case "COS": {
                    return Math.cos(arg);
                }
                case "SIN": {
                    return Math.sin(arg);
                }
                case "TAN": {
                    return Math.tan(arg);
                }
                case "COT": {
                    return 1.0 / Math.tan(arg);
                }
                case "ACOS": {
                    return Math.acos(arg);
                }
                case "ASIN": {
                    return Math.asin(arg);
                }
                case "ATAN": {
                    return Math.atan(arg);
                }
                case "EXP": {
                    return Math.exp(arg);
                }
                case "LN": {
                    return Math.log(arg);
                }
                case "LOG10": {
                    return Math.log10(arg);
                }
                case "DEGREES": {
                    return Math.toDegrees(arg);
                }
                case "RADIANS": {
                    return Math.toRadians(arg);
                }
                case "SQUARE": {
                    return arg * arg;
                }
                case "SQRT": {
                    return Math.sqrt(arg);
                }
                case "CBRT": {
                    return Math.cbrt(arg);
                }
            }
            throw new UnsupportedOperationException("Unsupported function: " + this.name);
        }

        public String toString() {
            return this.name;
        }
    }
}

