/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.expression.math;

import com.hazelcast.jet.sql.impl.expression.ExpressionTestSupport;
import com.hazelcast.jet.sql.impl.support.expressions.ExpressionBiValue;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.sql.SqlColumnType;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.util.Collection;
import java.util.List;
import org.junit.Test;

public abstract class ArithmeticOperatorIntegrationTest
extends ExpressionTestSupport {
    protected static final Period ONE_YEAR_AND_ONE_MONTH = Period.of(1, 1, 0);

    protected abstract String operator();

    protected static Collection<LocalDate> dates() {
        return List.of(LocalDate.of(2023, 1, 1), LocalDate.of(2023, 12, 31), LocalDate.of(2023, 1, 10), LocalDate.of(2023, 7, 10), LocalDate.of(2024, 2, 29), LocalDate.of(2025, 3, 29), LocalDate.now());
    }

    protected static Collection<LocalTime> times() {
        return List.of(LocalTime.MIN, LocalTime.MAX, LocalTime.of(13, 53), LocalTime.now());
    }

    protected static Collection<LocalDateTime> dateTimes() {
        return ArithmeticOperatorIntegrationTest.dates().stream().flatMap(date -> ArithmeticOperatorIntegrationTest.times().stream().map(time -> LocalDateTime.of(date, time))).toList();
    }

    @Test
    public void testVarchar() {
        this.checkUnsupportedForAllTypesCommute(CHAR_VAL, SqlColumnType.VARCHAR);
        this.checkUnsupportedForAllTypesCommute("foo", SqlColumnType.VARCHAR);
    }

    @Test
    public void testBoolean() {
        this.checkUnsupportedForAllTypesCommute(true, SqlColumnType.BOOLEAN);
    }

    @Test
    public void testObject() {
        this.checkUnsupportedForAllTypesCommute(OBJECT_VAL, SqlColumnType.OBJECT);
    }

    @Test
    public void testParameterParameter() {
        this.put(1);
        this.checkFailure0(this.sql("?", "?"), 1008, this.signatureError(SqlTypeName.UNKNOWN, SqlTypeName.UNKNOWN), new Object[0]);
    }

    @Test
    public void testNullLiteral() {
        this.put(1);
        this.checkFailure0(this.sql("null", "null"), 1008, this.signatureError(SqlColumnType.NULL, SqlColumnType.NULL), new Object[0]);
        this.checkFailure0(this.sql("'foo'", "null"), 1008, this.signatureError(SqlColumnType.VARCHAR, SqlColumnType.VARCHAR), new Object[0]);
        this.checkFailure0(this.sql("null", "'foo'"), 1008, this.signatureError(SqlColumnType.VARCHAR, SqlColumnType.VARCHAR), new Object[0]);
        this.checkFailure0(this.sql("true", "null"), 1008, this.signatureError(SqlColumnType.BOOLEAN, SqlColumnType.BOOLEAN), new Object[0]);
        this.checkFailure0(this.sql("null", "true"), 1008, this.signatureError(SqlColumnType.BOOLEAN, SqlColumnType.BOOLEAN), new Object[0]);
        this.checkValue0(this.sql("null", 1), SqlColumnType.TINYINT, null, new Object[0]);
        this.checkValue0(this.sql(1, "null"), SqlColumnType.TINYINT, null, new Object[0]);
        this.checkValue0(this.sql("null", (byte)127), SqlColumnType.SMALLINT, null, new Object[0]);
        this.checkValue0(this.sql((byte)127, "null"), SqlColumnType.SMALLINT, null, new Object[0]);
        this.checkValue0(this.sql("null", (short)Short.MAX_VALUE), SqlColumnType.INTEGER, null, new Object[0]);
        this.checkValue0(this.sql((short)Short.MAX_VALUE, "null"), SqlColumnType.INTEGER, null, new Object[0]);
        this.checkValue0(this.sql("null", Integer.MAX_VALUE), SqlColumnType.BIGINT, null, new Object[0]);
        this.checkValue0(this.sql(Integer.MAX_VALUE, "null"), SqlColumnType.BIGINT, null, new Object[0]);
        this.checkValue0(this.sql("null", Long.MAX_VALUE), SqlColumnType.BIGINT, null, new Object[0]);
        this.checkValue0(this.sql(Long.MAX_VALUE, "null"), SqlColumnType.BIGINT, null, new Object[0]);
        this.checkValue0(this.sql("null", "1.1"), SqlColumnType.DECIMAL, null, new Object[0]);
        this.checkValue0(this.sql("1.1", "null"), SqlColumnType.DECIMAL, null, new Object[0]);
        this.checkValue0(this.sql("null", "1.1E1"), SqlColumnType.DOUBLE, null, new Object[0]);
        this.checkValue0(this.sql("1.1E1", "null"), SqlColumnType.DOUBLE, null, new Object[0]);
    }

    protected void checkUnsupportedForAllTypesCommute(Object field1, SqlColumnType type1) {
        this.checkSignatureErrorCommute(field1, CHAR_VAL, type1, SqlColumnType.VARCHAR);
        this.checkSignatureErrorCommute(field1, "foo", type1, SqlColumnType.VARCHAR);
        this.checkSignatureErrorCommute(field1, (byte)1, type1, SqlColumnType.TINYINT);
        this.checkSignatureErrorCommute(field1, (short)1, type1, SqlColumnType.SMALLINT);
        this.checkSignatureErrorCommute(field1, 1, type1, SqlColumnType.INTEGER);
        this.checkSignatureErrorCommute(field1, 1L, type1, SqlColumnType.BIGINT);
        this.checkSignatureErrorCommute(field1, BIG_INTEGER_VAL, type1, SqlColumnType.DECIMAL);
        this.checkSignatureErrorCommute(field1, BIG_DECIMAL_VAL, type1, SqlColumnType.DECIMAL);
        this.checkSignatureErrorCommute(field1, Float.valueOf(1.0f), type1, SqlColumnType.REAL);
        this.checkSignatureErrorCommute(field1, 1.0, type1, SqlColumnType.DOUBLE);
        this.checkSignatureErrorCommute(field1, LOCAL_DATE_VAL, type1, SqlColumnType.DATE);
        this.checkSignatureErrorCommute(field1, LOCAL_TIME_VAL, type1, SqlColumnType.TIME);
        this.checkSignatureErrorCommute(field1, LOCAL_DATE_TIME_VAL, type1, SqlColumnType.TIMESTAMP);
        this.checkSignatureErrorCommute(field1, OFFSET_DATE_TIME_VAL, type1, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE);
        this.checkSignatureErrorCommute(field1, OBJECT_VAL, type1, SqlColumnType.OBJECT);
    }

    protected void checkFields(Object field1, Object field2, SqlColumnType expectedType, Object expectedResult) {
        this.put(ExpressionBiValue.createBiValue(field1, field2));
        this.checkValue0(this.sql("field1", "field2"), expectedType, expectedResult, new Object[0]);
    }

    protected void checkFieldsCommute(Object field1, Object field2, SqlColumnType expectedType, Object expectedResult) {
        this.put(ExpressionBiValue.createBiValue(field1, field2));
        this.checkValue0(this.sql("field1", "field2"), expectedType, expectedResult, new Object[0]);
        this.checkValue0(this.sql("field2", "field1"), expectedType, expectedResult, new Object[0]);
    }

    protected void checkError(Object field1, Object field2, int errorCode, String errorMessage) {
        this.put(ExpressionBiValue.createBiValue(field1, field2));
        this.checkFailure0(this.sql("field1", "field2"), errorCode, errorMessage, new Object[0]);
    }

    protected void checkErrorCommute(Object field1, Object field2, int errorCode, String errorMessage) {
        this.put(ExpressionBiValue.createBiValue(field1, field2));
        this.checkFailure0(this.sql("field1", "field2"), errorCode, errorMessage, new Object[0]);
        this.checkFailure0(this.sql("field2", "field1"), errorCode, errorMessage, new Object[0]);
    }

    protected void checkSignatureErrorCommute(Object field1, Object field2, SqlColumnType type1, SqlColumnType type2) {
        this.put(ExpressionBiValue.createBiValue(field1, field2));
        this.checkFailure0(this.sql("field1", "field2"), 1008, this.signatureError(type1, type2), new Object[0]);
        this.checkFailure0(this.sql("field2", "field1"), 1008, this.signatureError(type2, type1), new Object[0]);
    }

    protected String sql(Object operand1, Object operand2) {
        return "SELECT " + String.valueOf(operand1) + " " + this.operator() + " " + String.valueOf(operand2) + " FROM map";
    }

    protected String signatureError(Object type1, Object type2) {
        return ArithmeticOperatorIntegrationTest.signatureErrorOperator(this.operator(), type1, type2);
    }

    protected static BigDecimal decimal(Object value) {
        return new BigDecimal(value.toString());
    }
}

