/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.expression.json;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastJsonValue;
import com.hazelcast.jet.sql.SqlJsonTestSupport;
import com.hazelcast.map.IMap;
import com.hazelcast.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import com.hazelcast.sql.HazelcastSqlException;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class JsonValueFunctionIntegrationTest
extends SqlJsonTestSupport {
    private static final ObjectMapper SERIALIZER = new ObjectMapper();

    @BeforeClass
    public static void beforeClass() {
        JsonValueFunctionIntegrationTest.initialize((int)1, null);
    }

    @Test
    public void when_calledWithBasicSyntax_then_varcharIsReturned() {
        this.initMultiTypeObject();
        JsonValueFunctionIntegrationTest.createMapping("test", "bigint", "json");
        JsonValueFunctionIntegrationTest.assertRowsAnyOrder("SELECT JSON_VALUE(this, '$.byteField' error on error) FROM test", JsonValueFunctionIntegrationTest.rows(1, "127"));
        JsonValueFunctionIntegrationTest.assertRowsAnyOrder("SELECT JSON_VALUE(this, '$.shortField') FROM test", JsonValueFunctionIntegrationTest.rows(1, "32767"));
        JsonValueFunctionIntegrationTest.assertRowsAnyOrder("SELECT JSON_VALUE(this, '$.intField') FROM test", JsonValueFunctionIntegrationTest.rows(1, "2147483647"));
        JsonValueFunctionIntegrationTest.assertRowsAnyOrder("SELECT JSON_VALUE(this, '$.longField') FROM test", JsonValueFunctionIntegrationTest.rows(1, "9223372036854775807"));
        JsonValueFunctionIntegrationTest.assertRowsAnyOrder("SELECT JSON_VALUE(this, '$.stringField') FROM test", JsonValueFunctionIntegrationTest.rows(1, "foo"));
        JsonValueFunctionIntegrationTest.assertRowsAnyOrder("SELECT JSON_VALUE(this, '$.charField') FROM test", JsonValueFunctionIntegrationTest.rows(1, "c"));
        JsonValueFunctionIntegrationTest.assertRowsAnyOrder("SELECT JSON_VALUE(this, '$.floatField') FROM test", JsonValueFunctionIntegrationTest.rows(1, "8.1"));
        JsonValueFunctionIntegrationTest.assertRowsAnyOrder("SELECT JSON_VALUE(this, '$.doubleField') FROM test", JsonValueFunctionIntegrationTest.rows(1, "9.123456789012345E50"));
        JsonValueFunctionIntegrationTest.assertRowsAnyOrder("SELECT JSON_VALUE(this, '$.bigDecimalField') FROM test", JsonValueFunctionIntegrationTest.rows(1, "Infinity"));
    }

    @Test
    public void when_calledWithReturning_then_correctTypeIsReturned() {
        this.initMultiTypeObject();
        JsonValueFunctionIntegrationTest.createMapping("test", "bigint", "json");
        JsonValueFunctionIntegrationTest.assertRowsAnyOrder("SELECT JSON_VALUE(this, '$.byteField' RETURNING TINYINT error on error) FROM test", JsonValueFunctionIntegrationTest.rows(1, (byte)127));
        JsonValueFunctionIntegrationTest.assertRowsAnyOrder("SELECT JSON_VALUE(this, '$.shortField' RETURNING SMALLINT) FROM test", JsonValueFunctionIntegrationTest.rows(1, (short)Short.MAX_VALUE));
        JsonValueFunctionIntegrationTest.assertRowsAnyOrder("SELECT JSON_VALUE(this, '$.intField' RETURNING INTEGER) FROM test", JsonValueFunctionIntegrationTest.rows(1, Integer.MAX_VALUE));
        JsonValueFunctionIntegrationTest.assertRowsAnyOrder("SELECT JSON_VALUE(this, '$.longField' RETURNING BIGINT) FROM test", JsonValueFunctionIntegrationTest.rows(1, Long.MAX_VALUE));
        JsonValueFunctionIntegrationTest.assertRowsAnyOrder("SELECT JSON_VALUE(this, '$.stringField' RETURNING VARCHAR) FROM test", JsonValueFunctionIntegrationTest.rows(1, "foo"));
        JsonValueFunctionIntegrationTest.assertRowsAnyOrder("SELECT JSON_VALUE(this, '$.charField' RETURNING VARCHAR) FROM test", JsonValueFunctionIntegrationTest.rows(1, "c"));
        JsonValueFunctionIntegrationTest.assertRowsAnyOrder("SELECT JSON_VALUE(this, '$.floatField' RETURNING REAL) FROM test", JsonValueFunctionIntegrationTest.rows(1, Float.valueOf(8.1f)));
        JsonValueFunctionIntegrationTest.assertRowsAnyOrder("SELECT JSON_VALUE(this, '$.doubleField' RETURNING DOUBLE) FROM test", JsonValueFunctionIntegrationTest.rows(1, 9.123456789012345E50));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonValueFunctionIntegrationTest.query("SELECT JSON_VALUE(this, '$.bigDecimalField' RETURNING DECIMAL error on error) FROM test")).isInstanceOf(HazelcastSqlException.class)).hasMessageContaining("Cannot convert infinite DOUBLE to DECIMAL");
        JsonValueFunctionIntegrationTest.assertRowsAnyOrder("SELECT JSON_VALUE(this, '$.doubleField' RETURNING DECIMAL) FROM test", JsonValueFunctionIntegrationTest.rows(1, new BigDecimal("912345678901234469174827437827584684254557974298624")));
    }

    @Test
    public void test_extendedSyntax() {
        IMap test = JsonValueFunctionIntegrationTest.instance().getMap("test");
        test.put((Object)1L, (Object)JsonValueFunctionIntegrationTest.json(""));
        test.put((Object)2L, (Object)JsonValueFunctionIntegrationTest.json("[1,2,"));
        JsonValueFunctionIntegrationTest.createMapping("test", "bigint", "json");
        Assert.assertNull((Object)JsonValueFunctionIntegrationTest.querySingleValue("SELECT JSON_VALUE(this, '$' NULL ON EMPTY) AS c1 FROM test WHERE __key = 1"));
        Assert.assertEquals((Object)1, (Object)JsonValueFunctionIntegrationTest.querySingleValue("SELECT JSON_VALUE(this, '$' DEFAULT 1 ON EMPTY) AS c1 FROM test WHERE __key = 1"));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonValueFunctionIntegrationTest.query("SELECT JSON_VALUE(this, '$' ERROR ON EMPTY) AS c1 FROM test WHERE __key = 1")).isInstanceOf(HazelcastSqlException.class)).hasMessageContaining("JSON_VALUE evaluated to no value");
        Assert.assertNull((Object)JsonValueFunctionIntegrationTest.querySingleValue("SELECT JSON_VALUE(this, '$' NULL ON ERROR) FROM test WHERE __key = 2"));
        Assert.assertEquals((Object)1, (Object)JsonValueFunctionIntegrationTest.querySingleValue("SELECT JSON_VALUE(this, '$' DEFAULT 1 ON ERROR) AS c1 FROM test WHERE __key = 2"));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonValueFunctionIntegrationTest.query("SELECT JSON_VALUE(this, '$' ERROR ON ERROR) FROM test WHERE __key = 2")).isInstanceOf(HazelcastSqlException.class)).hasMessageContaining("JSON_VALUE failed");
    }

    @Test
    public void test_fullExtendedSyntaxExpression() {
        IMap test = JsonValueFunctionIntegrationTest.instance().getMap("test");
        test.put((Object)1L, (Object)JsonValueFunctionIntegrationTest.json(""));
        test.put((Object)2L, (Object)JsonValueFunctionIntegrationTest.json("[1,2,"));
        test.put((Object)3L, (Object)JsonValueFunctionIntegrationTest.json("[3]"));
        JsonValueFunctionIntegrationTest.createMapping("test", "bigint", "json");
        JsonValueFunctionIntegrationTest.assertRowsAnyOrder("SELECT __key, JSON_VALUE(this, '$[0]' RETURNING BIGINT DEFAULT CAST(1 AS BIGINT) ON EMPTY DEFAULT CAST(2 AS BIGINT) ON ERROR) FROM test", JsonValueFunctionIntegrationTest.rows(2, 1L, 1L, 2L, 2L, 3L, 3L));
    }

    @Test
    public void when_arrayIsReturned_errorIsThrown() {
        IMap test = JsonValueFunctionIntegrationTest.instance().getMap("test");
        test.put((Object)1L, (Object)JsonValueFunctionIntegrationTest.json("[1,2,3]"));
        JsonValueFunctionIntegrationTest.createMapping("test", "bigint", "json");
        Assert.assertNull((Object)JsonValueFunctionIntegrationTest.querySingleValue("SELECT JSON_VALUE(this, '$' NULL ON ERROR) FROM test"));
        Assert.assertEquals((Object)1, (Object)JsonValueFunctionIntegrationTest.querySingleValue("SELECT JSON_VALUE(this, '$' DEFAULT 1 ON ERROR) FROM test"));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonValueFunctionIntegrationTest.query("SELECT JSON_VALUE(this, '$' ERROR ON ERROR) FROM test")).isInstanceOf(HazelcastSqlException.class)).hasMessageContaining("Result of JSON_VALUE cannot be array or object");
    }

    @Test
    public void when_objectIsReturned_then_errorIsThrown() {
        IMap test = JsonValueFunctionIntegrationTest.instance().getMap("test");
        test.put((Object)1L, (Object)JsonValueFunctionIntegrationTest.json("{\"test\":1}"));
        JsonValueFunctionIntegrationTest.createMapping("test", "bigint", "json");
        Assert.assertNull((Object)JsonValueFunctionIntegrationTest.querySingleValue("SELECT JSON_VALUE(this, '$' NULL ON ERROR) FROM test"));
        Assert.assertEquals((Object)1, (Object)JsonValueFunctionIntegrationTest.querySingleValue("SELECT JSON_VALUE(this, '$' DEFAULT 1 ON ERROR) FROM test"));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonValueFunctionIntegrationTest.query("SELECT JSON_VALUE(this, '$' ERROR ON ERROR) FROM test")).isInstanceOf(HazelcastSqlException.class)).hasMessageContaining("Result of JSON_VALUE cannot be array or object");
    }

    @Test
    public void when_duplicatedOnEmptyClause_then_errorIsThrown() {
        String[] sqlQueries;
        for (String sql : sqlQueries = new String[]{"SELECT JSON_VALUE('[1]', '$[0]' NULL ON EMPTY DEFAULT 1 ON EMPTY)", "SELECT JSON_VALUE('[1]', '$[0]' RETURNING BIGINT ERROR ON EMPTY NULL ON EMPTY)", "SELECT JSON_VALUE('[1]', '$[0]' NULL ON ERROR DEFAULT 1 ON EMPTY DEFAULT 2 ON EMPTY)", "SELECT JSON_VALUE('[1]', '$[0]' RETURNING BIGINT ERROR ON ERROR ERROR ON EMPTY NULL ON EMPTY)"}) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonValueFunctionIntegrationTest.query(sql)).isInstanceOf(HazelcastSqlException.class)).hasMessageContaining("Duplicate ON EMPTY clause in JSON_VALUE call");
        }
    }

    @Test
    public void when_duplicatedOnErrorClause_then_errorIsThrown() {
        String[] sqlQueries;
        for (String sql : sqlQueries = new String[]{"SELECT JSON_VALUE('[1]', '$[0]' NULL ON ERROR DEFAULT 1 ON ERROR)", "SELECT JSON_VALUE('[1]', '$[0]' RETURNING BIGINT ERROR ON ERROR NULL ON ERROR)", "SELECT JSON_VALUE('[1]', '$[0]' NULL ON EMPTY DEFAULT 1 ON ERROR DEFAULT 2 ON ERROR)", "SELECT JSON_VALUE('[1]', '$[0]' RETURNING BIGINT ERROR ON EMPTY ERROR ON ERROR NULL ON ERROR)"}) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonValueFunctionIntegrationTest.query(sql)).isInstanceOf(HazelcastSqlException.class)).hasMessageContaining("Duplicate ON ERROR clause in JSON_VALUE call");
        }
    }

    @Test
    public void test_invalidJsonPath() {
        JsonValueFunctionIntegrationTest.createMapping("test", Long.class, String.class);
        JsonValueFunctionIntegrationTest.instance().getSql().execute("INSERT INTO test (__key, this) VALUES (1, '[1,2,3]')", new Object[0]);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonValueFunctionIntegrationTest.query("SELECT JSON_VALUE(this, '') FROM test")).isInstanceOf(HazelcastSqlException.class)).hasMessageEndingWith("Invalid SQL/JSON path expression: Unexpected token at line 1, column 0");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonValueFunctionIntegrationTest.query("SELECT JSON_VALUE(this, '$((@@$#229))') FROM test")).isInstanceOf(HazelcastSqlException.class)).hasMessageEndingWith("Invalid SQL/JSON path expression: Unexpected token at line 1, columns 1 to 2");
    }

    @Test
    public void test_nullLiteral() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonValueFunctionIntegrationTest.query("SELECT JSON_VALUE(null, null)")).isInstanceOf(HazelcastSqlException.class)).hasRootCauseMessage("SQL/JSON path expression cannot be null");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonValueFunctionIntegrationTest.query("SELECT JSON_VALUE('foo', null)")).isInstanceOf(HazelcastSqlException.class)).hasRootCauseMessage("SQL/JSON path expression cannot be null");
        Assert.assertNull((Object)JsonValueFunctionIntegrationTest.querySingleValue("SELECT JSON_VALUE(null, '$.foo')"));
        Assert.assertNull((Object)JsonValueFunctionIntegrationTest.querySingleValue("SELECT JSON_VALUE('bad json', '$' default null on error)"));
        Assert.assertNull((Object)JsonValueFunctionIntegrationTest.querySingleValue("SELECT JSON_VALUE('{\"a\":null}', '$.a')"));
    }

    @Test
    public void test_quotedPropName() {
        IMap test = JsonValueFunctionIntegrationTest.instance().getMap("test");
        test.put((Object)1L, (Object)"{\"first name\":\"value\"}");
        JsonValueFunctionIntegrationTest.createMapping("test", Long.class, String.class);
        Assert.assertEquals((Object)"value", (Object)JsonValueFunctionIntegrationTest.querySingleValue("SELECT JSON_VALUE(this, '$.\"first name\"' DEFAULT 1 ON ERROR) FROM test"));
    }

    @Test
    public void test_nonExistingProp() {
        this.initMultiTypeObject();
        JsonValueFunctionIntegrationTest.createMapping("test", "bigint", "json");
        Assert.assertNull((Object)JsonValueFunctionIntegrationTest.querySingleValue("SELECT JSON_VALUE(this, '$.nonExistingProperty' NULL ON EMPTY DEFAULT 2 ON ERROR) AS c1 FROM test WHERE __key = 1"));
        Assert.assertEquals((Object)1, (Object)JsonValueFunctionIntegrationTest.querySingleValue("SELECT JSON_VALUE(this, '$.nonExistingProperty' DEFAULT 1 ON EMPTY DEFAULT 2 ON ERROR) AS c1 FROM test WHERE __key = 1"));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonValueFunctionIntegrationTest.query("SELECT JSON_VALUE(this, '$.nonExistingProperty' ERROR ON EMPTY DEFAULT 2 ON ERROR) AS c1 FROM test WHERE __key = 1")).isInstanceOf(HazelcastSqlException.class)).hasMessageContaining("JSON_VALUE evaluated to no value");
    }

    @Test
    public void test_returningDateTypes() {
        IMap test = JsonValueFunctionIntegrationTest.instance().getMap("test");
        String jsonStr = "[\"2020-01-01\",\"2020-01-01 13:00:00\",\"13:00:00\",\"2020-01-01T13:00:00Z\"]";
        test.put((Object)1L, (Object)JsonValueFunctionIntegrationTest.json("[\"2020-01-01\",\"2020-01-01 13:00:00\",\"13:00:00\",\"2020-01-01T13:00:00Z\"]"));
        JsonValueFunctionIntegrationTest.createMapping("test", "bigint", "json");
        JsonValueFunctionIntegrationTest.assertRowsAnyOrder("SELECT JSON_VALUE(this, '$[0]' RETURNING DATE) FROM test", JsonValueFunctionIntegrationTest.rows(1, LocalDate.of(2020, 1, 1)));
        JsonValueFunctionIntegrationTest.assertRowsAnyOrder("SELECT JSON_VALUE(this, '$[1]' RETURNING TIMESTAMP) FROM test", JsonValueFunctionIntegrationTest.rows(1, LocalDateTime.of(2020, 1, 1, 13, 0, 0)));
        JsonValueFunctionIntegrationTest.assertRowsAnyOrder("SELECT JSON_VALUE(this, '$[2]' RETURNING TIME) FROM test", JsonValueFunctionIntegrationTest.rows(1, LocalTime.of(13, 0, 0)));
        JsonValueFunctionIntegrationTest.assertRowsAnyOrder("SELECT JSON_VALUE(this, '$[3]' RETURNING TIMESTAMP WITH TIME ZONE) FROM test", JsonValueFunctionIntegrationTest.rows(1, OffsetDateTime.of(2020, 1, 1, 13, 0, 0, 0, ZoneOffset.UTC)));
    }

    private void initMultiTypeObject() {
        String serializedValue;
        MultiTypeObject value = new MultiTypeObject();
        try {
            serializedValue = SERIALIZER.writeValueAsString((Object)value);
        }
        catch (JsonProcessingException e) {
            throw new HazelcastException((Throwable)e);
        }
        IMap test = JsonValueFunctionIntegrationTest.instance().getMap("test");
        test.put((Object)1L, (Object)new HazelcastJsonValue(serializedValue));
    }

    private static class MultiTypeObject {
        public Byte byteField = 127;
        public Short shortField = Short.MAX_VALUE;
        public Integer intField = Integer.MAX_VALUE;
        public Long longField = Long.MAX_VALUE;
        public String stringField = "foo";
        public Character charField = Character.valueOf('c');
        public Float floatField = Float.valueOf(8.1f);
        public Double doubleField = 9.123456789012345E50;
        public BigDecimal bigDecimalField = new BigDecimal("1e1000");

        private MultiTypeObject() {
        }
    }
}

