/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.expression.json;

import com.hazelcast.jet.sql.SqlJsonTestSupport;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.sql.HazelcastSqlException;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class JsonObjectFunctionIntegrationTest
extends SqlJsonTestSupport {
    @BeforeClass
    public static void beforeClass() {
        JsonObjectFunctionIntegrationTest.initialize((int)1, null);
    }

    @Test
    public void test_basicCreation() {
        JsonObjectFunctionIntegrationTest.assertRowsAnyOrder("SELECT JSON_OBJECT('id': 1, 'name': 'hello')", this.jsonObjRow(JsonObjectFunctionIntegrationTest.objectMap("id", 1, "name", "hello")));
        JsonObjectFunctionIntegrationTest.assertRowsAnyOrder("SELECT JSON_OBJECT(KEY 'id' VALUE 1, 'name' VALUE 'hello')", this.jsonObjRow(JsonObjectFunctionIntegrationTest.objectMap("id", 1, "name", "hello")));
        JsonObjectFunctionIntegrationTest.assertRowsAnyOrder("SELECT JSON_OBJECT(KEY 'id' VALUE 1, 'name' VALUE null NULL ON NULL)", this.jsonObjRow(JsonObjectFunctionIntegrationTest.objectMap("id", 1, "name", null)));
        JsonObjectFunctionIntegrationTest.assertRowsAnyOrder("SELECT JSON_OBJECT(KEY 'id' VALUE 1, 'name' VALUE null ABSENT ON NULL)", this.jsonObjRow(JsonObjectFunctionIntegrationTest.objectMap("id", 1)));
    }

    @Test
    public void test_creationFromTableColumns() {
        JsonObjectFunctionIntegrationTest.createMapping("test", Long.class, ClassObj.class);
        JsonObjectFunctionIntegrationTest.instance().getSql().execute("INSERT INTO test VALUES (1, 1, 'testValue')", new Object[0]);
        JsonObjectFunctionIntegrationTest.instance().getSql().execute("INSERT INTO test (__key, id) VALUES (2, 2)", new Object[0]);
        JsonObjectFunctionIntegrationTest.assertRowsAnyOrder("SELECT JSON_OBJECT('objId': id, 'objName': name) FROM test WHERE id = 1", this.jsonObjRow(JsonObjectFunctionIntegrationTest.objectMap("objId", 1L, "objName", "testValue")));
        JsonObjectFunctionIntegrationTest.assertRowsAnyOrder("SELECT JSON_OBJECT(KEY 'objId' VALUE id, 'objName' VALUE name) FROM test WHERE id = 1", this.jsonObjRow(JsonObjectFunctionIntegrationTest.objectMap("objId", 1L, "objName", "testValue")));
        JsonObjectFunctionIntegrationTest.assertRowsAnyOrder("SELECT JSON_OBJECT('objId': id, 'objName': name NULL ON NULL) FROM test WHERE id = 2", this.jsonObjRow(JsonObjectFunctionIntegrationTest.objectMap("objId", 2L, "objName", null)));
        JsonObjectFunctionIntegrationTest.assertRowsAnyOrder("SELECT JSON_OBJECT(KEY 'objId' VALUE id, 'objName' VALUE name ABSENT ON NULL) FROM test WHERE id = 2", this.jsonObjRow(JsonObjectFunctionIntegrationTest.objectMap("objId", 2L)));
    }

    @Test
    public void test_nestedJson() {
        JsonObjectFunctionIntegrationTest.assertRowsAnyOrder("select json_object('a' : cast('\"foo\"' as json),'b' : cast('42' as json),'c' : cast('[1,2,3]' as json))", JsonObjectFunctionIntegrationTest.rows(1, JsonObjectFunctionIntegrationTest.json("{\"a\":\"foo\",\"b\":42,\"c\":[1,2,3]}")));
    }

    @Test
    public void when_badInputType_then_fail() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonObjectFunctionIntegrationTest.query("select json_object(1:2)")).isInstanceOf(HazelcastSqlException.class)).hasMessageEndingWith("The type of keys must be VARCHAR");
    }

    @Test
    public void when_keyWithoutValue_then_fail() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonObjectFunctionIntegrationTest.query("select json_object(key \"foo\")")).isInstanceOf(HazelcastSqlException.class)).hasMessageContaining("Encountered \")\" at line 1, column 29.");
    }

    @Test
    public void test_dateTimeFormats() {
        LocalTime time = LocalTime.of(13, 0, 0);
        LocalDate date = LocalDate.of(2020, 1, 1);
        LocalDateTime dateTime = LocalDateTime.of(2020, 1, 1, 13, 0, 0);
        OffsetDateTime dateTimeTz = OffsetDateTime.of(dateTime, ZoneOffset.UTC);
        JsonObjectFunctionIntegrationTest.assertRowsAnyOrder("SELECT JSON_OBJECT('a':?, 'b':?, 'c':?, 'd':?)", Arrays.asList(time, date, dateTime, dateTimeTz), this.jsonObjRow(JsonObjectFunctionIntegrationTest.objectMap("a", "13:00", "b", "2020-01-01", "c", "2020-01-01T13:00", "d", "2020-01-01T13:00Z")));
    }

    private List<SqlTestSupport.Row> jsonObjRow(Map<Object, Object> values) {
        return JsonObjectFunctionIntegrationTest.rows(1, JsonObjectFunctionIntegrationTest.json(JsonObjectFunctionIntegrationTest.jsonString(values)));
    }

    public static final class ClassObj
    implements Serializable {
        public Long id;
        public String name;

        public ClassObj() {
        }

        public ClassObj(Long id, String name) {
            this.id = id;
            this.name = name;
        }
    }
}

