/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.expression.datetime;

import com.hazelcast.jet.sql.impl.expression.ExpressionTestSupport;
import com.hazelcast.sql.SqlColumnType;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class ToEpochMillisIntegrationTest
extends ExpressionTestSupport {
    private static final long SYSTEM_OFFSET_MILLIS = (long)OffsetDateTime.ofInstant(Instant.EPOCH, ZoneId.systemDefault()).getOffset().getTotalSeconds() * 1000L;
    private static final long START_OF_DAY = OffsetDateTime.now().toLocalDate().atStartOfDay().atZone(ZoneOffset.systemDefault()).toEpochSecond() * 1000L;

    @Test
    public void testColumn() {
        this.checkColumn(this.fromEpochMillis(1L), SqlColumnType.BIGINT, 1L);
        this.checkColumn(this.fromEpochMillis(0L), SqlColumnType.BIGINT, 0L);
        this.checkColumn(this.fromEpochMillis(-1L), SqlColumnType.BIGINT, -1L);
        this.checkColumn(this.fromEpochMillis(1000000000000000000L), SqlColumnType.BIGINT, 1000000000000000000L);
        this.checkColumn(this.fromEpochMillis(-1000000000000000000L), SqlColumnType.BIGINT, -1000000000000000000L);
        this.checkColumn(LocalDate.of(1970, 1, 1), SqlColumnType.BIGINT, -SYSTEM_OFFSET_MILLIS);
        this.checkColumn(LocalTime.of(0, 0, 0), SqlColumnType.BIGINT, START_OF_DAY);
        this.checkColumn(LocalDateTime.of(1970, 1, 1, 0, 0, 0), SqlColumnType.BIGINT, -SYSTEM_OFFSET_MILLIS);
        this.checkColumnFailure("null", 1008, ToEpochMillisIntegrationTest.signatureError(SqlColumnType.VARCHAR));
        this.checkColumnFailure(Float.valueOf(1.0f), 1008, ToEpochMillisIntegrationTest.signatureError(SqlColumnType.REAL));
        this.checkColumnFailure(1.0, 1008, ToEpochMillisIntegrationTest.signatureError(SqlColumnType.DOUBLE));
        this.checkColumnFailure(BigDecimal.valueOf(1L), 1008, ToEpochMillisIntegrationTest.signatureError(SqlColumnType.DECIMAL));
    }

    @Test
    public void testParameter() {
        this.put(0);
        this.checkParameter(this.fromEpochMillis(1L), 1L);
        this.checkParameter(this.fromEpochMillis(0L), 0L);
        this.checkParameter(this.fromEpochMillis(-1L), -1L);
        this.checkParameter(this.fromEpochMillis(1000000000000000000L), 1000000000000000000L);
        this.checkParameter(this.fromEpochMillis(-1000000000000000000L), -1000000000000000000L);
        this.checkParameter(LocalDate.of(1970, 1, 1), -SYSTEM_OFFSET_MILLIS);
        this.checkParameter(LocalTime.of(0, 0, 0), START_OF_DAY);
        this.checkParameter(LocalDateTime.of(1970, 1, 1, 0, 0, 0), -SYSTEM_OFFSET_MILLIS);
        this.checkFailure("?", 2000, ToEpochMillisIntegrationTest.parameterError(0, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, SqlColumnType.VARCHAR), "foo");
        this.checkFailure("?", 2000, ToEpochMillisIntegrationTest.parameterError(0, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, SqlColumnType.BOOLEAN), true);
        this.checkFailure("?", 2000, ToEpochMillisIntegrationTest.parameterError(0, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, SqlColumnType.DECIMAL), BigInteger.ZERO);
        this.checkFailure("?", 2000, ToEpochMillisIntegrationTest.parameterError(0, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, SqlColumnType.DECIMAL), BigDecimal.ZERO);
        this.checkFailure("?", 2000, ToEpochMillisIntegrationTest.parameterError(0, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, SqlColumnType.REAL), Float.valueOf(0.0f));
        this.checkFailure("?", 2000, ToEpochMillisIntegrationTest.parameterError(0, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, SqlColumnType.DOUBLE), 0.0);
        this.checkFailure("?", 2000, ToEpochMillisIntegrationTest.parameterError(0, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, SqlColumnType.OBJECT), OBJECT_VAL);
    }

    @Test
    public void testLiteral() {
        this.put(0);
        this.checkLiteral("CAST('1970-01-01T00:00:00Z' AS TIMESTAMP WITH TIME ZONE)", SqlColumnType.BIGINT, 0L);
        this.checkLiteral("CAST('1970-01-01T00:00:01Z' AS TIMESTAMP WITH TIME ZONE)", SqlColumnType.BIGINT, 1000L);
        this.checkLiteral("CAST('1969-12-31T23:59:59Z' AS TIMESTAMP WITH TIME ZONE)", SqlColumnType.BIGINT, -1000L);
        this.checkLiteral("null", SqlColumnType.BIGINT, null);
        this.checkLiteral("CAST(CAST('1970-01-01T00:00:01Z' AS TIMESTAMP WITH TIME ZONE) AS TIMESTAMP)", SqlColumnType.BIGINT, 1000L - SYSTEM_OFFSET_MILLIS);
        this.checkLiteral("CAST(CAST('1970-01-01T00:00:01Z' AS TIMESTAMP WITH TIME ZONE) AS DATE)", SqlColumnType.BIGINT, -SYSTEM_OFFSET_MILLIS);
        this.checkLiteral("CAST(CAST('1970-01-01T00:00:01Z' AS TIMESTAMP WITH TIME ZONE) AS TIME)", SqlColumnType.BIGINT, START_OF_DAY + 1000L);
        this.checkFailure("'1'", 1008, ToEpochMillisIntegrationTest.signatureError(SqlColumnType.VARCHAR), new Object[0]);
        this.checkFailure(Float.valueOf(1.0f), 1008, ToEpochMillisIntegrationTest.signatureError(SqlColumnType.DECIMAL), new Object[0]);
        this.checkFailure(1.0, 1008, ToEpochMillisIntegrationTest.signatureError(SqlColumnType.DECIMAL), new Object[0]);
        this.checkFailure("1.0", 1008, ToEpochMillisIntegrationTest.signatureError(SqlColumnType.DECIMAL), new Object[0]);
        this.checkFailure("'1969-12-31T23:59:59Z'", 1008, ToEpochMillisIntegrationTest.signatureError(SqlColumnType.VARCHAR), new Object[0]);
    }

    private OffsetDateTime fromEpochMillis(Long timestamp) {
        Instant instant = Instant.EPOCH.plus((long)timestamp, ChronoUnit.MILLIS);
        return OffsetDateTime.from(instant.atZone(ZoneOffset.systemDefault()));
    }

    private void checkColumn(Object value, SqlColumnType expectedType, Object expectedResult) {
        this.put(value);
        this.check("this", expectedType, expectedResult, new Object[0]);
    }

    private void checkParameter(Object parameterValue, Object expectedValue) {
        this.check("?", SqlColumnType.BIGINT, expectedValue, parameterValue);
    }

    private void checkLiteral(Object literal, SqlColumnType expectedType, Object expectedValue) {
        this.check(literal.toString(), expectedType, expectedValue, new Object[0]);
    }

    private void checkColumnFailure(Object value, int expectedErrorCode, String expectedErrorMessage) {
        this.put(value);
        this.checkFailure("this", expectedErrorCode, expectedErrorMessage, new Object[0]);
    }

    private void checkFailure(Object operand, int expectedErrorCode, String expectedErrorMessage, Object ... params) {
        String sql = "SELECT TO_EPOCH_MILLIS(" + String.valueOf(operand) + ") FROM map";
        this.checkFailure0(sql, expectedErrorCode, expectedErrorMessage, params);
    }

    private void check(Object operand, SqlColumnType expectedType, Object expectedValue, Object ... params) {
        String sql = "SELECT TO_EPOCH_MILLIS(" + String.valueOf(operand) + ") FROM map";
        this.checkValue0(sql, expectedType, expectedValue, params);
    }

    private static String signatureError(SqlColumnType type) {
        return ToEpochMillisIntegrationTest.signatureErrorFunction("TO_EPOCH_MILLIS", type);
    }
}

