/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.expression.datetime;

import com.hazelcast.jet.sql.impl.expression.ExpressionTestSupport;
import com.hazelcast.sql.SqlColumnType;
import com.hazelcast.sql.SqlRow;
import com.hazelcast.sql.impl.expression.ConstantExpression;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.datetime.ExtractField;
import com.hazelcast.sql.impl.expression.datetime.ExtractFunction;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.test.HazelcastParametrizedRunner;
import com.hazelcast.test.HazelcastSerialParametersRunnerFactory;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Enclosed.class)
@Parameterized.UseParametersRunnerFactory(value=HazelcastSerialParametersRunnerFactory.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class ExtractFunctionIntegrationTest {
    private static String sql(Object field, Object source) {
        return String.format("SELECT EXTRACT(%s FROM %s) FROM map", field, source);
    }

    private static boolean literalSupported(String type) {
        switch (type) {
            case "TIME": 
            case "DATE": 
            case "TIMESTAMP": {
                return true;
            }
        }
        return false;
    }

    private static String literal(String type, String input) {
        switch (type) {
            case "TIME": 
            case "DATE": 
            case "TIMESTAMP": 
            case "TIMESTAMP WITH TIME ZONE": {
                return type + " '" + input + "'";
            }
        }
        Assert.fail((String)(type + " not supported for test"));
        return "";
    }

    private static TestCase create(String type, String input, Object objectInput, Map<String, Double> results) {
        return new TestCase(type, input, objectInput, results);
    }

    private static Map<String, Double> results(Object ... args) {
        Assert.assertEquals((long)0L, (long)(args.length % 2));
        HashMap<String, Double> expectedResults = new HashMap<String, Double>();
        for (int i = 0; i < args.length; i += 2) {
            Object arg0 = args[i];
            Object arg1 = args[i + 1];
            HazelcastTestSupport.assertInstanceOf(String.class, (Object)arg0);
            HazelcastTestSupport.assertInstanceOf(Double.class, (Object)arg1);
            expectedResults.put((String)args[i], (Double)args[i + 1]);
        }
        return expectedResults;
    }

    private static class TestCase {
        private final String type;
        private final String input;
        private final Object parameterInput;
        private final Map<String, Double> results;

        private TestCase(String type, String input, Object parameterInput, Map<String, Double> results) {
            this.type = type;
            this.input = input;
            this.parameterInput = parameterInput;
            this.results = results;
        }
    }

    public static class NormalTests
    extends ExpressionTestSupport {
        @Test
        public void test_null() {
            this.put(1);
            this.checkValue0(ExtractFunctionIntegrationTest.sql("MONTH", "NULL"), SqlColumnType.DOUBLE, null, new Object[0]);
            this.checkFailure0(ExtractFunctionIntegrationTest.sql("NULL", "NULL"), 1008, "Incorrect syntax near the keyword 'NULL' at line 1, column 16", new Object[0]);
        }

        @Test
        public void whenUsingWrongType_thenFail() {
            this.put(1);
            this.checkFailure0(ExtractFunctionIntegrationTest.sql("MONTH", "?"), 2000, "Cannot extract field from BOOLEAN", true);
            this.checkFailure0(ExtractFunctionIntegrationTest.sql("MONTH", "?"), 2000, "Cannot extract field from TINYINT", (byte)1);
            this.checkFailure0(ExtractFunctionIntegrationTest.sql("MONTH", "?"), 2000, "Cannot extract field from SMALLINT", (short)1);
            this.checkFailure0(ExtractFunctionIntegrationTest.sql("MONTH", "?"), 2000, "Cannot extract field from INTEGER", 1);
            this.checkFailure0(ExtractFunctionIntegrationTest.sql("MONTH", "?"), 2000, "Cannot extract field from REAL", Float.valueOf(1.0f));
            this.checkFailure0(ExtractFunctionIntegrationTest.sql("MONTH", "?"), 2000, "Cannot extract field from DOUBLE", 1.0);
            this.checkFailure0(ExtractFunctionIntegrationTest.sql("MONTH", "?"), 2000, "Cannot extract field from VARCHAR", "foo");
            this.checkFailure0(ExtractFunctionIntegrationTest.sql("MONTH", "?"), 2000, "Cannot extract field from VARCHAR", CHAR_VAL);
            this.checkFailure0(ExtractFunctionIntegrationTest.sql("MONTH", "?"), 2000, "Cannot extract field from DECIMAL", BIG_DECIMAL_VAL);
            this.checkFailure0(ExtractFunctionIntegrationTest.sql("MONTH", "?"), 2000, "Cannot extract field from DECIMAL", BIG_INTEGER_VAL);
        }

        @Test
        public void whenExtractingUnsupportedFieldFromTime_thenFail() {
            this.put(1);
            this.checkFailure0(ExtractFunctionIntegrationTest.sql("MILLENNIUM", "?"), 2000, "Cannot extract MILLENNIUM from TIME", LOCAL_TIME_VAL);
            this.checkFailure0(ExtractFunctionIntegrationTest.sql("CENTURY", "?"), 2000, "Cannot extract CENTURY from TIME", LOCAL_TIME_VAL);
            this.checkFailure0(ExtractFunctionIntegrationTest.sql("DECADE", "?"), 2000, "Cannot extract DECADE from TIME", LOCAL_TIME_VAL);
            this.checkFailure0(ExtractFunctionIntegrationTest.sql("DOW", "?"), 2000, "Cannot extract DOW from TIME", LOCAL_TIME_VAL);
            this.checkFailure0(ExtractFunctionIntegrationTest.sql("ISODOW", "?"), 2000, "Cannot extract ISODOW from TIME", LOCAL_TIME_VAL);
            this.checkFailure0(ExtractFunctionIntegrationTest.sql("ISOYEAR", "?"), 2000, "Cannot extract ISOYEAR from TIME", LOCAL_TIME_VAL);
            this.checkFailure0(ExtractFunctionIntegrationTest.sql("QUARTER", "?"), 2000, "Cannot extract QUARTER from TIME", LOCAL_TIME_VAL);
            this.checkFailure0(ExtractFunctionIntegrationTest.sql("WEEK", "?"), 2000, "Cannot extract WEEK from TIME", LOCAL_TIME_VAL);
            this.checkFailure0(ExtractFunctionIntegrationTest.sql("DAY", "?"), 2000, "Cannot extract DAY from TIME", LOCAL_TIME_VAL);
            this.checkFailure0(ExtractFunctionIntegrationTest.sql("DOY", "?"), 2000, "Cannot extract DOY from TIME", LOCAL_TIME_VAL);
            this.checkFailure0(ExtractFunctionIntegrationTest.sql("MONTH", "?"), 2000, "Cannot extract MONTH from TIME", LOCAL_TIME_VAL);
        }

        @Test
        public void test_equality() {
            ExtractFunction f = NormalTests.createFunction(ExtractField.DAY, LOCAL_DATE_TIME_VAL, QueryDataType.TIMESTAMP);
            NormalTests.checkEquals(f, NormalTests.createFunction(ExtractField.DAY, LOCAL_DATE_TIME_VAL, QueryDataType.TIMESTAMP), true);
            NormalTests.checkEquals(f, NormalTests.createFunction(ExtractField.MONTH, LOCAL_DATE_TIME_VAL, QueryDataType.TIMESTAMP), false);
            NormalTests.checkEquals(f, NormalTests.createFunction(ExtractField.DAY, LOCAL_DATE_TIME_VAL.plusDays(1L), QueryDataType.TIMESTAMP), false);
            NormalTests.checkEquals(f, NormalTests.createFunction(ExtractField.DAY, LOCAL_DATE_TIME_VAL, QueryDataType.TIMESTAMP_WITH_TZ_DATE), false);
        }

        @Test
        public void test_serialization() {
            ExtractFunction f = NormalTests.createFunction(ExtractField.MONTH, LOCAL_DATE_TIME_VAL, QueryDataType.TIMESTAMP);
            ExtractFunction deserialized = (ExtractFunction)NormalTests.serializeAndCheck(f, 71);
            NormalTests.checkEquals(f, deserialized, true);
            ExtractFunction f2 = NormalTests.createFunction(ExtractField.CENTURY, LOCAL_DATE_TIME_VAL, QueryDataType.TIMESTAMP);
            deserialized = (ExtractFunction)NormalTests.serializeAndCheck(f2, 71);
            NormalTests.checkEquals(f, deserialized, false);
            ExtractFunction f3 = NormalTests.createFunction(ExtractField.MONTH, LOCAL_DATE_TIME_VAL.plusDays(1L), QueryDataType.TIMESTAMP);
            deserialized = (ExtractFunction)NormalTests.serializeAndCheck(f3, 71);
            NormalTests.checkEquals(f, deserialized, false);
        }

        private static ExtractFunction createFunction(ExtractField field, Object value, QueryDataType valueType) {
            return ExtractFunction.create((Expression)ConstantExpression.create((Object)value, (QueryDataType)valueType), (ExtractField)field);
        }
    }

    @RunWith(value=HazelcastParametrizedRunner.class)
    public static class ParameterizedTests
    extends ExpressionTestSupport {
        @Parameterized.Parameter
        public String field;
        @Parameterized.Parameter(value=1)
        public String type;
        @Parameterized.Parameter(value=2)
        public String input;
        @Parameterized.Parameter(value=3)
        public Object parameterInput;
        @Parameterized.Parameter(value=4)
        public double expected;

        @Parameterized.Parameters(name="{index}: EXTRACT({0} FROM {1} ''{2}'') == {4}")
        public static Iterable<Object[]> data() {
            Iterable<TestCase> cases = ParameterizedTests.testCases();
            ArrayList<Object[]> data = new ArrayList<Object[]>();
            for (TestCase c : cases) {
                for (Map.Entry<String, Double> result : c.results.entrySet()) {
                    data.add(new Object[]{result.getKey(), c.type, c.input, c.parameterInput, result.getValue()});
                }
            }
            return data;
        }

        private static Iterable<TestCase> testCases() {
            ArrayList<TestCase> testCases = new ArrayList<TestCase>();
            testCases.add(ExtractFunctionIntegrationTest.create("DATE", "1970-01-01", LocalDate.of(1970, 1, 1), ExtractFunctionIntegrationTest.results("EPOCH", 0.0)));
            testCases.add(ExtractFunctionIntegrationTest.create("DATE", "1970-1-1", LocalDate.of(1970, 1, 1), ExtractFunctionIntegrationTest.results("EPOCH", 0.0)));
            testCases.add(ExtractFunctionIntegrationTest.create("TIMESTAMP", "1970-01-01 00:00:00", LocalDateTime.of(1970, 1, 1, 0, 0, 0, 0), ExtractFunctionIntegrationTest.results("EPOCH", 0.0)));
            testCases.add(ExtractFunctionIntegrationTest.create("TIMESTAMP WITH TIME ZONE", "2010-10-21 10:30:20+02:00", OffsetDateTime.of(2010, 10, 21, 10, 30, 20, 0, ZoneOffset.of("+2")), ExtractFunctionIntegrationTest.results("YEAR", 2010.0, "MONTH", 10.0, "DAY", 21.0, "EPOCH", 1.28764982E9)));
            testCases.add(ExtractFunctionIntegrationTest.create("TIMESTAMP WITH TIME ZONE", "2019-12-31 23:30:00-02:00", OffsetDateTime.of(2019, 12, 31, 23, 30, 0, 0, ZoneOffset.of("-2")), ExtractFunctionIntegrationTest.results("YEAR", 2019.0, "MONTH", 12.0, "DAY", 31.0, "HOUR", 23.0, "EPOCH", 1.5778422E9)));
            testCases.add(ExtractFunctionIntegrationTest.create("TIME", "10:30:20", LocalTime.of(10, 30, 20), ExtractFunctionIntegrationTest.results("HOUR", 10.0, "MINUTE", 30.0, "SECOND", 20.0, "MILLISECOND", 20000.0, "MICROSECOND", 2.0E7)));
            testCases.add(ExtractFunctionIntegrationTest.create("TIME", "10:30:20.456", LocalTime.of(10, 30, 20, 456000000), ExtractFunctionIntegrationTest.results("HOUR", 10.0, "MINUTE", 30.0, "SECOND", 20.0, "MILLISECOND", 20456.0, "MICROSECOND", 2.0456E7)));
            testCases.add(ExtractFunctionIntegrationTest.create("TIME", "10:30:20.456456", LocalTime.of(10, 30, 20, 456456000), ExtractFunctionIntegrationTest.results("HOUR", 10.0, "MINUTE", 30.0, "SECOND", 20.0, "MILLISECOND", 20456.0, "MICROSECOND", 2.0456456E7)));
            testCases.add(ExtractFunctionIntegrationTest.create("TIMESTAMP", "0001-04-23", LocalDateTime.of(1, 4, 23, 0, 0, 0), ExtractFunctionIntegrationTest.results("MILLENNIUM", 1.0, "CENTURY", 1.0, "DECADE", 0.0, "YEAR", 1.0, "ISOYEAR", 1.0, "QUARTER", 2.0, "MONTH", 4.0, "WEEK", 17.0, "DOW", 1.0, "ISODOW", 1.0, "DAY", 23.0, "DOY", 113.0, "HOUR", 0.0, "SECOND", 0.0, "MINUTE", 0.0, "MILLISECOND", 0.0, "MICROSECOND", 0.0, "EPOCH", -6.212592E10)));
            testCases.add(ExtractFunctionIntegrationTest.create("TIMESTAMP", "0001-04-23 13:40:55", LocalDateTime.of(1, 4, 23, 13, 40, 55), ExtractFunctionIntegrationTest.results("MILLENNIUM", 1.0, "CENTURY", 1.0, "DECADE", 0.0, "YEAR", 1.0, "ISOYEAR", 1.0, "QUARTER", 2.0, "MONTH", 4.0, "WEEK", 17.0, "DOW", 1.0, "ISODOW", 1.0, "DAY", 23.0, "DOY", 113.0, "HOUR", 13.0, "MINUTE", 40.0, "SECOND", 55.0, "MILLISECOND", 55000.0, "MICROSECOND", 5.5E7, "EPOCH", -6.2125870745E10)));
            testCases.add(ExtractFunctionIntegrationTest.create("TIMESTAMP", "2006-01-01 00:00:00.0", LocalDateTime.of(2006, 1, 1, 0, 0, 0), ExtractFunctionIntegrationTest.results("MILLENNIUM", 3.0, "CENTURY", 21.0, "DECADE", 200.0, "YEAR", 2006.0, "ISOYEAR", 2005.0, "QUARTER", 1.0, "MONTH", 1.0, "WEEK", 52.0, "DOW", 0.0, "ISODOW", 7.0, "DAY", 1.0, "HOUR", 0.0, "MINUTE", 0.0, "SECOND", 0.0, "MILLISECOND", 0.0, "MICROSECOND", 0.0, "EPOCH", 1.1360736E9)));
            testCases.add(ExtractFunctionIntegrationTest.create("TIMESTAMP", "2001-02-16 20:38:40.123", LocalDateTime.of(2001, 2, 16, 20, 38, 40, 123000000), ExtractFunctionIntegrationTest.results("HOUR", 20.0, "MINUTE", 38.0, "SECOND", 40.0, "MILLISECOND", 40123.0, "MICROSECOND", 4.0123E7, "EPOCH", 9.82355920123E8)));
            testCases.add(ExtractFunctionIntegrationTest.create("TIMESTAMP", "2001-2-16 20:38:40.123", LocalDateTime.of(2001, 2, 16, 20, 38, 40, 123000000), ExtractFunctionIntegrationTest.results("MONTH", 2.0, "HOUR", 20.0, "MINUTE", 38.0, "SECOND", 40.0, "MILLISECOND", 40123.0, "MICROSECOND", 4.0123E7, "EPOCH", 9.82355920123E8)));
            testCases.add(ExtractFunctionIntegrationTest.create("DATE", "2010-10-04", LocalDateTime.of(2010, 10, 4, 0, 0, 0), ExtractFunctionIntegrationTest.results("MILLENNIUM", 3.0, "CENTURY", 21.0, "DECADE", 201.0, "YEAR", 2010.0, "ISOYEAR", 2010.0, "QUARTER", 4.0, "MONTH", 10.0, "DOW", 1.0, "ISODOW", 1.0, "WEEK", 40.0, "DAY", 4.0, "HOUR", 0.0, "MINUTE", 0.0, "SECOND", 0.0, "MILLISECOND", 0.0, "MICROSECOND", 0.0, "EPOCH", 1.2861504E9)));
            testCases.add(ExtractFunctionIntegrationTest.create("DATE", "2000-12-31", LocalDate.of(2000, 12, 31), ExtractFunctionIntegrationTest.results("DOY", 366.0, "MILLENNIUM", 2.0, "CENTURY", 20.0, "DECADE", 200.0)));
            testCases.add(ExtractFunctionIntegrationTest.create("DATE", "2001-12-31", LocalDate.of(2001, 12, 31), ExtractFunctionIntegrationTest.results("DOY", 365.0, "MILLENNIUM", 3.0, "CENTURY", 21.0, "DECADE", 200.0)));
            testCases.add(ExtractFunctionIntegrationTest.create("DATE", "2004-12-31", LocalDate.of(2004, 12, 31), ExtractFunctionIntegrationTest.results("DOY", 366.0)));
            testCases.add(ExtractFunctionIntegrationTest.create("DATE", "2100-12-31", LocalDate.of(2100, 12, 31), ExtractFunctionIntegrationTest.results("MILLENNIUM", 3.0, "DOY", 365.0)));
            testCases.add(ExtractFunctionIntegrationTest.create("DATE", "2021-04-17", LocalDate.of(2021, 4, 17), ExtractFunctionIntegrationTest.results("DOW", 6.0, "ISODOW", 6.0)));
            testCases.add(ExtractFunctionIntegrationTest.create("DATE", "2021-04-18", LocalDate.of(2021, 4, 18), ExtractFunctionIntegrationTest.results("DOW", 0.0, "ISODOW", 7.0)));
            testCases.add(ExtractFunctionIntegrationTest.create("DATE", "2021-04-19", LocalDate.of(2021, 4, 19), ExtractFunctionIntegrationTest.results("DOW", 1.0, "ISODOW", 1.0)));
            testCases.add(ExtractFunctionIntegrationTest.create("DATE", "2005-01-01", LocalDate.of(2005, 1, 1), ExtractFunctionIntegrationTest.results("WEEK", 53.0)));
            testCases.add(ExtractFunctionIntegrationTest.create("DATE", "2006-01-01", LocalDate.of(2006, 1, 1), ExtractFunctionIntegrationTest.results("WEEK", 52.0)));
            testCases.add(ExtractFunctionIntegrationTest.create("DATE", "2012-12-31", LocalDate.of(2012, 12, 31), ExtractFunctionIntegrationTest.results("WEEK", 1.0)));
            return testCases;
        }

        @Test
        public void test() {
            Assume.assumeTrue((boolean)ExtractFunctionIntegrationTest.literalSupported(this.type));
            this.put(1);
            this.check(ExtractFunctionIntegrationTest.sql(this.field, ExtractFunctionIntegrationTest.literal(this.type, this.input)), this.expected, new Object[0]);
        }

        @Test
        public void test_parameter() {
            this.put(1);
            this.check(ExtractFunctionIntegrationTest.sql(this.field, "?"), this.expected, this.parameterInput);
        }

        private <T> void check(String sql, T expectedResult, Object ... parameters) {
            List<SqlRow> rows = ParameterizedTests.execute(sql, parameters);
            SqlRow row = rows.get(0);
            SqlColumnType typeOfReceived = row.getMetadata().getColumn(0).getType();
            Assert.assertEquals((Object)SqlColumnType.DOUBLE, (Object)typeOfReceived);
            Assert.assertEquals(expectedResult, (Object)row.getObject(0));
        }
    }
}

