/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.test;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.impl.pipeline.transform.StreamSourceTransform;
import com.hazelcast.jet.pipeline.SourceBuilder;
import com.hazelcast.jet.pipeline.StreamSource;
import com.hazelcast.jet.sql.impl.connector.test.TestAbstractSqlConnector;
import com.hazelcast.sql.SqlService;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class TestStreamSqlConnector
extends TestAbstractSqlConnector {
    public static final String TYPE_NAME = "TestStream";

    public static void create(SqlService sqlService, String tableName, List<String> names, List<QueryDataTypeFamily> types, Object[] ... values) {
        List<String[]> stringValues = Arrays.stream(values).map(row -> (String[])Arrays.stream(row).map(value -> value == null ? null : value.toString()).toArray(String[]::new)).collect(Collectors.toList());
        TestAbstractSqlConnector.create(sqlService, TYPE_NAME, tableName, names, types, stringValues, true);
    }

    @Override
    protected ProcessorMetaSupplier createProcessorSupplier(FunctionEx<Processor.Context, TestAbstractSqlConnector.TestDataGenerator> createContextFn) {
        StreamSource source = SourceBuilder.stream((String)"stream", createContextFn).fillBufferFn(TestAbstractSqlConnector.TestDataGenerator::fillBuffer).build();
        return (ProcessorMetaSupplier)((StreamSourceTransform)source).metaSupplierFn.apply(null);
    }

    public String typeName() {
        return TYPE_NAME;
    }

    @Nonnull
    public String defaultObjectType() {
        return "stream";
    }
}

