/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.test;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.jet.core.AbstractProcessor;
import com.hazelcast.jet.core.EventTimePolicy;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.sql.impl.connector.HazelcastRexNode;
import com.hazelcast.jet.sql.impl.connector.SqlConnector;
import com.hazelcast.jet.sql.impl.schema.JetTable;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.optimizer.PlanObjectKey;
import com.hazelcast.sql.impl.row.JetSqlRow;
import com.hazelcast.sql.impl.schema.ConstantTableStatistics;
import com.hazelcast.sql.impl.schema.MappingField;
import com.hazelcast.sql.impl.schema.Table;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.TableStatistics;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TestFailingSqlConnector
implements SqlConnector {
    public static final String TYPE_NAME = "FailingSource";
    private static final List<MappingField> FIELD_LIST = Collections.singletonList(new MappingField("v", QueryDataType.BIGINT));

    public String typeName() {
        return TYPE_NAME;
    }

    @Nonnull
    public String defaultObjectType() {
        return "Dummy";
    }

    @Nonnull
    public List<MappingField> resolveAndValidateFields(@Nonnull NodeEngine nodeEngine, @Nonnull SqlConnector.SqlExternalResource externalResource, @Nonnull List<MappingField> userFields) {
        if (!userFields.isEmpty()) {
            throw QueryException.error((String)"Don't specify external fields, they are fixed");
        }
        return FIELD_LIST;
    }

    @Nonnull
    public Table createTable(@Nonnull NodeEngine nodeEngine, @Nonnull String schemaName, @Nonnull String mappingName, @Nonnull SqlConnector.SqlExternalResource externalResource, @Nonnull List<MappingField> resolvedFields) {
        return new TestFailingTable(this, schemaName, mappingName, Util.toList(resolvedFields, field -> new TableField(field.name(), field.type(), false)));
    }

    @Nonnull
    public Vertex fullScanReader(@Nonnull SqlConnector.DagBuildContext context, @Nullable HazelcastRexNode predicate, @Nonnull List<HazelcastRexNode> projection, @Nullable List<Map<String, Expression<?>>> partitionPruningCandidates, @Nullable FunctionEx<ExpressionEvalContext, EventTimePolicy<JetSqlRow>> eventTimePolicyProvider) {
        if (eventTimePolicyProvider != null) {
            throw QueryException.error((String)"Ordering functions are not supported on top of FailingSource mappings");
        }
        return context.getDag().newUniqueVertex("FailingSource[" + context.getTable().getSchemaName() + "." + context.getTable().getSqlName() + "]", FailingP::new);
    }

    private static final class TestFailingTable
    extends JetTable {
        private TestFailingTable(@Nonnull SqlConnector sqlConnector, @Nonnull String schemaName, @Nonnull String name, @Nonnull List<TableField> fields) {
            super(sqlConnector, fields, schemaName, name, (TableStatistics)new ConstantTableStatistics(0L), null, true);
        }

        public PlanObjectKey getObjectKey() {
            return new TestFailingPlanObjectKey(this.getSchemaName(), this.getSqlName());
        }
    }

    private static final class TestFailingPlanObjectKey
    implements PlanObjectKey {
        private final String schemaName;
        private final String name;

        private TestFailingPlanObjectKey(String schemaName, String name) {
            this.schemaName = schemaName;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestFailingPlanObjectKey that = (TestFailingPlanObjectKey)o;
            return Objects.equals(this.schemaName, that.schemaName) && Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hash(this.schemaName, this.name);
        }
    }

    private static final class FailingP
    extends AbstractProcessor {
        private FailingP() {
        }

        public boolean complete() {
            throw new RuntimeException("mock failure");
        }
    }
}

