/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.map;

import com.hazelcast.jet.Util;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.map.IMap;
import com.hazelcast.shaded.com.google.common.collect.ImmutableMap;
import com.hazelcast.sql.SqlResult;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import org.assertj.core.api.Assertions;
import org.junit.BeforeClass;
import org.junit.Test;

public class SqlUpdateTest
extends SqlTestSupport {
    @BeforeClass
    public static void setUpClass() {
        SqlUpdateTest.initialize((int)2, null);
    }

    @Test
    public void update() {
        SqlUpdateTest.createMapping("test_map", Integer.TYPE, Integer.TYPE);
        IMap map = SqlUpdateTest.instance().getMap("test_map");
        map.put(1, 1);
        map.put(2, 2);
        map.put(3, 3);
        this.checkUpdateCount("UPDATE test_map SET this = 100 WHERE __key = 2", 0, new Object[0]);
        Assertions.assertThat((Map)map).containsExactlyInAnyOrderEntriesOf((Map)ImmutableMap.of((Object)1, (Object)1, (Object)2, (Object)100, (Object)3, (Object)3));
    }

    @Test
    public void update_fieldInTheBeginning() {
        SqlUpdateTest.createMapping("test_map", Integer.TYPE, Value.class);
        IMap map = SqlUpdateTest.instance().getMap("test_map");
        map.put(1, new Value(100, 200L, "300"));
        this.checkUpdateCount("UPDATE test_map SET field1 = 200 WHERE __key = 1", 0, new Object[0]);
        Assertions.assertThat((Map)map).containsExactly(new Map.Entry[]{Util.entry((Object)1, (Object)new Value(200, 200L, "300"))});
    }

    @Test
    public void update_fieldInBetween() {
        SqlUpdateTest.createMapping("test_map", Integer.TYPE, Value.class);
        IMap map = SqlUpdateTest.instance().getMap("test_map");
        map.put(1, new Value(100, 200L, "300"));
        this.checkUpdateCount("UPDATE test_map SET field2 = 100 WHERE __key = 1", 0, new Object[0]);
        Assertions.assertThat((Map)map).containsExactly(new Map.Entry[]{Util.entry((Object)1, (Object)new Value(100, 100L, "300"))});
    }

    @Test
    public void update_fieldInTheEnd() {
        SqlUpdateTest.createMapping("test_map", Integer.TYPE, Value.class);
        IMap map = SqlUpdateTest.instance().getMap("test_map");
        map.put(1, new Value(100, 200L, "300"));
        this.checkUpdateCount("UPDATE test_map SET field3 = '400' WHERE __key = 1", 0, new Object[0]);
        Assertions.assertThat((Map)map).containsExactly(new Map.Entry[]{Util.entry((Object)1, (Object)new Value(100, 200L, "400"))});
    }

    @Test
    public void update_mixedOrderOfFields() {
        SqlUpdateTest.createMapping("test_map", Integer.TYPE, Value.class);
        IMap map = SqlUpdateTest.instance().getMap("test_map");
        map.put(1, new Value(100, 200L, "300"));
        this.checkUpdateCount("UPDATE test_map SET field3 = '200', field1 = 400, field2 = 600 WHERE __key = 1", 0, new Object[0]);
        Assertions.assertThat((Map)map).containsExactly(new Map.Entry[]{Util.entry((Object)1, (Object)new Value(400, 600L, "200"))});
    }

    @Test
    public void update_complexExpression() {
        SqlUpdateTest.createMapping("test_map", Integer.TYPE, Value.class);
        IMap map = SqlUpdateTest.instance().getMap("test_map");
        map.put(1, new Value(100, 200L, "300"));
        this.checkUpdateCount("UPDATE test_map SET field2 = 4 * field1 WHERE __key = 1", 0, new Object[0]);
        Assertions.assertThat((Map)map).containsExactly(new Map.Entry[]{Util.entry((Object)1, (Object)new Value(100, 400L, "300"))});
    }

    @Test
    public void update_selfReferentialCast() {
        SqlUpdateTest.createMapping("test_map", Integer.TYPE, Value.class);
        IMap map = SqlUpdateTest.instance().getMap("test_map");
        map.put(1, new Value(100, 200L, "300"));
        this.checkUpdateCount("UPDATE test_map SET field1 = CAST(field3 AS INT) WHERE __key = 1", 0, new Object[0]);
        Assertions.assertThat((Map)map).containsExactly(new Map.Entry[]{Util.entry((Object)1, (Object)new Value(300, 200L, "300"))});
    }

    @Test
    public void update_byKeyOrKey() {
        SqlUpdateTest.createMapping("test_map", Integer.TYPE, Integer.TYPE);
        IMap map = SqlUpdateTest.instance().getMap("test_map");
        map.put(1, 1);
        map.put(2, 2);
        map.put(3, 3);
        this.checkUpdateCount("UPDATE test_map SET this = this + 1 WHERE __key = 1 OR __key = 3", 0, new Object[0]);
        Assertions.assertThat((Map)map).containsExactlyInAnyOrderEntriesOf((Map)ImmutableMap.of((Object)1, (Object)2, (Object)2, (Object)2, (Object)3, (Object)4));
    }

    @Test
    public void update_by_keyAndKey() {
        SqlUpdateTest.createMapping("test_map", Integer.TYPE, Integer.TYPE);
        IMap map = SqlUpdateTest.instance().getMap("test_map");
        map.put(1, 1);
        map.put(2, 2);
        this.checkUpdateCount("UPDATE test_map SET this = this + 1 WHERE __key = 1 AND __key = 2", 0, new Object[0]);
        Assertions.assertThat((Map)map).containsExactlyInAnyOrderEntriesOf((Map)ImmutableMap.of((Object)1, (Object)1, (Object)2, (Object)2));
    }

    @Test
    public void update_dynamicParam() {
        SqlUpdateTest.createMapping("test_map", Integer.TYPE, Value.class);
        IMap map = SqlUpdateTest.instance().getMap("test_map");
        map.put(1, new Value(100, 200L, "300"));
        this.checkUpdateCount("UPDATE test_map SET field3 = 'p-' || ? WHERE __key = 1", 0, "300");
        Assertions.assertThat((Map)map).containsExactly(new Map.Entry[]{Util.entry((Object)1, (Object)new Value(100, 200L, "p-300"))});
    }

    @Test
    public void updateByNonKeyField() {
        SqlUpdateTest.createMapping("test_map", Integer.TYPE, Value.class);
        IMap map = SqlUpdateTest.instance().getMap("test_map");
        map.put(1, new Value(100, 200L, "300"));
        this.checkUpdateCount("UPDATE test_map SET field3 = '600' WHERE field1 = 100", 0, new Object[0]);
        Assertions.assertThat((Map)map).containsExactly(new Map.Entry[]{Util.entry((Object)1, (Object)new Value(100, 200L, "600"))});
    }

    @Test
    public void update_complexKey() {
        SqlUpdateTest.createMapping("test_map", Key.class, Value.class);
        IMap map = SqlUpdateTest.instance().getMap("test_map");
        map.put(new Key(1), new Value(100, 200L, "300"));
        this.checkUpdateCount("UPDATE test_map SET field3 = CAST(3 + keyField AS VARCHAR), field2 = 2 + 1, field1 = 1 WHERE keyField = 1", 0, new Object[0]);
        Assertions.assertThat((Map)map).containsExactly(new Map.Entry[]{Util.entry((Object)new Key(1), (Object)new Value(1, 3L, "4"))});
    }

    @Test
    public void update_complexKeySimpleValue() {
        SqlUpdateTest.createMapping("test_map", Key.class, String.class);
        IMap map = SqlUpdateTest.instance().getMap("test_map");
        map.put(new Key(1), "300");
        this.checkUpdateCount("UPDATE test_map SET this = CAST(3 + keyField AS VARCHAR)", 0, new Object[0]);
        Assertions.assertThat((Map)map).containsExactly(new Map.Entry[]{Util.entry((Object)new Key(1), (Object)"4")});
    }

    @Test
    public void update_basedOnWholeKey() {
        SqlUpdateTest.createMapping("test_map", Key.class, Integer.TYPE);
        IMap map = SqlUpdateTest.instance().getMap("test_map");
        map.put(new Key(1), 1);
        this.checkUpdateCount("UPDATE test_map SET this = CASE WHEN __key IS NULL THEN 2 ELSE 3 END", 0, new Object[0]);
        Assertions.assertThat((Map)map).containsExactly(new Map.Entry[]{Util.entry((Object)new Key(1), (Object)3)});
    }

    @Test
    public void update_basedOnWholeValue() {
        SqlUpdateTest.createMapping("test_map", Integer.TYPE, Value.class);
        IMap map = SqlUpdateTest.instance().getMap("test_map");
        map.put(1, new Value(100, 200L, "300"));
        this.checkUpdateCount("UPDATE test_map SET field1 = CASE WHEN this IS NULL THEN 2 ELSE 3 END", 0, new Object[0]);
        Assertions.assertThat((Map)map).containsExactly(new Map.Entry[]{Util.entry((Object)1, (Object)new Value(3, 200L, "300"))});
    }

    @Test
    public void update_all() {
        SqlUpdateTest.createMapping("test_map", Integer.TYPE, Integer.TYPE);
        IMap map = SqlUpdateTest.instance().getMap("test_map");
        map.put(1, 1);
        map.put(2, 2);
        this.checkUpdateCount("UPDATE test_map SET this = this + 1", 0, new Object[0]);
        Assertions.assertThat((Map)map).containsExactlyInAnyOrderEntriesOf((Map)ImmutableMap.of((Object)1, (Object)2, (Object)2, (Object)3));
    }

    @Test
    public void update_allWithAlwaysTrueCondition() {
        SqlUpdateTest.createMapping("test_map", Integer.TYPE, Integer.TYPE);
        IMap map = SqlUpdateTest.instance().getMap("test_map");
        map.put(1, 1);
        map.put(2, 2);
        this.checkUpdateCount("UPDATE test_map SET this = this + 1 WHERE 1 = 1", 0, new Object[0]);
        Assertions.assertThat((Map)map).containsExactlyInAnyOrderEntriesOf((Map)ImmutableMap.of((Object)1, (Object)2, (Object)2, (Object)3));
    }

    @Test
    public void when_updateKey_then_fails() {
        SqlUpdateTest.createMapping("test_map", Integer.TYPE, Integer.TYPE);
        SqlUpdateTest.instance().getMap("test_map").put((Object)1, (Object)1);
        Assertions.assertThatThrownBy(() -> this.execute("UPDATE test_map SET __key = 2", new Object[0])).hasMessageContaining("Cannot update '__key'");
    }

    @Test
    public void when_updateKeyField_then_fails() {
        SqlUpdateTest.createMapping("test_map", Key.class, Integer.TYPE);
        SqlUpdateTest.instance().getMap("test_map").put((Object)new Key(1), (Object)1);
        Assertions.assertThatThrownBy(() -> this.execute("UPDATE test_map SET keyField = 2", new Object[0])).hasMessageContaining("Cannot update 'keyField'");
    }

    @Test
    public void when_updateKeyNotHiddenAndHasFields_then_fails() {
        SqlUpdateTest.createMapping("test_map", Key.class, Integer.TYPE);
        IMap map = SqlUpdateTest.instance().getMap("test_map");
        map.put(new Key(1), 1);
        this.execute("CREATE OR REPLACE MAPPING test_map (__key OBJECT, this INT , keyField INT external name \"__key.keyField\") TYPE IMap OPTIONS ( 'keyFormat'='java', 'keyJavaClass'='" + Key.class.getName() + "', 'valueFormat'='int')", new Object[0]);
        Assertions.assertThatThrownBy(() -> this.execute("UPDATE test_map SET __key = null", new Object[0])).hasMessageContaining("Cannot update '__key'");
    }

    @Test
    public void when_updateThis_then_fails() {
        SqlUpdateTest.createMapping("test_map", Integer.TYPE, Value.class);
        IMap map = SqlUpdateTest.instance().getMap("test_map");
        map.put(1, new Value(100, 200L, "300"));
        Assertions.assertThatThrownBy(() -> this.execute("UPDATE test_map SET this = null", new Object[0])).hasMessageContaining("Cannot update 'this'");
    }

    @Test
    public void when_updateThisNotHiddenAndHasFields_then_fails() {
        SqlUpdateTest.createMapping("test_map", Integer.TYPE, Value.class);
        IMap map = SqlUpdateTest.instance().getMap("test_map");
        map.put(1, new Value(1, 2L, "3"));
        this.execute("CREATE OR REPLACE MAPPING test_map (__key INT, this OBJECT , field1 INT) TYPE IMap OPTIONS ( 'keyFormat'='int', 'valueFormat'='java', 'valueJavaClass'='" + Value.class.getName() + "')", new Object[0]);
        Assertions.assertThatThrownBy(() -> this.execute("UPDATE test_map SET this = null", new Object[0])).hasMessageContaining("Cannot update 'this'");
    }

    @Test
    public void when_updateValueToNull_then_fails() {
        SqlUpdateTest.createMapping("test_map", Integer.TYPE, Integer.TYPE);
        SqlUpdateTest.instance().getMap("test_map").put((Object)1, (Object)1);
        Assertions.assertThatThrownBy(() -> this.execute("UPDATE test_map SET this = null", new Object[0])).hasMessageContaining("Cannot assign null to value");
    }

    @Test
    public void when_updateUnknownMapping_then_fails() {
        Assertions.assertThatThrownBy(() -> this.execute("UPDATE test_map SET __key = 1", new Object[0])).hasMessageContaining("Object 'test_map' not found");
    }

    private void checkUpdateCount(String sql, int expected, Object ... params) {
        Assertions.assertThat((long)this.execute(sql, params).updateCount()).isEqualTo((long)expected);
    }

    private SqlResult execute(String sql, Object ... params) {
        return SqlUpdateTest.instance().getSql().execute(sql, params);
    }

    public static class Value
    implements Serializable {
        public int field1;
        public long field2;
        public String field3;

        public Value() {
        }

        public Value(int field1, long field2, String field3) {
            this.field1 = field1;
            this.field2 = field2;
            this.field3 = field3;
        }

        public String toString() {
            return "Value{field1=" + this.field1 + ", field2=" + this.field2 + ", field3=" + this.field3 + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Value value = (Value)o;
            return this.field1 == value.field1 && this.field2 == value.field2 && Objects.equals(this.field3, value.field3);
        }

        public int hashCode() {
            return Objects.hash(this.field1, this.field2, this.field3);
        }
    }

    public static class Key
    implements Serializable {
        public int keyField;

        public Key() {
        }

        public Key(int keyField) {
            this.keyField = keyField;
        }

        public String toString() {
            return "Key{keyField=" + this.keyField + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key value = (Key)o;
            return this.keyField == value.keyField;
        }

        public int hashCode() {
            return Objects.hash(this.keyField);
        }
    }
}

