/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.map;

import com.hazelcast.config.SerializationConfig;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.impl.DefaultSerializationServiceBuilder;
import com.hazelcast.internal.serialization.impl.compact.CompactTestUtil;
import com.hazelcast.internal.serialization.impl.compact.FieldDescriptor;
import com.hazelcast.internal.serialization.impl.compact.SchemaWriter;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadata;
import com.hazelcast.jet.sql.impl.connector.map.MetadataCompactResolver;
import com.hazelcast.jet.sql.impl.connector.map.MetadataPortableResolver;
import com.hazelcast.jet.sql.impl.inject.CompactUpsertTargetDescriptor;
import com.hazelcast.nio.serialization.FieldKind;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.extract.GenericQueryTargetDescriptor;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.schema.MappingField;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.map.MapTableField;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import junitparams.JUnitParamsRunner;
import junitparams.Parameters;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JUnitParamsRunner.class)
public class MetadataCompactResolverTest {
    @Test
    @Parameters(value={"true", "false"})
    public void test_columnListIsRequiredForCompact(boolean key) {
        InternalSerializationService ss = MetadataCompactResolverTest.createSerializationService();
        Map<String, String> options = Map.of(key ? "keyCompactTypeName" : "valueCompactTypeName", "testAll");
        Assertions.assertThatThrownBy(() -> MetadataCompactResolver.INSTANCE.resolveAndValidateFields(key, Collections.emptyList(), options, ss)).hasMessageContaining("Column list is required for Compact format");
    }

    @Test
    @Parameters(value={"true, __key", "false, this"})
    public void test_objectIsForbiddenForCompact(boolean key, String prefix) {
        InternalSerializationService ss = MetadataCompactResolverTest.createSerializationService();
        Map<String, String> options = Map.of(key ? "keyCompactTypeName" : "valueCompactTypeName", "testAll");
        List<MappingField> fields = List.of(MetadataCompactResolverTest.field("object", QueryDataType.OBJECT, prefix + ".object"));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> MetadataCompactResolver.INSTANCE.resolveAndValidateFields(key, fields, options, ss).collect(Collectors.toList())).isInstanceOf(QueryException.class)).hasMessageContaining("Cannot derive Compact type for '" + String.valueOf(QueryDataTypeFamily.OBJECT) + "'");
    }

    @Test
    @Parameters(value={"true, __key", "false, this"})
    public void test_resolveFields(boolean key, String prefix) {
        InternalSerializationService ss = MetadataCompactResolverTest.createSerializationService();
        Map<String, String> options = Map.of(key ? "keyCompactTypeName" : "valueCompactTypeName", "testAll");
        List<MappingField> fields = List.of(MetadataCompactResolverTest.field("string", QueryDataType.VARCHAR, prefix + ".string"), MetadataCompactResolverTest.field("character", QueryDataType.VARCHAR_CHARACTER, prefix + ".character"), MetadataCompactResolverTest.field("boolean", QueryDataType.BOOLEAN, prefix + ".boolean"), MetadataCompactResolverTest.field("byte", QueryDataType.TINYINT, prefix + ".byte"), MetadataCompactResolverTest.field("short", QueryDataType.SMALLINT, prefix + ".short"), MetadataCompactResolverTest.field("int", QueryDataType.INT, prefix + ".int"), MetadataCompactResolverTest.field("long", QueryDataType.BIGINT, prefix + ".long"), MetadataCompactResolverTest.field("float", QueryDataType.REAL, prefix + ".float"), MetadataCompactResolverTest.field("double", QueryDataType.DOUBLE, prefix + ".double"), MetadataCompactResolverTest.field("decimal", QueryDataType.DECIMAL, prefix + ".decimal"), MetadataCompactResolverTest.field("time", QueryDataType.TIME, prefix + ".time"), MetadataCompactResolverTest.field("date", QueryDataType.DATE, prefix + ".date"), MetadataCompactResolverTest.field("timestamp", QueryDataType.TIMESTAMP, prefix + ".timestamp"), MetadataCompactResolverTest.field("timestampTz", QueryDataType.TIMESTAMP_WITH_TZ_OFFSET_DATE_TIME, prefix + ".timestampTz"));
        Stream resolvedFields = MetadataCompactResolver.INSTANCE.resolveAndValidateFields(key, fields, options, ss);
        Assertions.assertThat((Stream)resolvedFields).containsExactlyElementsOf(fields);
    }

    @Test
    @Parameters(value={"true, __key", "false, this"})
    public void test_typeNameIsRequiredToResolveFields(boolean key, String prefix) {
        InternalSerializationService ss = MetadataCompactResolverTest.createSerializationService();
        Map options = Collections.emptyMap();
        Assertions.assertThatThrownBy(() -> MetadataCompactResolver.INSTANCE.resolveAndValidateFields(key, List.of(MetadataCompactResolverTest.field("field", QueryDataType.INT, prefix + ".field")), options, ss)).hasMessageMatching("(key|value)CompactTypeName is required to create Compact-based mapping");
    }

    @Test
    @Parameters(value={"true, __key", "false, this"})
    public void when_duplicateExternalName_then_throws(boolean key, String prefix) {
        InternalSerializationService ss = MetadataCompactResolverTest.createSerializationService();
        Map<String, String> options = Map.of(key ? "keyCompactTypeName" : "valueCompactTypeName", "testAll");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> MetadataPortableResolver.INSTANCE.resolveAndValidateFields(key, List.of(MetadataCompactResolverTest.field("field1", QueryDataType.INT, prefix + ".field"), MetadataCompactResolverTest.field("field2", QueryDataType.VARCHAR, prefix + ".field")), options, ss)).isInstanceOf(QueryException.class)).hasMessageMatching("Duplicate external name: (__key|this).field");
    }

    @Test
    @Parameters(value={"true, __key", "false, this"})
    public void test_resolveMetadata(boolean key, String prefix) {
        KvMetadata metadata = MetadataCompactResolver.INSTANCE.resolveMetadata(key, List.of(MetadataCompactResolverTest.field("boolean", QueryDataType.BOOLEAN, prefix + ".boolean"), MetadataCompactResolverTest.field("byte", QueryDataType.TINYINT, prefix + ".byte"), MetadataCompactResolverTest.field("short", QueryDataType.SMALLINT, prefix + ".short"), MetadataCompactResolverTest.field("int", QueryDataType.INT, prefix + ".int"), MetadataCompactResolverTest.field("long", QueryDataType.BIGINT, prefix + ".long"), MetadataCompactResolverTest.field("float", QueryDataType.REAL, prefix + ".float"), MetadataCompactResolverTest.field("double", QueryDataType.DOUBLE, prefix + ".double"), MetadataCompactResolverTest.field("decimal", QueryDataType.DECIMAL, prefix + ".decimal"), MetadataCompactResolverTest.field("string", QueryDataType.VARCHAR, prefix + ".string"), MetadataCompactResolverTest.field("time", QueryDataType.TIME, prefix + ".time"), MetadataCompactResolverTest.field("date", QueryDataType.DATE, prefix + ".date"), MetadataCompactResolverTest.field("timestamp", QueryDataType.TIMESTAMP, prefix + ".timestamp"), MetadataCompactResolverTest.field("timestampTz", QueryDataType.TIMESTAMP_WITH_TZ_OFFSET_DATE_TIME, prefix + ".timestampTz")), Map.of(key ? "keyCompactTypeName" : "valueCompactTypeName", "test"), MetadataCompactResolverTest.createSerializationService());
        Assertions.assertThat((List)metadata.getFields()).containsExactly((Object[])new TableField[]{new MapTableField("boolean", QueryDataType.BOOLEAN, false, QueryPath.create((String)(prefix + ".boolean"))), new MapTableField("byte", QueryDataType.TINYINT, false, QueryPath.create((String)(prefix + ".byte"))), new MapTableField("short", QueryDataType.SMALLINT, false, QueryPath.create((String)(prefix + ".short"))), new MapTableField("int", QueryDataType.INT, false, QueryPath.create((String)(prefix + ".int"))), new MapTableField("long", QueryDataType.BIGINT, false, QueryPath.create((String)(prefix + ".long"))), new MapTableField("float", QueryDataType.REAL, false, QueryPath.create((String)(prefix + ".float"))), new MapTableField("double", QueryDataType.DOUBLE, false, QueryPath.create((String)(prefix + ".double"))), new MapTableField("decimal", QueryDataType.DECIMAL, false, QueryPath.create((String)(prefix + ".decimal"))), new MapTableField("string", QueryDataType.VARCHAR, false, QueryPath.create((String)(prefix + ".string"))), new MapTableField("time", QueryDataType.TIME, false, QueryPath.create((String)(prefix + ".time"))), new MapTableField("date", QueryDataType.DATE, false, QueryPath.create((String)(prefix + ".date"))), new MapTableField("timestamp", QueryDataType.TIMESTAMP, false, QueryPath.create((String)(prefix + ".timestamp"))), new MapTableField("timestampTz", QueryDataType.TIMESTAMP_WITH_TZ_OFFSET_DATE_TIME, false, QueryPath.create((String)(prefix + ".timestampTz"))), new MapTableField(prefix, QueryDataType.OBJECT, true, QueryPath.create((String)prefix))});
        Assertions.assertThat((Object)metadata.getQueryTargetDescriptor()).isEqualTo((Object)GenericQueryTargetDescriptor.DEFAULT);
        SchemaWriter schemaWriter = new SchemaWriter("test");
        schemaWriter.addField(new FieldDescriptor("boolean", FieldKind.NULLABLE_BOOLEAN));
        schemaWriter.addField(new FieldDescriptor("byte", FieldKind.NULLABLE_INT8));
        schemaWriter.addField(new FieldDescriptor("short", FieldKind.NULLABLE_INT16));
        schemaWriter.addField(new FieldDescriptor("int", FieldKind.NULLABLE_INT32));
        schemaWriter.addField(new FieldDescriptor("long", FieldKind.NULLABLE_INT64));
        schemaWriter.addField(new FieldDescriptor("float", FieldKind.NULLABLE_FLOAT32));
        schemaWriter.addField(new FieldDescriptor("double", FieldKind.NULLABLE_FLOAT64));
        schemaWriter.addField(new FieldDescriptor("decimal", FieldKind.DECIMAL));
        schemaWriter.addField(new FieldDescriptor("string", FieldKind.STRING));
        schemaWriter.addField(new FieldDescriptor("time", FieldKind.TIME));
        schemaWriter.addField(new FieldDescriptor("date", FieldKind.DATE));
        schemaWriter.addField(new FieldDescriptor("timestamp", FieldKind.TIMESTAMP));
        schemaWriter.addField(new FieldDescriptor("timestampTz", FieldKind.TIMESTAMP_WITH_TIMEZONE));
        Assert.assertEquals((Object)metadata.getUpsertTargetDescriptor(), (Object)new CompactUpsertTargetDescriptor(schemaWriter.build()));
    }

    private static InternalSerializationService createSerializationService() {
        return (InternalSerializationService)new DefaultSerializationServiceBuilder().setSchemaService(CompactTestUtil.createInMemorySchemaService()).setConfig(new SerializationConfig()).build();
    }

    private static MappingField field(String name, QueryDataType type, String externalName) {
        return new MappingField(name, type, externalName);
    }
}

