/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.map;

import com.hazelcast.cluster.Address;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.jet.SimpleTestInClusterSupport;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.core.AbstractProcessor;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.core.test.TestSupport;
import com.hazelcast.jet.sql.impl.connector.map.LazyDefiningSpecificMemberPms;
import com.hazelcast.sql.impl.expression.ConstantExpression;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.junit.BeforeClass;
import org.junit.Test;

public class LazyDefiningPMSTest
extends SimpleTestInClusterSupport {
    private static final int ITERATIONS = 1000;
    private static Address ownerAddress;
    private static int partitionKey;

    @BeforeClass
    public static void beforeClass() throws Exception {
        LazyDefiningPMSTest.initialize((int)7, null);
        ownerAddress = LazyDefiningPMSTest.instance().getCluster().getLocalMember().getAddress();
        Map partitionAssignment = LazyDefiningPMSTest.getPartitionAssignment((HazelcastInstance)LazyDefiningPMSTest.instance());
        for (int i = 1; i < 1000; ++i) {
            int partitionId = LazyDefiningPMSTest.instance().getPartitionService().getPartition((Object)i).getPartitionId();
            if (Arrays.binarySearch((int[])partitionAssignment.get(ownerAddress), partitionId) < 0) continue;
            partitionKey = i;
            break;
        }
    }

    @Test
    public void test_partitionArgumentIndex() {
        LazyDefiningSpecificMemberPms pmsGen = (LazyDefiningSpecificMemberPms)LazyDefiningSpecificMemberPms.lazyForceTotalParallelismOne((ProcessorSupplier)new TestGenPSupplier(), (Integer)1);
        JobConfig config = new JobConfig().setArgument("__sql.arguments", List.of(Integer.valueOf(0), Integer.valueOf(partitionKey), Integer.valueOf(2)));
        TestSupport.verifyProcessor((ProcessorMetaSupplier)pmsGen).hazelcastInstance(LazyDefiningPMSTest.instance()).jobConfig(config).disableSnapshots().disableProgressAssertion().expectExactOutput(new TestSupport.TestEvent[]{TestSupport.out((Object)ownerAddress)});
    }

    @Test
    public void test_expressionSupplier() {
        LazyDefiningSpecificMemberPms pmsGen = (LazyDefiningSpecificMemberPms)LazyDefiningSpecificMemberPms.lazyForceTotalParallelismOne((ProcessorSupplier)new TestGenPSupplier(), (SupplierEx & Serializable)() -> ConstantExpression.create((Object)partitionKey, (QueryDataType)QueryDataType.INT));
        JobConfig config = new JobConfig().setArgument("__sql.arguments", List.of(Integer.valueOf(0), Integer.valueOf(partitionKey), Integer.valueOf(2)));
        TestSupport.verifyProcessor((ProcessorMetaSupplier)pmsGen).hazelcastInstance(LazyDefiningPMSTest.instance()).jobConfig(config).disableSnapshots().disableProgressAssertion().expectExactOutput(new TestSupport.TestEvent[]{TestSupport.out((Object)ownerAddress)});
    }

    @Test
    public void test_nonPrunableExpressionSupplier() {
        LazyDefiningSpecificMemberPms pmsGen = (LazyDefiningSpecificMemberPms)LazyDefiningSpecificMemberPms.lazyForceTotalParallelismOne((ProcessorSupplier)new TestGenPSupplier(), (SupplierEx & Serializable)() -> ConstantExpression.create((Object)partitionKey, (QueryDataType)QueryDataType.INT));
        TestSupport.verifyProcessor((ProcessorMetaSupplier)pmsGen).hazelcastInstance(LazyDefiningPMSTest.instance()).disableSnapshots().disableProgressAssertion().expectExactOutput(new TestSupport.TestEvent[]{TestSupport.out((Object)ownerAddress)});
    }

    private static class TestGenPSupplier
    implements ProcessorSupplier {
        private Address ownderAddress;

        private TestGenPSupplier() {
        }

        public void init(@Nonnull ProcessorSupplier.Context context) {
            int[] memberPartitions = context.memberPartitions();
            Map addressMap = context.partitionAssignment();
            for (Map.Entry entry : addressMap.entrySet()) {
                if (!Arrays.equals(memberPartitions, (int[])entry.getValue())) continue;
                this.ownderAddress = (Address)entry.getKey();
            }
            if (this.ownderAddress == null) {
                throw new AssertionError((Object)"No owner address found");
            }
        }

        @Nonnull
        public Collection<? extends Processor> get(int count) {
            return Collections.nCopies(count, new GenP(this.ownderAddress));
        }
    }

    private static class GenP
    extends AbstractProcessor {
        private final Address item;

        GenP(Address item) {
            this.item = item;
        }

        public boolean complete() {
            return this.tryEmit(this.item);
        }

        public boolean closeIsCooperative() {
            return true;
        }
    }
}

