/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.kafka;

import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.kafka.KafkaSqlTestSupport;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.NightlyTest;
import com.hazelcast.test.annotation.ParallelJVMTest;
import java.util.Arrays;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={NightlyTest.class, ParallelJVMTest.class})
public class SqlKafkaAggregateTest
extends KafkaSqlTestSupport {
    private static final int INITIAL_PARTITION_COUNT = 1;

    @Test
    public void test_tumble() {
        String name = SqlKafkaAggregateTest.createRandomTopic(1);
        sqlService.execute("CREATE MAPPING " + name + " TYPE Kafka OPTIONS ( 'keyFormat'='int', 'valueFormat'='varchar', 'bootstrap.servers'='" + kafkaTestSupport.getBrokerConnectionString() + "', 'auto.offset.reset'='earliest')", new Object[0]);
        sqlService.execute("INSERT INTO " + name + " VALUES(0, 'value-0'), (1, 'value-1'), (2, 'value-2'), (10, 'value-10')", new Object[0]);
        SqlKafkaAggregateTest.assertTipOfStream("SELECT window_start, window_end, COUNT(*) FROM TABLE(TUMBLE(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(__key), 2)))  , DESCRIPTOR(__key)  , 2)) GROUP BY window_start, window_end", Arrays.asList(new SqlTestSupport.Row(0, 2, 2L), new SqlTestSupport.Row(2, 4, 1L)));
    }

    @Test
    public void test_hop() {
        String name = SqlKafkaAggregateTest.createRandomTopic(1);
        sqlService.execute("CREATE MAPPING " + name + " TYPE Kafka OPTIONS ( 'keyFormat'='int', 'valueFormat'='varchar', 'bootstrap.servers'='" + kafkaTestSupport.getBrokerConnectionString() + "', 'auto.offset.reset'='earliest')", new Object[0]);
        sqlService.execute("INSERT INTO " + name + " VALUES(0, 'value-0'), (1, 'value-1'), (2, 'value-2'), (10, 'value-10')", new Object[0]);
        SqlKafkaAggregateTest.assertTipOfStream("SELECT window_start, window_end, SUM(__key) FROM TABLE(HOP(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(__key), 2))), DESCRIPTOR(__key), 4, 2)) GROUP BY window_start, window_end", Arrays.asList(new SqlTestSupport.Row(-2, 2, 1L), new SqlTestSupport.Row(0, 4, 3L), new SqlTestSupport.Row(2, 6, 2L)));
    }
}

