/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.kafka;

import com.hazelcast.jet.sql.impl.connector.kafka.KafkaTable;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import junitparams.JUnitParamsRunner;
import junitparams.Parameters;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JUnitParamsRunner.class)
public class KafkaTableTest {
    private Object[] keys() {
        return new Object[]{new Object[]{"schema1", "name1", "topic1", "field1", "value1", "schema1", "name1", "topic1", "field1", "value1", true}, new Object[]{"schema1", "name1", "topic1", "field1", "value1", "schema2", "name1", "topic1", "field1", "value1", false}, new Object[]{"schema1", "name1", "topic1", "field1", "value1", "schema1", "name2", "topic1", "field1", "value1", false}, new Object[]{"schema1", "name1", "topic1", "field1", "value1", "schema1", "name1", "topic2", "field1", "value1", false}, new Object[]{"schema1", "name1", "topic1", "field1", "value1", "schema1", "name1", "topic1", "field2", "value1", false}, new Object[]{"schema1", "name1", "topic1", "field1", "value1", "schema1", "name1", "topic1", "field1", "value2", false}};
    }

    @Test
    @Parameters(method="keys")
    public void test_objectKeyEquality(String schema1, String name1, String topic1, String field1, String value1, String schema2, String name2, String topic2, String field2, String value2, boolean expected) {
        KafkaTable.KafkaPlanObjectKey k1 = new KafkaTable.KafkaPlanObjectKey(schema1, name1, topic1, List.of(new TableField(field1, QueryDataType.INT, false)), Map.of("key", value1));
        KafkaTable.KafkaPlanObjectKey k2 = new KafkaTable.KafkaPlanObjectKey(schema2, name2, topic2, Collections.singletonList(new TableField(field2, QueryDataType.INT, false)), Collections.singletonMap("key", value2));
        Assertions.assertThat((boolean)k1.equals((Object)k2)).isEqualTo(expected);
        Assertions.assertThat((k1.hashCode() == k2.hashCode() ? 1 : 0) != 0).isEqualTo(expected);
    }

    private Object[] preferredLocalParallelisms() {
        return new Object[]{new Object[]{"-2", -2, false}, new Object[]{"-1", -1, false}, new Object[]{"0", 0, false}, new Object[]{"1", 1, false}, new Object[]{"2", 2, false}, new Object[]{"not-an-int", null, true}, new Object[]{"3.14159", null, true}};
    }

    @Test
    @Parameters(method="preferredLocalParallelisms")
    public void when_preferredLocalParallelism_isDefined_then_parseInt(String plp, Integer expected, boolean shouldThrow) {
        KafkaTable table = new KafkaTable(null, null, null, null, null, null, null, Map.of("preferredLocalParallelism", plp), null, null, null, null, null);
        if (shouldThrow) {
            Assertions.assertThatThrownBy(() -> ((KafkaTable)table).preferredLocalParallelism()).isInstanceOf(NumberFormatException.class);
        } else {
            Assertions.assertThat((int)table.preferredLocalParallelism()).isEqualTo((Object)expected);
        }
    }

    @Test
    public void when_preferredLocalParallelism_isNotDefined_then_useDefault() {
        KafkaTable table = new KafkaTable(null, null, null, null, null, null, null, Collections.emptyMap(), null, null, null, null, null);
        Assertions.assertThat((int)table.preferredLocalParallelism()).isEqualTo(4);
    }
}

