/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.kafka;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.dataconnection.DataConnection;
import com.hazelcast.dataconnection.impl.InternalDataConnectionService;
import com.hazelcast.jet.kafka.KafkaDataConnection;
import com.hazelcast.jet.sql.impl.connector.kafka.KafkaSqlTestSupport;
import com.hazelcast.test.Accessors;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.NightlyTest;
import com.hazelcast.test.annotation.ParallelJVMTest;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={NightlyTest.class, ParallelJVMTest.class})
public class KafkaDataConnectionSqlTest
extends KafkaSqlTestSupport {
    @Test
    public void when_createSharedDataConnection_then_success() {
        String dlName = KafkaDataConnectionSqlTest.randomName();
        KafkaDataConnectionSqlTest.createSqlKafkaDataConnection(dlName, true);
        InternalDataConnectionService dataConnectionService = Accessors.getNodeEngineImpl((HazelcastInstance)KafkaDataConnectionSqlTest.instance()).getDataConnectionService();
        DataConnection dataConnection = dataConnectionService.getAndRetainDataConnection(dlName, KafkaDataConnection.class);
        Assertions.assertThat((Object)dataConnection).isNotNull();
        Assertions.assertThat((String)dataConnection.getConfig().getType()).isEqualTo("Kafka");
        Assertions.assertThat((boolean)dataConnection.getConfig().isShared()).isTrue();
    }

    @Test
    public void when_createNonSharedDataConnection_then_success() {
        String dlName = KafkaDataConnectionSqlTest.randomName();
        KafkaDataConnectionSqlTest.createSqlKafkaDataConnection(dlName, false);
        InternalDataConnectionService dataConnectionService = Accessors.getNodeEngineImpl((HazelcastInstance)KafkaDataConnectionSqlTest.instance()).getDataConnectionService();
        DataConnection dataConnection = dataConnectionService.getAndRetainDataConnection(dlName, KafkaDataConnection.class);
        Assertions.assertThat((Object)dataConnection).isNotNull();
        Assertions.assertThat((String)dataConnection.getConfig().getType()).isEqualTo("Kafka");
        Assertions.assertThat((boolean)dataConnection.getConfig().isShared()).isFalse();
    }
}

