/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc.postgres;

import com.hazelcast.jet.sql.impl.connector.jdbc.JdbcTable;
import com.hazelcast.jet.sql.impl.connector.jdbc.postgres.PostgresUpsertQueryBuilder;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlDialect;
import com.hazelcast.shaded.org.apache.calcite.sql.dialect.PostgresqlSqlDialect;
import java.util.Arrays;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class PostgresUpsertQueryBuilderTest {
    @Mock
    JdbcTable jdbcTable;
    SqlDialect dialect = PostgresqlSqlDialect.DEFAULT;

    PostgresUpsertQueryBuilderTest() {
    }

    @BeforeEach
    void setUp() {
        Mockito.when((Object)this.jdbcTable.getExternalNameList()).thenReturn(Collections.singletonList("table1"));
        Mockito.when((Object)this.jdbcTable.getPrimaryKeyList()).thenReturn(Arrays.asList("pk1", "pk2"));
        Mockito.when((Object)this.jdbcTable.dbFieldNames()).thenReturn(Arrays.asList("field1", "field2"));
    }

    @Test
    void testAppendInsertClause() {
        PostgresUpsertQueryBuilder builder = new PostgresUpsertQueryBuilder(this.jdbcTable, this.dialect);
        StringBuilder sb = new StringBuilder();
        builder.appendInsertClause(sb);
        String insertClause = sb.toString();
        Assertions.assertThat((String)insertClause).isEqualTo("INSERT INTO \"table1\" (\"field1\",\"field2\")");
    }

    @Test
    void testAppendValuesClause() {
        PostgresUpsertQueryBuilder builder = new PostgresUpsertQueryBuilder(this.jdbcTable, this.dialect);
        StringBuilder sb = new StringBuilder();
        builder.appendValuesClause(sb);
        String valuesClause = sb.toString();
        Assertions.assertThat((String)valuesClause).isEqualTo("VALUES (?,?)");
    }

    @Test
    void testAppendOnConflictClause() {
        PostgresUpsertQueryBuilder builder = new PostgresUpsertQueryBuilder(this.jdbcTable, this.dialect);
        StringBuilder sb = new StringBuilder();
        builder.appendOnConflictClause(sb);
        String valuesClause = sb.toString();
        Assertions.assertThat((String)valuesClause).isEqualTo("ON CONFLICT (\"pk1\",\"pk2\") DO UPDATE SET \"field1\" = EXCLUDED.\"field1\",\"field2\" = EXCLUDED.\"field2\"");
    }

    @Test
    void testQuery() {
        PostgresUpsertQueryBuilder builder = new PostgresUpsertQueryBuilder(this.jdbcTable, this.dialect);
        String result = builder.query();
        String expected = "INSERT INTO \"table1\" (\"field1\",\"field2\") VALUES (?,?) ON CONFLICT (\"pk1\",\"pk2\") DO UPDATE SET \"field1\" = EXCLUDED.\"field1\",\"field2\" = EXCLUDED.\"field2\"";
        Assertions.assertThat((String)result).isEqualTo(expected);
    }
}

