/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc.mssql;

import com.hazelcast.jet.sql.impl.connector.jdbc.AllTypesInsertJdbcSqlConnectorTest;
import com.hazelcast.test.annotation.NightlyTest;
import com.hazelcast.test.jdbc.MSSQLDatabaseProvider;
import com.hazelcast.test.jdbc.TestDatabaseProvider;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assumptions;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.experimental.categories.Category;
import org.junit.runners.Parameterized;

@Category(value={NightlyTest.class})
public class MSSQLAllTypesInsertJdbcSqlConnectorTest
extends AllTypesInsertJdbcSqlConnectorTest {
    @Parameterized.Parameters(name="type:{0}, mappingType:{1}, sqlValue:{2}, javaValue:{3}, jdbcValue:{4}")
    public static Collection<Object[]> parameters() {
        Collection<Object[]> parentParams = AllTypesInsertJdbcSqlConnectorTest.parameters();
        ArrayList<Object[]> list = new ArrayList<Object[]>(parentParams);
        Object[][] additionalData = new Object[][]{{"DATETIME2", "TIMESTAMP", "'2022-12-30 23:59:59'", LocalDateTime.of(2022, 12, 30, 23, 59, 59), Timestamp.valueOf("2022-12-30 23:59:59")}, {"SMALLDATETIME", "TIMESTAMP", "'2022-12-30 23:59:59'", LocalDateTime.of(2022, 12, 31, 0, 0, 0), Timestamp.valueOf("2022-12-31 00:00:00")}};
        list.addAll(Arrays.asList(additionalData));
        return list;
    }

    @BeforeClass
    public static void beforeClass() {
        MSSQLAllTypesInsertJdbcSqlConnectorTest.initialize((TestDatabaseProvider)new MSSQLDatabaseProvider());
    }

    @Before
    public void setUp() throws Exception {
        ((AbstractStringAssert)Assumptions.assumeThat((String)this.type).describedAs("BOOLEAN not supported on MSSQL", new Object[0])).isNotEqualTo((Object)"BOOLEAN");
        if (this.type.equals("DOUBLE")) {
            this.type = "FLOAT";
        }
        if (this.type.equals("TIMESTAMP")) {
            this.type = "DATETIME";
        }
        if (this.type.equals("TIMESTAMP WITH TIME ZONE")) {
            this.type = "DATETIMEOFFSET";
        }
    }
}

