/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc;

import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.jdbc.JdbcSqlTestSupport;
import com.hazelcast.test.jdbc.H2DatabaseProvider;
import com.hazelcast.test.jdbc.TestDatabaseProvider;
import org.assertj.core.util.Lists;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class JdbcMapJoinTest
extends JdbcSqlTestSupport {
    private static final int ITEM_COUNT = 5;
    private String tableName;

    @BeforeClass
    public static void beforeClass() {
        JdbcMapJoinTest.initialize((TestDatabaseProvider)new H2DatabaseProvider());
    }

    @Before
    public void setUp() throws Exception {
        this.tableName = JdbcMapJoinTest.randomTableName();
        JdbcMapJoinTest.createTable(this.tableName);
        JdbcMapJoinTest.insertItems(this.tableName, 5);
        JdbcMapJoinTest.execute("CREATE MAPPING " + this.tableName + " ( id INT,  name VARCHAR ) DATA CONNECTION testDatabaseRef", new Object[0]);
    }

    @Test
    public void joinWithIMap() {
        String mapName = "my_map";
        JdbcMapJoinTest.execute("CREATE MAPPING " + mapName + " ( __key INT, id INT, name VARCHAR ) TYPE IMap OPTIONS (    'keyFormat' = 'int',    'valueFormat' = 'compact',\n    'valueCompactTypeName' = 'person')", new Object[0]);
        JdbcMapJoinTest.execute("INSERT INTO " + mapName + "(__key, id, name) SELECT v,v,'name-' || v FROM TABLE(generate_series(1,5))", new Object[0]);
        JdbcMapJoinTest.assertRowsAnyOrder("SELECT t1.id, t2.name FROM " + this.tableName + " t1 JOIN " + mapName + " t2    ON t1.id = t2.id", Lists.newArrayList((Object[])new SqlTestSupport.Row[]{new SqlTestSupport.Row(1, "name-1"), new SqlTestSupport.Row(2, "name-2"), new SqlTestSupport.Row(3, "name-3"), new SqlTestSupport.Row(4, "name-4")}));
    }
}

