/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc;

import com.hazelcast.config.Config;
import com.hazelcast.jet.sql.impl.connector.jdbc.JdbcSqlTestSupport;
import java.net.ConnectException;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.BeforeClass;
import org.junit.Test;

public class DbUnreachableJdbcSqlConnectorTest
extends JdbcSqlTestSupport {
    @BeforeClass
    public static void beforeClass() {
        DbUnreachableJdbcSqlConnectorTest.initialize((int)2, (Config)DbUnreachableJdbcSqlConnectorTest.smallInstanceConfig());
        sqlService = DbUnreachableJdbcSqlConnectorTest.instance().getSql();
    }

    @Test
    public void createMappingShouldThrowCorrectExceptionWhenDatabaseNotAvailable() {
        sqlService.executeUpdate("CREATE DATA CONNECTION mysql TYPE JDBC OPTIONS('jdbcUrl'='jdbc:mysql:/fake-host:12345/noSuchDb', 'username'='root', 'password'='123')", new Object[0]);
        AssertionsForClassTypes.assertThatThrownBy(() -> sqlService.executeUpdate("CREATE MAPPING people DATA CONNECTION mysql", new Object[0])).hasStackTraceContaining("Could not create pool for data connection 'mysql'").hasRootCauseInstanceOf(ConnectException.class);
    }
}

