/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.file;

import com.hazelcast.jet.sql.impl.connector.file.JsonResolver;
import com.hazelcast.sql.impl.schema.MappingField;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class JsonResolverTest {
    @Test
    public void test_resolveFields() {
        LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>(){
            {
                this.put("boolean", true);
                this.put("number", 1);
                this.put("string", "string");
                this.put("object", Collections.emptyMap());
                this.put("array", Collections.emptyList());
                this.put("nullValue", null);
                this.put("null", null);
            }
        };
        List fields = JsonResolver.resolveFields((Map)json);
        Assertions.assertThat((List)fields).hasSize(7);
        Assertions.assertThat((Object)((MappingField)fields.get(0))).isEqualTo((Object)new MappingField("boolean", QueryDataType.BOOLEAN));
        Assertions.assertThat((Object)((MappingField)fields.get(1))).isEqualTo((Object)new MappingField("number", QueryDataType.DOUBLE));
        Assertions.assertThat((Object)((MappingField)fields.get(2))).isEqualTo((Object)new MappingField("string", QueryDataType.VARCHAR));
        Assertions.assertThat((Object)((MappingField)fields.get(3))).isEqualTo((Object)new MappingField("object", QueryDataType.OBJECT));
        Assertions.assertThat((Object)((MappingField)fields.get(4))).isEqualTo((Object)new MappingField("array", QueryDataType.OBJECT));
        Assertions.assertThat((Object)((MappingField)fields.get(5))).isEqualTo((Object)new MappingField("nullValue", QueryDataType.OBJECT));
        Assertions.assertThat((Object)((MappingField)fields.get(6))).isEqualTo((Object)new MappingField("null", QueryDataType.OBJECT));
    }
}

