/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl;

import com.hazelcast.config.DataConnectionConfig;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.dataconnection.DataConnection;
import com.hazelcast.dataconnection.impl.DataConnectionTestUtil;
import com.hazelcast.dataconnection.impl.InternalDataConnectionService;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.test.Accessors;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Collections;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class})
public class SqlDataConnectionStatementTest
extends SqlTestSupport {
    private InternalDataConnectionService[] dataConnectionServices;

    @BeforeClass
    public static void beforeClass() throws Exception {
        SqlDataConnectionStatementTest.initialize((int)2, null);
    }

    @Before
    public void setUp() throws Exception {
        this.dataConnectionServices = new InternalDataConnectionService[SqlDataConnectionStatementTest.instances().length];
        for (int i = 0; i < SqlDataConnectionStatementTest.instances().length; ++i) {
            this.dataConnectionServices[i] = Accessors.getNodeEngineImpl((HazelcastInstance)SqlDataConnectionStatementTest.instances()[i]).getDataConnectionService();
        }
    }

    @Test
    public void when_createDataConnection_then_success() {
        String dlName = SqlDataConnectionStatementTest.randomName();
        SqlDataConnectionStatementTest.instance().getSql().executeUpdate("CREATE DATA CONNECTION " + dlName + " TYPE DUMMY  NOT SHARED  OPTIONS ('b' = 'c')", new Object[0]);
        for (InternalDataConnectionService dataConnectionService : this.dataConnectionServices) {
            DataConnection dataConnection = dataConnectionService.getAndRetainDataConnection(dlName, DataConnectionTestUtil.DummyDataConnection.class);
            Assertions.assertThat((Object)dataConnection).isNotNull();
            Assertions.assertThat((String)dataConnection.getConfig().getType()).isEqualTo("DUMMY");
            Assertions.assertThat((boolean)dataConnection.getConfig().isShared()).isFalse();
            Assertions.assertThat((Map)dataConnection.getConfig().getProperties()).containsEntry((Object)"b", (Object)"c");
        }
    }

    @Test
    public void when_createDataConnectionWithCaseInsensitiveName_then_success() {
        String dlName = SqlDataConnectionStatementTest.randomName();
        SqlDataConnectionStatementTest.instance().getSql().executeUpdate("CREATE DATA CONNECTION " + dlName + " TYPE DuMMy  NOT SHARED  OPTIONS ('b' = 'c')", new Object[0]);
        for (InternalDataConnectionService dataConnectionService : this.dataConnectionServices) {
            DataConnection dataConnection = dataConnectionService.getAndRetainDataConnection(dlName, DataConnectionTestUtil.DummyDataConnection.class);
            Assertions.assertThat((Object)dataConnection).isNotNull();
            Assertions.assertThat((String)dataConnection.getConfig().getType()).isEqualTo("DUMMY");
            Assertions.assertThat((boolean)dataConnection.getConfig().isShared()).isFalse();
            Assertions.assertThat((Map)dataConnection.getConfig().getProperties()).containsEntry((Object)"b", (Object)"c");
        }
    }

    @Test
    public void when_createDataConnectionWithWrongType_then_throws() {
        String dlName = SqlDataConnectionStatementTest.randomName() + "_shouldNotExist";
        Assertions.assertThatThrownBy(() -> SqlDataConnectionStatementTest.instance().getSql().executeUpdate("CREATE DATA CONNECTION " + dlName + " TYPE DUMMIES  NOT SHARED  OPTIONS ('b' = 'c')", new Object[0])).hasMessageContaining("Data connection type 'DUMMIES' is not known");
        SqlDataConnectionStatementTest.assertRowsAnyOrder("SELECT * FROM information_schema.dataconnections WHERE name = '" + dlName + "'", Collections.emptyList());
    }

    @Test
    public void when_createSharedDataConnection_then_success() {
        String dlName = SqlDataConnectionStatementTest.randomName();
        SqlDataConnectionStatementTest.instance().getSql().executeUpdate("CREATE DATA CONNECTION " + dlName + " TYPE \"DUMMY\"  SHARED  OPTIONS ('b' = 'c')", new Object[0]);
        for (InternalDataConnectionService dataConnectionService : this.dataConnectionServices) {
            DataConnection dataConnection = dataConnectionService.getAndRetainDataConnection(dlName, DataConnectionTestUtil.DummyDataConnection.class);
            Assertions.assertThat((Object)dataConnection).isNotNull();
            Assertions.assertThat((String)dataConnection.getConfig().getType()).isEqualTo("DUMMY");
            Assertions.assertThat((boolean)dataConnection.getConfig().isShared()).isTrue();
            Assertions.assertThat((Map)dataConnection.getConfig().getProperties()).containsEntry((Object)"b", (Object)"c");
        }
    }

    @Test
    public void when_createDefaultSharingDataConnection_then_success() {
        String dlName = SqlDataConnectionStatementTest.randomName();
        SqlDataConnectionStatementTest.instance().getSql().executeUpdate("CREATE DATA CONNECTION " + dlName + " TYPE \"DUMMY\"  OPTIONS ('b' = 'c')", new Object[0]);
        for (InternalDataConnectionService dataConnectionService : this.dataConnectionServices) {
            DataConnection dataConnection = dataConnectionService.getAndRetainDataConnection(dlName, DataConnectionTestUtil.DummyDataConnection.class);
            Assertions.assertThat((Object)dataConnection).isNotNull();
            Assertions.assertThat((String)dataConnection.getConfig().getType()).isEqualTo("DUMMY");
            Assertions.assertThat((boolean)dataConnection.getConfig().isShared()).isTrue();
            Assertions.assertThat((Map)dataConnection.getConfig().getProperties()).containsEntry((Object)"b", (Object)"c");
        }
    }

    @Test
    public void when_createDataConnection_fullyQualified_then_success() {
        String dlName = SqlDataConnectionStatementTest.randomName();
        SqlDataConnectionStatementTest.instance().getSql().executeUpdate("CREATE DATA CONNECTION hazelcast.public." + dlName + " TYPE \"DUMMY\"  OPTIONS ('b' = 'c')", new Object[0]);
        for (InternalDataConnectionService dataConnectionService : this.dataConnectionServices) {
            DataConnection dataConnection = dataConnectionService.getAndRetainDataConnection(dlName, DataConnectionTestUtil.DummyDataConnection.class);
            Assertions.assertThat((Object)dataConnection).isNotNull();
            Assertions.assertThat((String)dataConnection.getConfig().getType()).isEqualTo("DUMMY");
            Assertions.assertThat((Object)dataConnection.getConfig().getProperties().get("b")).isEqualTo((Object)"c");
        }
    }

    @Test
    public void when_createDataConnectionInWrongNameSpace_then_throws() {
        String dlName = SqlDataConnectionStatementTest.randomName();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SqlDataConnectionStatementTest.instance().getSql().executeUpdate("CREATE DATA CONNECTION hazelcast.yyy." + dlName + " TYPE \"DUMMY\"  NOT SHARED  OPTIONS ('b' = 'c')", new Object[0])).isInstanceOf(HazelcastException.class)).hasMessageContaining("The data connection must be created in the \"public\" schema");
    }

    @Test
    public void when_createDataConnectionIfAlreadyExists_then_throws() {
        String dlName = SqlDataConnectionStatementTest.randomName();
        SqlDataConnectionStatementTest.instance().getSql().executeUpdate("CREATE DATA CONNECTION " + dlName + " TYPE \"DUMMY\"  NOT SHARED  OPTIONS ('b' = 'c')", new Object[0]);
        for (InternalDataConnectionService dataConnectionService : this.dataConnectionServices) {
            DataConnection dataConnection = dataConnectionService.getAndRetainDataConnection(dlName, DataConnectionTestUtil.DummyDataConnection.class);
            Assertions.assertThat((Object)dataConnection).isNotNull();
        }
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SqlDataConnectionStatementTest.instance().getSql().executeUpdate("CREATE DATA CONNECTION " + dlName + " TYPE \"DUMMY\"  NOT SHARED  OPTIONS ('b' = 'c')", new Object[0])).isInstanceOf(HazelcastException.class)).hasMessageContaining("Data connection already exists: " + dlName);
    }

    @Test
    public void when_createDataConnectionIfAlreadyExistsCreatedByConfig_then_throws() {
        String dlName = SqlDataConnectionStatementTest.randomName();
        DataConnectionConfig dataConnectionConfig = new DataConnectionConfig(dlName).setType("DUMMY").setProperty("b", "c");
        for (InternalDataConnectionService dataConnectionService : this.dataConnectionServices) {
            dataConnectionService.createConfigDataConnection(dataConnectionConfig);
        }
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SqlDataConnectionStatementTest.instance().getSql().executeUpdate("CREATE DATA CONNECTION " + dlName + " TYPE \"DUMMY\"  NOT SHARED  OPTIONS ('b' = 'c')", new Object[0])).isInstanceOf(HazelcastException.class)).hasMessageContaining("Cannot replace a data connection created from configuration");
    }

    @Test
    public void when_createDataConnectionWithoutType_then_throws() {
        String dlName = SqlDataConnectionStatementTest.randomName();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SqlDataConnectionStatementTest.instance().getSql().executeUpdate("CREATE DATA CONNECTION " + dlName, new Object[0])).isInstanceOf(HazelcastException.class)).hasMessageContaining("Was expecting one of:" + System.lineSeparator() + "    \"TYPE\" ...");
    }

    @Test
    public void when_createdDataConnectionCreatedAfterMappingWithSameName_then_success() {
        String dlName = SqlDataConnectionStatementTest.randomName();
        SqlDataConnectionStatementTest.createMapping(dlName, Integer.TYPE, Integer.TYPE);
        SqlDataConnectionStatementTest.instance().getSql().executeUpdate("CREATE DATA CONNECTION " + dlName + " TYPE \"DUMMY\"  NOT SHARED  OPTIONS ('b' = 'c')", new Object[0]);
        for (InternalDataConnectionService dataConnectionService : this.dataConnectionServices) {
            DataConnection dataConnection = dataConnectionService.getAndRetainDataConnection(dlName, DataConnectionTestUtil.DummyDataConnection.class);
            Assertions.assertThat((Object)dataConnection).isNotNull();
        }
    }

    @Test
    public void when_createDataConnectionWithoutOptions_then_success() {
        String dlName = SqlDataConnectionStatementTest.randomName();
        SqlDataConnectionStatementTest.instance().getSql().executeUpdate("CREATE DATA CONNECTION " + dlName + " TYPE DUMMY SHARED", new Object[0]);
        for (InternalDataConnectionService dataConnectionService : this.dataConnectionServices) {
            DataConnection dataConnection = dataConnectionService.getAndRetainDataConnection(dlName, DataConnectionTestUtil.DummyDataConnection.class);
            Assertions.assertThat((Object)dataConnection).isNotNull();
        }
    }

    @Test
    public void when_dropDataConnection_then_success() {
        String dlName1 = SqlDataConnectionStatementTest.randomName();
        String dlName2 = SqlDataConnectionStatementTest.randomName();
        SqlDataConnectionStatementTest.instance().getSql().executeUpdate("CREATE DATA CONNECTION " + dlName1 + " TYPE \"DUMMY\"  NOT SHARED  OPTIONS ('b' = 'c')", new Object[0]);
        SqlDataConnectionStatementTest.instance().getSql().executeUpdate("CREATE DATA CONNECTION " + dlName2 + " TYPE \"DUMMY\"  NOT SHARED  OPTIONS ('b' = 'c')", new Object[0]);
        SqlDataConnectionStatementTest.instance().getSql().executeUpdate("DROP DATA CONNECTION " + dlName1, new Object[0]);
        SqlDataConnectionStatementTest.instance().getSql().executeUpdate("DROP DATA CONNECTION IF EXISTS " + dlName2, new Object[0]);
        for (InternalDataConnectionService dataConnectionService : this.dataConnectionServices) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> dataConnectionService.getAndRetainDataConnection(dlName1, DataConnectionTestUtil.DummyDataConnection.class)).isInstanceOf(HazelcastException.class)).hasMessageContaining("Data connection '" + dlName1 + "' not found");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> dataConnectionService.getAndRetainDataConnection(dlName2, DataConnectionTestUtil.DummyDataConnection.class)).isInstanceOf(HazelcastException.class)).hasMessageContaining("Data connection '" + dlName2 + "' not found");
        }
    }

    @Test
    public void when_dropDataConnectionCreatedByConfig_then_throw() {
        String dlName = SqlDataConnectionStatementTest.randomName();
        DataConnectionConfig dataConnectionConfig = new DataConnectionConfig(dlName).setType("DUMMY").setProperty("b", "c");
        for (InternalDataConnectionService dataConnectionService : this.dataConnectionServices) {
            dataConnectionService.createConfigDataConnection(dataConnectionConfig);
        }
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SqlDataConnectionStatementTest.instance().getSql().executeUpdate("DROP DATA CONNECTION " + dlName, new Object[0])).isInstanceOf(HazelcastException.class)).hasMessageContaining("is configured via Config and can't be removed");
    }

    @Test
    public void when_dropNonExistentDataConnection_withIfExists_then_success() {
        SqlDataConnectionStatementTest.instance().getSql().executeUpdate("DROP DATA CONNECTION IF EXISTS " + SqlDataConnectionStatementTest.randomName(), new Object[0]);
    }

    @Test
    public void when_dropNonExistentDataConnection_withoutIfExists_then_throws() {
        String dlName = SqlDataConnectionStatementTest.randomName();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SqlDataConnectionStatementTest.instance().getSql().executeUpdate("DROP DATA CONNECTION " + dlName, new Object[0])).isInstanceOf(HazelcastException.class)).hasMessageContaining("Data connection does not exist");
    }

    @Test
    public void when_createIfNotExists_then_notOverwritten() {
        String dlName = SqlDataConnectionStatementTest.randomName();
        SqlDataConnectionStatementTest.instance().getSql().executeUpdate("CREATE DATA CONNECTION " + dlName + " TYPE \"DUMMY\"  NOT SHARED  OPTIONS ('b' = 'c')", new Object[0]);
        SqlDataConnectionStatementTest.instance().getSql().executeUpdate("CREATE DATA CONNECTION IF NOT EXISTS " + dlName + " TYPE \"DUMMY\"  NOT SHARED  OPTIONS ('d' = 'e')", new Object[0]);
        for (InternalDataConnectionService dataConnectionService : this.dataConnectionServices) {
            DataConnectionTestUtil.DummyDataConnection link = (DataConnectionTestUtil.DummyDataConnection)dataConnectionService.getAndRetainDataConnection(dlName, DataConnectionTestUtil.DummyDataConnection.class);
            Assert.assertNotNull(link.options().get("b"));
            Assert.assertNull(link.options().get("d"));
        }
    }
}

