/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl;

import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.jet.core.JetTestSupport;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.ExpressionUtil;
import com.hazelcast.sql.impl.expression.ColumnExpression;
import com.hazelcast.sql.impl.expression.ConstantExpression;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.expression.FunctionalPredicateExpression;
import com.hazelcast.sql.impl.expression.math.MultiplyFunction;
import com.hazelcast.sql.impl.expression.predicate.ComparisonMode;
import com.hazelcast.sql.impl.expression.predicate.ComparisonPredicate;
import com.hazelcast.sql.impl.row.JetSqlRow;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.mockito.Mockito;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class ExpressionUtilTest {
    @Test
    public void test_join_1() {
        this.test_join((Expression<Boolean>)ConstantExpression.create((Object)true, (QueryDataType)QueryDataType.BOOLEAN), new Object[]{1}, new Object[]{2}, new Object[]{1, 2});
    }

    @Test
    public void test_join_2() {
        this.test_join((Expression<Boolean>)ConstantExpression.create((Object)true, (QueryDataType)QueryDataType.BOOLEAN), new Object[]{1}, new Object[]{2}, new Object[]{1, 2});
    }

    @Test
    public void test_join_3() {
        this.test_join((Expression<Boolean>)ComparisonPredicate.create((Expression)ColumnExpression.create((int)0, (QueryDataType)QueryDataType.INT), (Expression)ColumnExpression.create((int)1, (QueryDataType)QueryDataType.INT), (ComparisonMode)ComparisonMode.GREATER_THAN), new Object[]{1}, new Object[]{2}, null);
    }

    @Test
    public void test_join_4() {
        this.test_join((Expression<Boolean>)ComparisonPredicate.create((Expression)ColumnExpression.create((int)0, (QueryDataType)QueryDataType.INT), (Expression)ColumnExpression.create((int)1, (QueryDataType)QueryDataType.INT), (ComparisonMode)ComparisonMode.LESS_THAN), new Object[]{2}, new Object[]{1}, null);
    }

    private void test_join(Expression<Boolean> predicate, Object[] leftRow, Object[] rightRow, Object[] expected) {
        JetSqlRow joined = ExpressionUtil.join((JetSqlRow)new JetSqlRow((SerializationService)JetTestSupport.TEST_SS, leftRow), (JetSqlRow)new JetSqlRow((SerializationService)JetTestSupport.TEST_SS, rightRow), predicate, (ExpressionEvalContext)SqlTestSupport.createExpressionEvalContext(new Object[0]));
        Assertions.assertThat((Object[])(joined == null ? null : joined.getValues())).isEqualTo((Object)expected);
    }

    @Test
    public void test_evaluate() {
        List rows = Arrays.asList({0, "a"}, {1, "b"});
        List evaluated = ExpressionUtil.evaluate(null, null, rows.stream().map(v -> new JetSqlRow((SerializationService)JetTestSupport.TEST_SS, v)), (ExpressionEvalContext)SqlTestSupport.createExpressionEvalContext(new Object[0]));
        Assertions.assertThat((List)Util.toList((Collection)evaluated, JetSqlRow::getValues)).containsExactlyElementsOf(rows);
    }

    @Test
    public void test_evaluateWithPredicate() {
        List rows = Arrays.asList({0, "a"}, {1, "b"}, {2, "c"});
        FunctionalPredicateExpression predicate = new FunctionalPredicateExpression(row -> {
            int value = (Integer)row.get(0);
            return value != 1;
        });
        List evaluated = ExpressionUtil.evaluate((Expression)predicate, null, rows.stream().map(v -> new JetSqlRow((SerializationService)JetTestSupport.TEST_SS, v)), (ExpressionEvalContext)SqlTestSupport.createExpressionEvalContext(new Object[0]));
        Assertions.assertThat((List)Util.toList((Collection)evaluated, JetSqlRow::getValues)).containsExactly((Object[])new Object[][]{{0, "a"}, {2, "c"}});
    }

    @Test
    public void test_evaluateWithProjection() {
        List rows = Arrays.asList({0, "a"}, {1, "b"}, {2, "c"});
        MultiplyFunction projection = MultiplyFunction.create((Expression)ColumnExpression.create((int)0, (QueryDataType)QueryDataType.INT), (Expression)ConstantExpression.create((Object)2, (QueryDataType)QueryDataType.INT), (QueryDataType)QueryDataType.INT);
        List evaluated = ExpressionUtil.evaluate(null, Collections.singletonList(projection), rows.stream().map(v -> new JetSqlRow((SerializationService)JetTestSupport.TEST_SS, v)), (ExpressionEvalContext)((ExpressionEvalContext)Mockito.mock(ExpressionEvalContext.class)));
        Assertions.assertThat((List)Util.toList((Collection)evaluated, JetSqlRow::getValues)).containsExactly((Object[])new Object[][]{{0}, {2}, {4}});
    }

    @Test
    public void test_evaluateWithPredicateAndProjection() {
        List rows = Arrays.asList({0, "a"}, {1, "b"}, {2, "c"});
        FunctionalPredicateExpression predicate = new FunctionalPredicateExpression(row -> {
            int value = (Integer)row.get(0);
            return value != 1;
        });
        MultiplyFunction projection = MultiplyFunction.create((Expression)ColumnExpression.create((int)0, (QueryDataType)QueryDataType.INT), (Expression)ConstantExpression.create((Object)2, (QueryDataType)QueryDataType.INT), (QueryDataType)QueryDataType.INT);
        List evaluated = ExpressionUtil.evaluate((Expression)predicate, Collections.singletonList(projection), rows.stream().map(v -> new JetSqlRow((SerializationService)JetTestSupport.TEST_SS, v)), (ExpressionEvalContext)((ExpressionEvalContext)Mockito.mock(ExpressionEvalContext.class)));
        Assertions.assertThat((List)Util.toList((Collection)evaluated, JetSqlRow::getValues)).containsExactly((Object[])new Object[][]{{0}, {4}});
    }
}

