/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastJsonValue;
import com.hazelcast.internal.json.Json;
import com.hazelcast.internal.json.JsonObject;
import com.hazelcast.internal.json.JsonValue;
import com.hazelcast.internal.json.ParseException;
import com.hazelcast.jet.Util;
import com.hazelcast.jet.core.test.TestSupport;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.SqlRow;
import com.hazelcast.sql.SqlRowMetadata;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Assert;

public abstract class SqlJsonTestSupport
extends SqlTestSupport {
    private static final ObjectMapper SERIALIZER = new ObjectMapper();

    public static HazelcastJsonValue json(String value) {
        return new HazelcastJsonValue(value);
    }

    public static HazelcastJsonValue jsonArray(Object ... values) {
        return SqlJsonTestSupport.json(SqlJsonTestSupport.jsonString(values));
    }

    public static Object querySingleValue(String sql) {
        List<Map<String, Object>> rows = SqlJsonTestSupport.query(sql);
        Assert.assertEquals((long)1L, (long)rows.size());
        Map<String, Object> row = rows.get(0);
        Assert.assertEquals((long)1L, (long)row.size());
        return row.values().iterator().next();
    }

    public static List<Map<String, Object>> query(String sql) {
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        for (SqlRow row : SqlJsonTestSupport.instance().getSql().execute(sql, new Object[0])) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            SqlRowMetadata rowMetadata = row.getMetadata();
            for (int i = 0; i < rowMetadata.getColumnCount(); ++i) {
                result.put(rowMetadata.getColumn(i).getName(), row.getObject(i));
            }
            results.add(result);
        }
        return results;
    }

    public static Map<Object, Object> objectMap(Object ... kvPairs) {
        LinkedHashMap<Object, Object> result = new LinkedHashMap<Object, Object>();
        for (int i = 0; i < kvPairs.length; i += 2) {
            result.put(kvPairs[i], kvPairs[i + 1]);
        }
        return result;
    }

    public static String jsonString(Object value) {
        try {
            return SERIALIZER.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new HazelcastException("Unable to serialize value: ", (Throwable)e);
        }
    }

    protected void assertJsonRowsAnyOrder(String sql, Collection<SqlTestSupport.Row> rows) {
        this.assertJsonRowsAnyOrder(sql, Collections.emptyList(), rows);
    }

    protected void assertJsonRowsAnyOrder(String sql, List<Object> params, Collection<SqlTestSupport.Row> rows) {
        for (SqlTestSupport.Row row2 : rows) {
            SqlJsonTestSupport.convertRow(row2);
        }
        ArrayList actualRows = new ArrayList();
        try (SqlResult result = SqlJsonTestSupport.instance().getSql().execute(sql, params.toArray());){
            result.iterator().forEachRemaining(row -> actualRows.add(SqlJsonTestSupport.convertRow(new SqlTestSupport.Row((SqlRow)row))));
        }
        Assertions.assertThat(actualRows).containsExactlyInAnyOrderElementsOf(rows);
    }

    private static SqlTestSupport.Row convertRow(SqlTestSupport.Row row) {
        Object[] rowObj = row.getValues();
        for (int i = 0; i < rowObj.length; ++i) {
            if (!(rowObj[i] instanceof HazelcastJsonValue)) continue;
            HazelcastJsonValue value = (HazelcastJsonValue)rowObj[i];
            try {
                if (!(Json.parse((String)value.getValue()) instanceof JsonObject)) continue;
                rowObj[i] = new JsonObjectWithRelaxedEquality(value);
                continue;
            }
            catch (ParseException parseException) {
                throw new HazelcastException("Invalid JSON: " + value.getValue(), (Throwable)parseException);
            }
        }
        return row;
    }

    protected static class JsonObjectWithRelaxedEquality {
        private final List<Map.Entry<String, JsonValue>> fields = new ArrayList<Map.Entry<String, JsonValue>>();

        JsonObjectWithRelaxedEquality(HazelcastJsonValue json) {
            JsonObject jsonObject = (JsonObject)Json.parse((String)json.getValue());
            jsonObject.iterator().forEachRemaining(m -> this.fields.add(Util.entry((Object)m.getName(), (Object)m.getValue())));
        }

        public boolean equals(Object o) {
            return o instanceof JsonObjectWithRelaxedEquality && TestSupport.SAME_ITEMS_ANY_ORDER.test(this.fields, ((JsonObjectWithRelaxedEquality)o).fields);
        }

        public String toString() {
            return this.fields.toString();
        }
    }
}

