/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql;

import com.hazelcast.client.impl.connection.ClientConnection;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.SqlCloseCodec;
import com.hazelcast.client.impl.protocol.codec.SqlExecuteCodec;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.map.IMap;
import com.hazelcast.sql.SqlExpectedResultType;
import com.hazelcast.sql.impl.QueryId;
import com.hazelcast.sql.impl.SqlServiceImpl;
import com.hazelcast.sql.impl.client.SqlClientService;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Collections;
import java.util.UUID;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class SqlClientExecuteCloseRaceTest
extends SqlTestSupport {
    private static final String MAP_NAME = "map";
    private static final String SQL = "SELECT * FROM map";
    private final TestHazelcastFactory factory = new TestHazelcastFactory();
    private SqlServiceImpl memberService;
    private SqlClientService clientService;

    @Before
    public void before() {
        HazelcastInstance member = this.factory.newHazelcastInstance();
        HazelcastInstance client = this.factory.newHazelcastClient();
        SqlClientExecuteCloseRaceTest.createMapping(member, MAP_NAME, Integer.TYPE, Integer.TYPE);
        IMap map = member.getMap(MAP_NAME);
        map.put(0, 0);
        map.put(1, 1);
        this.memberService = (SqlServiceImpl)member.getSql();
        this.clientService = (SqlClientService)client.getSql();
    }

    @After
    public void after() {
        this.factory.shutdownAll();
    }

    @Test
    public void testExecuteClose() {
        QueryId queryId = QueryId.create((UUID)UUID.randomUUID());
        ClientConnection connection = this.clientService.getQueryConnection();
        ClientMessage executeResponse = this.sendExecuteRequest(connection, queryId);
        this.checkExecuteResponse(executeResponse, true);
        Assert.assertEquals((long)1L, (long)this.memberService.getInternalService().getClientStateRegistry().getCursorCount());
        ClientMessage closeRequest = SqlCloseCodec.encodeRequest((QueryId)queryId);
        this.clientService.invokeOnConnection(connection, closeRequest);
        Assert.assertEquals((long)0L, (long)this.memberService.getInternalService().getClientStateRegistry().getCursorCount());
    }

    @Test
    public void testCloseExecute() {
        QueryId queryId = QueryId.create((UUID)UUID.randomUUID());
        ClientConnection connection = this.clientService.getQueryConnection();
        ClientMessage closeRequest = SqlCloseCodec.encodeRequest((QueryId)queryId);
        this.clientService.invokeOnConnection(connection, closeRequest);
        Assert.assertEquals((long)1L, (long)this.memberService.getInternalService().getClientStateRegistry().getCursorCount());
        ClientMessage executeResponse = this.sendExecuteRequest(connection, queryId);
        Assert.assertEquals((long)0L, (long)this.memberService.getInternalService().getClientStateRegistry().getCursorCount());
        this.checkExecuteResponse(executeResponse, false);
    }

    @Test
    public void testClose() {
        QueryId queryId = QueryId.create((UUID)UUID.randomUUID());
        ClientConnection connection = this.clientService.getQueryConnection();
        ClientMessage closeRequest = SqlCloseCodec.encodeRequest((QueryId)queryId);
        this.clientService.invokeOnConnection(connection, closeRequest);
        Assert.assertEquals((long)1L, (long)this.memberService.getInternalService().getClientStateRegistry().getCursorCount());
        this.memberService.getInternalService().getClientStateRegistry().setClosedCursorCleanupTimeoutSeconds(1L);
        SqlClientExecuteCloseRaceTest.assertTrueEventually(() -> Assert.assertEquals((long)0L, (long)this.memberService.getInternalService().getClientStateRegistry().getCursorCount()));
    }

    private void checkExecuteResponse(ClientMessage executeResponse, boolean success) {
        SqlExecuteCodec.ResponseParameters executeResponse0 = SqlExecuteCodec.decodeResponse((ClientMessage)executeResponse);
        if (success) {
            Assert.assertNull((Object)executeResponse0.error);
        } else {
            Assert.assertNotNull((Object)executeResponse0.error);
            Assert.assertEquals((long)1003L, (long)executeResponse0.error.getCode());
        }
    }

    private ClientMessage sendExecuteRequest(ClientConnection connection, QueryId queryId) {
        ClientMessage executeRequest = SqlExecuteCodec.encodeRequest((String)SQL, Collections.emptyList(), (long)0L, (int)1, null, (byte)SqlExpectedResultType.ANY.getId(), (QueryId)queryId, (boolean)false);
        return this.clientService.invokeOnConnection(connection, executeRequest);
    }
}

