/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql;

import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={QuickTest.class, ParallelJVMTest.class})
public class SqlCatalogInitTest
extends SqlTestSupport {
    public static final String MAP_NAME = SqlCatalogInitTest.randomName();
    public static final Config CONFIG = SqlCatalogInitTest.smallInstanceConfig();

    @Test
    public void test() {
        HazelcastInstance instance1 = this.createHazelcastInstance(CONFIG);
        this.createHazelcastInstance(CONFIG);
        SqlCatalogInitTest.createMapping(instance1, MAP_NAME, Integer.class, Integer.class);
        HazelcastInstance instance3 = this.createHazelcastInstance(CONFIG);
        SqlCatalogInitTest.assertClusterSizeEventually((int)3, (HazelcastInstance[])new HazelcastInstance[]{instance3});
        SqlCatalogInitTest.waitAllForSafeState((HazelcastInstance[])new HazelcastInstance[]{instance3});
        try (SqlResult sqlResult = instance3.getSql().execute("select * from " + MAP_NAME, new Object[0]);){
            Assert.assertFalse((boolean)sqlResult.iterator().hasNext());
        }
    }
}

