/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to you under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.hazelcast.shaded.org.apache.calcite.runtime;

import com.hazelcast.shaded.org.apache.calcite.linq4j.Enumerator;

import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;

/**
 * Implementation of {@link com.hazelcast.shaded.org.apache.calcite.avatica.util.Cursor} on top of an
 * {@link com.hazelcast.shaded.org.apache.calcite.linq4j.Enumerator} that
 * returns an array of {@link Object} for each row.
 */
public class ArrayEnumeratorCursor extends EnumeratorCursor<@Nullable Object[]> {
  /**
   * Creates an ArrayEnumeratorCursor.
   *
   * @param enumerator Enumerator
   */
  public ArrayEnumeratorCursor(Enumerator<@Nullable Object[]> enumerator) {
    super(enumerator);
  }

  @Override protected Getter createGetter(int ordinal) {
    return new ArrayGetter(ordinal);
  }
}
