/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.type.converter;

import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import com.hazelcast.sql.impl.type.QueryDataTypeUtils;
import com.hazelcast.sql.impl.type.converter.Converter;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;

public abstract class AbstractStringConverter
extends Converter {
    private static final int MIN_YEAR_SYMBOLS = 4;
    private static final int MAX_YEAR_SYMBOLS = 10;
    static final DateTimeFormatter STANDARD_DATE_FORMAT = new DateTimeFormatterBuilder().parseCaseInsensitive().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 1, 2, SignStyle.NEVER).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 1, 2, SignStyle.NEVER).toFormatter();
    static final DateTimeFormatter STANDARD_TIME_FORMAT = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 1, 2, SignStyle.NEVER).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 1, 2, SignStyle.NEVER).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 1, 2, SignStyle.NEVER).optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).toFormatter();
    static final DateTimeFormatter STANDARD_DATE_TIME_FORMAT = new DateTimeFormatterBuilder().append(STANDARD_DATE_FORMAT).appendPattern("['T'][' ']").append(STANDARD_TIME_FORMAT).toFormatter();
    static final DateTimeFormatter STANDARD_OFFSET_DATE_TIME_FORMAT = new DateTimeFormatterBuilder().parseCaseInsensitive().append(STANDARD_DATE_TIME_FORMAT).appendOffsetId().toFormatter();

    protected AbstractStringConverter(int id) {
        super(id, QueryDataTypeFamily.VARCHAR);
    }

    @Override
    public Class<?> getNormalizedValueClass() {
        return String.class;
    }

    @Override
    public final boolean asBoolean(Object val) {
        String val0 = this.cast(val);
        if (StringUtil.equalsIgnoreCase((String)val0, (String)"true")) {
            return true;
        }
        if (StringUtil.equalsIgnoreCase((String)val0, (String)"false")) {
            return false;
        }
        throw AbstractStringConverter.cannotParseError(QueryDataTypeFamily.BOOLEAN);
    }

    @Override
    public final byte asTinyint(Object val) {
        try {
            return Byte.parseByte(this.cast(val));
        }
        catch (NumberFormatException e) {
            throw AbstractStringConverter.cannotParseError(QueryDataTypeFamily.TINYINT);
        }
    }

    @Override
    public final short asSmallint(Object val) {
        try {
            return Short.parseShort(this.cast(val));
        }
        catch (NumberFormatException e) {
            throw AbstractStringConverter.cannotParseError(QueryDataTypeFamily.SMALLINT);
        }
    }

    @Override
    public final int asInt(Object val) {
        try {
            return Integer.parseInt(this.cast(val));
        }
        catch (NumberFormatException e) {
            throw AbstractStringConverter.cannotParseError(QueryDataTypeFamily.INTEGER);
        }
    }

    @Override
    public final long asBigint(Object val) {
        try {
            return Long.parseLong(this.cast(val));
        }
        catch (NumberFormatException e) {
            throw AbstractStringConverter.cannotParseError(QueryDataTypeFamily.BIGINT);
        }
    }

    @Override
    public final BigDecimal asDecimal(Object val) {
        try {
            return new BigDecimal(this.cast(val), QueryDataTypeUtils.DECIMAL_MATH_CONTEXT);
        }
        catch (NumberFormatException e) {
            throw AbstractStringConverter.cannotParseError(QueryDataTypeFamily.DECIMAL);
        }
    }

    @Override
    public final float asReal(Object val) {
        try {
            return Float.parseFloat(this.cast(val));
        }
        catch (NumberFormatException e) {
            throw AbstractStringConverter.cannotParseError(QueryDataTypeFamily.REAL);
        }
    }

    @Override
    public final double asDouble(Object val) {
        try {
            return Double.parseDouble(this.cast(val));
        }
        catch (NumberFormatException e) {
            throw AbstractStringConverter.cannotParseError(QueryDataTypeFamily.DOUBLE);
        }
    }

    @Override
    public final String asVarchar(Object val) {
        return this.cast(val);
    }

    @Override
    public final LocalDate asDate(Object val) {
        try {
            return LocalDate.parse(this.cast(val), STANDARD_DATE_FORMAT);
        }
        catch (DateTimeParseException e) {
            throw AbstractStringConverter.cannotParseError(QueryDataTypeFamily.DATE);
        }
    }

    @Override
    public final LocalTime asTime(Object val) {
        try {
            return LocalTime.parse(this.cast(val), STANDARD_TIME_FORMAT);
        }
        catch (DateTimeParseException e) {
            throw AbstractStringConverter.cannotParseError(QueryDataTypeFamily.TIME);
        }
    }

    @Override
    public final LocalDateTime asTimestamp(Object val) {
        try {
            return LocalDateTime.parse(this.cast(val), STANDARD_DATE_TIME_FORMAT);
        }
        catch (DateTimeParseException e) {
            throw AbstractStringConverter.cannotParseError(QueryDataTypeFamily.TIMESTAMP);
        }
    }

    @Override
    public final OffsetDateTime asTimestampWithTimezone(Object val) {
        try {
            return OffsetDateTime.parse(this.cast(val), STANDARD_OFFSET_DATE_TIME_FORMAT);
        }
        catch (DateTimeParseException e) {
            throw AbstractStringConverter.cannotParseError(QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE);
        }
    }

    @Override
    public final Object asObject(Object val) {
        return this.asVarchar(val);
    }

    @Override
    public final Object convertToSelf(Converter valConverter, Object val) {
        return valConverter.asVarchar(val);
    }

    protected abstract String cast(Object var1);

    private static QueryException cannotParseError(QueryDataTypeFamily target) {
        String message = "Cannot parse " + String.valueOf((Object)QueryDataTypeFamily.VARCHAR) + " value to " + String.valueOf((Object)target);
        return QueryException.error((int)2000, (String)message);
    }
}

