/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.expression.datetime;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoField;
import java.time.temporal.IsoFields;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalField;
import java.time.temporal.WeekFields;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ExtractField {
    CENTURY{

        @Override
        public double extract(OffsetDateTime time) {
            return this.extractCentury(time);
        }

        @Override
        public double extract(LocalDateTime time) {
            return this.extractCentury(time);
        }

        @Override
        public double extract(LocalDate date) {
            return this.extractCentury(date);
        }

        @Override
        public double extract(LocalTime time) {
            throw new IllegalArgumentException("Cannot extract CENTURY from TIME");
        }

        private double extractCentury(Temporal temporal) {
            int year = temporal.get(ChronoField.YEAR);
            int absYear = Math.abs(year);
            double sign = (double)year < 0.0 ? -1.0 : 1.0;
            int quotient = absYear / 100;
            int remainder = absYear % 100;
            int absCentury = quotient + (remainder == 0 ? -1 : 0) + 1;
            return sign * (double)absCentury;
        }
    }
    ,
    DAY{

        @Override
        public double extract(OffsetDateTime time) {
            return time.getDayOfMonth();
        }

        @Override
        public double extract(LocalDateTime time) {
            return time.getDayOfMonth();
        }

        @Override
        public double extract(LocalDate date) {
            return date.getDayOfMonth();
        }

        @Override
        public double extract(LocalTime time) {
            throw new IllegalArgumentException("Cannot extract DAY from TIME");
        }
    }
    ,
    DECADE{

        @Override
        public double extract(OffsetDateTime time) {
            return this.extractDecade(time);
        }

        @Override
        public double extract(LocalDateTime time) {
            return this.extractDecade(time);
        }

        @Override
        public double extract(LocalDate date) {
            return this.extractDecade(date);
        }

        @Override
        public double extract(LocalTime time) {
            throw new IllegalArgumentException("Cannot extract DECADE from TIME");
        }

        private double extractDecade(Temporal temporal) {
            int year = temporal.get(ChronoField.YEAR);
            return Math.floorDiv(year, 10);
        }
    }
    ,
    DOW{

        @Override
        public double extract(OffsetDateTime time) {
            return this.extractDow(time);
        }

        @Override
        public double extract(LocalDateTime time) {
            return this.extractDow(time);
        }

        @Override
        public double extract(LocalDate date) {
            return this.extractDow(date);
        }

        @Override
        public double extract(LocalTime time) {
            throw new IllegalArgumentException("Cannot extract DOW from TIME");
        }

        private double extractDow(Temporal temporal) {
            int dayOfWeekUnadjusted = temporal.get(WeekFields.SUNDAY_START.dayOfWeek());
            return (double)dayOfWeekUnadjusted - 1.0;
        }
    }
    ,
    DOY{

        @Override
        public double extract(OffsetDateTime time) {
            return time.getDayOfYear();
        }

        @Override
        public double extract(LocalDateTime time) {
            return time.getDayOfYear();
        }

        @Override
        public double extract(LocalDate date) {
            return date.getDayOfYear();
        }

        @Override
        public double extract(LocalTime time) {
            throw new IllegalArgumentException("Cannot extract DOY from TIME");
        }
    }
    ,
    EPOCH{

        @Override
        public double extract(OffsetDateTime time) {
            long secondsSince = time.getLong(ChronoField.INSTANT_SECONDS);
            int carryNanoseconds = time.get(ChronoField.NANO_OF_SECOND);
            double carrySeconds = (double)carryNanoseconds / 1.0E9;
            return carrySeconds + (double)secondsSince;
        }

        @Override
        public double extract(LocalDateTime time) {
            return EPOCH.extract(OffsetDateTime.of(time, ZoneOffset.UTC));
        }

        @Override
        public double extract(LocalDate date) {
            return EPOCH.extract(LocalDateTime.of(date, LocalTime.MIDNIGHT));
        }

        @Override
        public double extract(LocalTime time) {
            return EPOCH.extract(LocalDateTime.of(LocalDate.ofEpochDay(0L), time));
        }
    }
    ,
    HOUR{

        @Override
        public double extract(OffsetDateTime time) {
            return time.getHour();
        }

        @Override
        public double extract(LocalDateTime time) {
            return time.getHour();
        }

        @Override
        public double extract(LocalDate date) {
            return 0.0;
        }

        @Override
        public double extract(LocalTime time) {
            return time.getHour();
        }
    }
    ,
    ISODOW{

        @Override
        public double extract(OffsetDateTime time) {
            return time.get(ISODOW_FIELD);
        }

        @Override
        public double extract(LocalDateTime time) {
            return time.get(ISODOW_FIELD);
        }

        @Override
        public double extract(LocalDate date) {
            return date.get(ISODOW_FIELD);
        }

        @Override
        public double extract(LocalTime time) {
            throw new IllegalArgumentException("Cannot extract ISODOW from TIME");
        }
    }
    ,
    ISOYEAR{

        @Override
        public double extract(OffsetDateTime time) {
            return time.get(ISOYEAR_FIELD);
        }

        @Override
        public double extract(LocalDateTime time) {
            return time.get(ISOYEAR_FIELD);
        }

        @Override
        public double extract(LocalDate date) {
            return date.get(ISOYEAR_FIELD);
        }

        @Override
        public double extract(LocalTime time) {
            throw new IllegalArgumentException("Cannot extract ISOYEAR from TIME");
        }
    }
    ,
    MICROSECOND{

        @Override
        public double extract(OffsetDateTime time) {
            return this.extractMicrosecond(time);
        }

        @Override
        public double extract(LocalDateTime time) {
            return this.extractMicrosecond(time);
        }

        @Override
        public double extract(LocalDate date) {
            return 0.0;
        }

        @Override
        public double extract(LocalTime time) {
            return this.extractMicrosecond(time);
        }

        private double extractMicrosecond(Temporal temporal) {
            int fractionMicroseconds = temporal.get(ChronoField.MICRO_OF_SECOND);
            int seconds = temporal.get(ChronoField.SECOND_OF_MINUTE);
            return (double)fractionMicroseconds + (double)(seconds * 1000000);
        }
    }
    ,
    MILLENNIUM{

        @Override
        public double extract(OffsetDateTime time) {
            return this.extractMillennium(time);
        }

        @Override
        public double extract(LocalDateTime time) {
            return this.extractMillennium(time);
        }

        @Override
        public double extract(LocalDate date) {
            return this.extractMillennium(date);
        }

        @Override
        public double extract(LocalTime time) {
            throw new IllegalArgumentException("Cannot extract MILLENNIUM from TIME");
        }

        private double extractMillennium(Temporal temporal) {
            int year = temporal.get(ChronoField.YEAR);
            int absYear = Math.abs(year);
            double sign = (double)year < 0.0 ? -1.0 : 1.0;
            int quotient = absYear / 1000;
            int remainder = absYear % 1000;
            int absMillennium = quotient + (remainder == 0 ? -1 : 0) + 1;
            return sign * (double)absMillennium;
        }
    }
    ,
    MILLISECOND{

        @Override
        public double extract(OffsetDateTime time) {
            int fractionMilliseconds = time.get(ChronoField.MILLI_OF_SECOND);
            int seconds = time.getSecond();
            return (double)fractionMilliseconds + (double)(seconds * 1000);
        }

        @Override
        public double extract(LocalDateTime time) {
            return this.extract(OffsetDateTime.of(time, ZoneOffset.UTC));
        }

        @Override
        public double extract(LocalDate date) {
            return 0.0;
        }

        @Override
        public double extract(LocalTime time) {
            return this.extract(LocalDateTime.of(LocalDate.ofEpochDay(0L), time));
        }
    }
    ,
    MINUTE{

        @Override
        public double extract(OffsetDateTime time) {
            return time.getMinute();
        }

        @Override
        public double extract(LocalDateTime time) {
            return time.getMinute();
        }

        @Override
        public double extract(LocalDate date) {
            return 0.0;
        }

        @Override
        public double extract(LocalTime time) {
            return time.getMinute();
        }
    }
    ,
    MONTH{

        @Override
        public double extract(OffsetDateTime time) {
            return time.getMonthValue();
        }

        @Override
        public double extract(LocalDateTime time) {
            return time.getMonthValue();
        }

        @Override
        public double extract(LocalDate date) {
            return date.getMonthValue();
        }

        @Override
        public double extract(LocalTime time) {
            throw new IllegalArgumentException("Cannot extract MONTH from TIME");
        }
    }
    ,
    QUARTER{

        @Override
        public double extract(OffsetDateTime time) {
            return time.get(QUARTER_FIELD);
        }

        @Override
        public double extract(LocalDateTime time) {
            return time.get(QUARTER_FIELD);
        }

        @Override
        public double extract(LocalDate date) {
            return date.get(QUARTER_FIELD);
        }

        @Override
        public double extract(LocalTime time) {
            throw new IllegalArgumentException("Cannot extract QUARTER from TIME");
        }
    }
    ,
    SECOND{

        @Override
        public double extract(OffsetDateTime time) {
            return time.getSecond();
        }

        @Override
        public double extract(LocalDateTime time) {
            return time.getSecond();
        }

        @Override
        public double extract(LocalDate date) {
            return 0.0;
        }

        @Override
        public double extract(LocalTime time) {
            return time.getSecond();
        }
    }
    ,
    WEEK{

        @Override
        public double extract(OffsetDateTime time) {
            return time.get(WEEK_FIELD);
        }

        @Override
        public double extract(LocalDateTime time) {
            return time.get(WEEK_FIELD);
        }

        @Override
        public double extract(LocalDate date) {
            return date.get(WEEK_FIELD);
        }

        @Override
        public double extract(LocalTime time) {
            throw new IllegalArgumentException("Cannot extract WEEK from TIME");
        }
    }
    ,
    YEAR{

        @Override
        public double extract(OffsetDateTime time) {
            return time.getYear();
        }

        @Override
        public double extract(LocalDateTime time) {
            return time.getYear();
        }

        @Override
        public double extract(LocalDate date) {
            return date.getYear();
        }

        @Override
        public double extract(LocalTime time) {
            throw new IllegalArgumentException("Cannot extract YEAR from TIME");
        }
    };

    protected static final int YEARS_IN_MILLENNIUM = 1000;
    protected static final int YEARS_IN_CENTURY = 100;
    protected static final int YEARS_IN_DECADE = 10;
    protected static final int NANOSECONDS_IN_SECOND = 1000000000;
    protected static final int MICROSECONDS_IN_SECOND = 1000000;
    protected static final int MILLISECONDS_IN_SECOND = 1000;
    protected static final int FIRST_MILLENNIUM = 1;
    protected static final int FIRST_CENTURY = 1;
    protected static final double FIRST_DAY_OF_WEEK = 1.0;
    protected static final TemporalField WEEK_FIELD;
    protected static final TemporalField QUARTER_FIELD;
    protected static final TemporalField ISOYEAR_FIELD;
    protected static final TemporalField ISODOW_FIELD;

    public abstract double extract(OffsetDateTime var1);

    public abstract double extract(LocalDateTime var1);

    public abstract double extract(LocalDate var1);

    public abstract double extract(LocalTime var1);

    static {
        WEEK_FIELD = WeekFields.ISO.weekOfWeekBasedYear();
        QUARTER_FIELD = IsoFields.QUARTER_OF_YEAR;
        ISOYEAR_FIELD = WeekFields.ISO.weekBasedYear();
        ISODOW_FIELD = WeekFields.ISO.dayOfWeek();
    }
}

