/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.expression;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.sql.impl.expression.AbstractSarg;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.row.Row;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.io.IOException;
import java.util.Objects;

public class SargExpression<C extends Comparable<C>>
implements Expression<AbstractSarg<C>> {
    private QueryDataType type;
    private AbstractSarg<C> sarg;

    public SargExpression() {
    }

    private SargExpression(QueryDataType type, AbstractSarg<C> sarg) {
        this.type = type;
        this.sarg = sarg;
    }

    public static SargExpression<?> create(QueryDataType type, AbstractSarg<?> searchable) {
        return new SargExpression(type, searchable);
    }

    public int getClassId() {
        return 75;
    }

    @Override
    public AbstractSarg<C> eval(Row row, ExpressionEvalContext context) {
        return this.sarg;
    }

    @Override
    public QueryDataType getType() {
        return this.type;
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject((Object)this.type);
        out.writeObject(this.sarg);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.type = (QueryDataType)in.readObject();
        this.sarg = (AbstractSarg)in.readObject();
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + (this.sarg != null ? this.sarg.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SargExpression that = (SargExpression)o;
        return Objects.equals(this.type, that.type) && Objects.equals(this.sarg, that.sarg);
    }

    public String toString() {
        return "SearchableExpression{type=" + String.valueOf(this.type) + ", searchable=" + String.valueOf(this.sarg) + "}";
    }

    @Override
    public boolean isCooperative() {
        return true;
    }
}

