/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.expression;

import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.jet.sql.impl.extract.AvroQueryTarget;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.query.impl.getters.EvictableGetterCache;
import com.hazelcast.query.impl.getters.Extractors;
import com.hazelcast.query.impl.getters.GetterCache;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.row.Row;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.io.IOException;
import org.apache.avro.generic.GenericRecord;

public class FieldAccessExpression<T>
implements Expression<T> {
    private static final int MAX_CLASS_COUNT = 10;
    private static final int MAX_GETTER_PER_CLASS_COUNT = 1;
    private volatile transient GetterCache getterCache;
    private QueryDataType type;
    private String name;
    private Expression<?> ref;

    public FieldAccessExpression() {
    }

    private FieldAccessExpression(QueryDataType type, String name, Expression<?> ref) {
        this.type = type;
        this.name = name;
        this.ref = ref;
    }

    public static FieldAccessExpression<?> create(QueryDataType type, String name, Expression<?> ref) {
        return new FieldAccessExpression(type, name, ref);
    }

    @Override
    public T eval(Row row, ExpressionEvalContext context) {
        return this.eval(row, context, false);
    }

    @Override
    public T eval(Row row, ExpressionEvalContext context, boolean useLazyDeserialization) {
        Object result = this.ref.eval(row, context, true);
        if (result == null) {
            return null;
        }
        if (this.isPrimitive(result.getClass())) {
            throw QueryException.error((String)"Field Access expression can not be applied to primitive types");
        }
        if (this.getterCache == null) {
            this.getterCache = new EvictableGetterCache(10, 1, 0.2f, false);
        }
        try {
            Object value = result instanceof GenericRecord ? AvroQueryTarget.extractValue((GenericRecord)result, this.name) : Extractors.newBuilder((InternalSerializationService)context.getSerializationService()).setGetterCacheSupplier(() -> this.getterCache).build().extract(result, this.name, (Object)useLazyDeserialization);
            return (T)this.type.convert(value);
        }
        catch (Exception e) {
            throw QueryException.error((String)"Failed to extract field");
        }
    }

    private boolean isPrimitive(Class<?> clazz) {
        return clazz.getPackage().getName().startsWith("java.");
    }

    public int getClassId() {
        return 77;
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject((Object)this.type);
        out.writeString(this.name);
        out.writeObject(this.ref);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.type = (QueryDataType)in.readObject();
        this.name = in.readString();
        this.ref = (Expression)in.readObject();
    }

    @Override
    public QueryDataType getType() {
        return this.type;
    }

    @Override
    public boolean isCooperative() {
        return this.ref.isCooperative();
    }
}

