/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl;

import com.hazelcast.cluster.Member;
import com.hazelcast.internal.util.collection.PartitionIdSet;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastObjectType;
import com.hazelcast.map.IMap;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.proxy.MapProxyImpl;
import com.hazelcast.partition.Partition;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataTypeField;
import com.hazelcast.shaded.org.apache.calcite.sql.dialect.CalciteSqlDialect;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.sql.SqlColumnMetadata;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.schema.TableResolver;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.version.MemberVersion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class QueryUtils {
    public static final String SCHEMA_NAME_PUBLIC = "public";
    public static final String SCHEMA_NAME_INFORMATION_SCHEMA = "information_schema";
    public static final String CATALOG = "hazelcast";
    public static final String WORKER_TYPE_STATE_CHECKER = "query-state-checker";
    private static final String DATA_CONNECTION_KEY_PREFIX = "57ae1d3a-d379-44cb-bb60-86b1d2dcd744-";

    private QueryUtils() {
    }

    public static String workerName(String instanceName, String workerType) {
        return instanceName + "-" + workerType;
    }

    public static String wrapDataConnectionKey(String dataConnectionKey) {
        return DATA_CONNECTION_KEY_PREFIX + dataConnectionKey;
    }

    public static SqlColumnMetadata getColumnMetadata(String columnName, QueryDataType columnType, boolean columnIsNullable) {
        return new SqlColumnMetadata(columnName, columnType.getTypeFamily().getPublicType(), columnIsNullable);
    }

    public static Map<UUID, PartitionIdSet> createPartitionMap(NodeEngine nodeEngine, @Nullable MemberVersion localMemberVersion, boolean failOnUnassignedPartition) {
        Set parts = nodeEngine.getHazelcastInstance().getPartitionService().getPartitions();
        int partCnt = parts.size();
        LinkedHashMap<UUID, PartitionIdSet> partMap = new LinkedHashMap<UUID, PartitionIdSet>();
        for (Partition part : parts) {
            Member owner = part.getOwner();
            if (owner == null) {
                if (!failOnUnassignedPartition) continue;
                throw QueryException.error((int)1005, (String)("Partition is not assigned to any member: " + part.getPartitionId()));
            }
            if (localMemberVersion != null && !localMemberVersion.equals((Object)owner.getVersion())) {
                UUID localMemberId = nodeEngine.getLocalMember().getUuid();
                throw QueryException.error((String)("Cannot execute SQL query when members have different versions (make sure that all members have the same version) {localMemberId=" + String.valueOf(localMemberId) + ", localMemberVersion=" + String.valueOf(localMemberVersion) + ", remoteMemberId=" + String.valueOf(owner.getUuid()) + ", remoteMemberVersion=" + String.valueOf(owner.getVersion()) + "}"));
            }
            partMap.computeIfAbsent(owner.getUuid(), key -> new PartitionIdSet(partCnt)).add(part.getPartitionId());
        }
        return partMap;
    }

    public static List<List<String>> prepareSearchPaths(List<List<String>> currentSearchPaths, List<TableResolver> tableResolvers) {
        ArrayList<List<String>> res = new ArrayList<List<String>>();
        if (currentSearchPaths != null) {
            res.addAll(currentSearchPaths);
        }
        if (tableResolvers != null) {
            for (TableResolver tableResolver : tableResolvers) {
                res.addAll(tableResolver.getDefaultSearchPaths());
            }
        }
        res.add(Collections.singletonList(CATALOG));
        res.add(Collections.emptyList());
        return res;
    }

    public static boolean containsCycles(HazelcastObjectType type, Set<String> discovered) {
        if (!discovered.add(type.getTypeName())) {
            return true;
        }
        for (RelDataTypeField field : type.getFieldList()) {
            RelDataType fieldType = field.getType();
            if (!(fieldType instanceof HazelcastObjectType) || !QueryUtils.containsCycles((HazelcastObjectType)fieldType, discovered)) continue;
            return true;
        }
        return false;
    }

    public static String quoteCompoundIdentifier(String ... compoundIdentifier) {
        List<String> parts = Arrays.stream(compoundIdentifier).filter(Objects::nonNull).collect(Collectors.toList());
        return CalciteSqlDialect.DEFAULT.quoteIdentifier(new StringBuilder(), parts).toString();
    }

    public static <K, V> MapContainer getMapContainer(IMap<K, V> map) {
        MapProxyImpl mapProxy = (MapProxyImpl)map;
        MapService mapService = (MapService)mapProxy.getService();
        MapServiceContext mapServiceContext = mapService.getMapServiceContext();
        return mapServiceContext.getMapContainer(map.getName());
    }
}

