/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.simplify;

import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.CoordinateSequence;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.LinearRing;
import com.hazelcast.shaded.org.locationtech.jts.geom.MultiPolygon;
import com.hazelcast.shaded.org.locationtech.jts.geom.Polygon;
import com.hazelcast.shaded.org.locationtech.jts.geom.util.GeometryTransformer;
import com.hazelcast.shaded.org.locationtech.jts.simplify.DouglasPeuckerLineSimplifier;

public class DouglasPeuckerSimplifier {
    private Geometry inputGeom;
    private double distanceTolerance;
    private boolean isEnsureValidTopology = true;

    public static Geometry simplify(Geometry geom, double distanceTolerance) {
        DouglasPeuckerSimplifier tss = new DouglasPeuckerSimplifier(geom);
        tss.setDistanceTolerance(distanceTolerance);
        return tss.getResultGeometry();
    }

    public DouglasPeuckerSimplifier(Geometry inputGeom) {
        this.inputGeom = inputGeom;
    }

    public void setDistanceTolerance(double distanceTolerance) {
        if (distanceTolerance < 0.0) {
            throw new IllegalArgumentException("Tolerance must be non-negative");
        }
        this.distanceTolerance = distanceTolerance;
    }

    public void setEnsureValid(boolean isEnsureValidTopology) {
        this.isEnsureValidTopology = isEnsureValidTopology;
    }

    public Geometry getResultGeometry() {
        if (this.inputGeom.isEmpty()) {
            return this.inputGeom.copy();
        }
        return new DPTransformer(this.isEnsureValidTopology, this.distanceTolerance).transform(this.inputGeom);
    }

    static class DPTransformer
    extends GeometryTransformer {
        private boolean isEnsureValidTopology = true;
        private double distanceTolerance;

        public DPTransformer(boolean isEnsureValidTopology, double distanceTolerance) {
            this.isEnsureValidTopology = isEnsureValidTopology;
            this.distanceTolerance = distanceTolerance;
        }

        @Override
        protected CoordinateSequence transformCoordinates(CoordinateSequence coords, Geometry parent) {
            Coordinate[] inputPts = coords.toCoordinateArray();
            Coordinate[] newPts = null;
            newPts = inputPts.length == 0 ? new Coordinate[]{} : DouglasPeuckerLineSimplifier.simplify(inputPts, this.distanceTolerance);
            return this.factory.getCoordinateSequenceFactory().create(newPts);
        }

        @Override
        protected Geometry transformPolygon(Polygon geom, Geometry parent) {
            if (geom.isEmpty()) {
                return null;
            }
            Geometry rawGeom = super.transformPolygon(geom, parent);
            if (parent instanceof MultiPolygon) {
                return rawGeom;
            }
            return this.createValidArea(rawGeom);
        }

        @Override
        protected Geometry transformLinearRing(LinearRing geom, Geometry parent) {
            boolean removeDegenerateRings = parent instanceof Polygon;
            Geometry simpResult = super.transformLinearRing(geom, parent);
            if (removeDegenerateRings && !(simpResult instanceof LinearRing)) {
                return null;
            }
            return simpResult;
        }

        @Override
        protected Geometry transformMultiPolygon(MultiPolygon geom, Geometry parent) {
            Geometry rawGeom = super.transformMultiPolygon(geom, parent);
            return this.createValidArea(rawGeom);
        }

        private Geometry createValidArea(Geometry rawAreaGeom) {
            boolean isValidArea;
            boolean bl = isValidArea = rawAreaGeom.getDimension() == 2 && rawAreaGeom.isValid();
            if (this.isEnsureValidTopology && !isValidArea) {
                return rawAreaGeom.buffer(0.0);
            }
            return rawAreaGeom;
        }
    }
}

