/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.noding;

import com.hazelcast.shaded.org.locationtech.jts.algorithm.LineIntersector;
import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.noding.SegmentIntersector;
import com.hazelcast.shaded.org.locationtech.jts.noding.SegmentString;
import java.util.ArrayList;
import java.util.List;

public class NodingIntersectionFinder
implements SegmentIntersector {
    private boolean findAllIntersections = false;
    private boolean isCheckEndSegmentsOnly = false;
    private boolean keepIntersections = true;
    private boolean isInteriorIntersectionsOnly = false;
    private LineIntersector li;
    private Coordinate interiorIntersection = null;
    private Coordinate[] intSegments = null;
    private List intersections = new ArrayList();
    private int intersectionCount = 0;

    public static NodingIntersectionFinder createAnyIntersectionFinder(LineIntersector li) {
        return new NodingIntersectionFinder(li);
    }

    public static NodingIntersectionFinder createAllIntersectionsFinder(LineIntersector li) {
        NodingIntersectionFinder finder = new NodingIntersectionFinder(li);
        finder.setFindAllIntersections(true);
        return finder;
    }

    public static NodingIntersectionFinder createInteriorIntersectionsFinder(LineIntersector li) {
        NodingIntersectionFinder finder = new NodingIntersectionFinder(li);
        finder.setFindAllIntersections(true);
        finder.setInteriorIntersectionsOnly(true);
        return finder;
    }

    public static NodingIntersectionFinder createIntersectionCounter(LineIntersector li) {
        NodingIntersectionFinder finder = new NodingIntersectionFinder(li);
        finder.setFindAllIntersections(true);
        finder.setKeepIntersections(false);
        return finder;
    }

    public static NodingIntersectionFinder createInteriorIntersectionCounter(LineIntersector li) {
        NodingIntersectionFinder finder = new NodingIntersectionFinder(li);
        finder.setInteriorIntersectionsOnly(true);
        finder.setFindAllIntersections(true);
        finder.setKeepIntersections(false);
        return finder;
    }

    public NodingIntersectionFinder(LineIntersector li) {
        this.li = li;
        this.interiorIntersection = null;
    }

    public void setFindAllIntersections(boolean findAllIntersections) {
        this.findAllIntersections = findAllIntersections;
    }

    public void setInteriorIntersectionsOnly(boolean isInteriorIntersectionsOnly) {
        this.isInteriorIntersectionsOnly = isInteriorIntersectionsOnly;
    }

    public void setCheckEndSegmentsOnly(boolean isCheckEndSegmentsOnly) {
        this.isCheckEndSegmentsOnly = isCheckEndSegmentsOnly;
    }

    public void setKeepIntersections(boolean keepIntersections) {
        this.keepIntersections = keepIntersections;
    }

    public List getIntersections() {
        return this.intersections;
    }

    public int count() {
        return this.intersectionCount;
    }

    public boolean hasIntersection() {
        return this.interiorIntersection != null;
    }

    public Coordinate getIntersection() {
        return this.interiorIntersection;
    }

    public Coordinate[] getIntersectionSegments() {
        return this.intSegments;
    }

    @Override
    public void processIntersections(SegmentString e0, int segIndex0, SegmentString e1, int segIndex1) {
        boolean isSameSegment;
        if (!this.findAllIntersections && this.hasIntersection()) {
            return;
        }
        boolean isSameSegString = e0 == e1;
        boolean bl = isSameSegment = isSameSegString && segIndex0 == segIndex1;
        if (isSameSegment) {
            return;
        }
        if (this.isCheckEndSegmentsOnly) {
            boolean isEndSegPresent;
            boolean bl2 = isEndSegPresent = NodingIntersectionFinder.isEndSegment(e0, segIndex0) || NodingIntersectionFinder.isEndSegment(e1, segIndex1);
            if (!isEndSegPresent) {
                return;
            }
        }
        Coordinate p00 = e0.getCoordinate(segIndex0);
        Coordinate p01 = e0.getCoordinate(segIndex0 + 1);
        Coordinate p10 = e1.getCoordinate(segIndex1);
        Coordinate p11 = e1.getCoordinate(segIndex1 + 1);
        boolean isEnd00 = segIndex0 == 0;
        boolean isEnd01 = segIndex0 + 2 == e0.size();
        boolean isEnd10 = segIndex1 == 0;
        boolean isEnd11 = segIndex1 + 2 == e1.size();
        this.li.computeIntersection(p00, p01, p10, p11);
        boolean isInteriorInt = this.li.hasIntersection() && this.li.isInteriorIntersection();
        boolean isInteriorVertexInt = false;
        if (!this.isInteriorIntersectionsOnly) {
            boolean isAdjacentSegment = isSameSegString && Math.abs(segIndex1 - segIndex0) <= 1;
            boolean bl3 = isInteriorVertexInt = !isAdjacentSegment && NodingIntersectionFinder.isInteriorVertexIntersection(p00, p01, p10, p11, isEnd00, isEnd01, isEnd10, isEnd11);
        }
        if (isInteriorInt || isInteriorVertexInt) {
            this.intSegments = new Coordinate[4];
            this.intSegments[0] = p00;
            this.intSegments[1] = p01;
            this.intSegments[2] = p10;
            this.intSegments[3] = p11;
            this.interiorIntersection = this.li.getIntersection(0);
            if (this.keepIntersections) {
                this.intersections.add(this.interiorIntersection);
            }
            ++this.intersectionCount;
        }
    }

    private static boolean isInteriorVertexIntersection(Coordinate p00, Coordinate p01, Coordinate p10, Coordinate p11, boolean isEnd00, boolean isEnd01, boolean isEnd10, boolean isEnd11) {
        if (NodingIntersectionFinder.isInteriorVertexIntersection(p00, p10, isEnd00, isEnd10)) {
            return true;
        }
        if (NodingIntersectionFinder.isInteriorVertexIntersection(p00, p11, isEnd00, isEnd11)) {
            return true;
        }
        if (NodingIntersectionFinder.isInteriorVertexIntersection(p01, p10, isEnd01, isEnd10)) {
            return true;
        }
        return NodingIntersectionFinder.isInteriorVertexIntersection(p01, p11, isEnd01, isEnd11);
    }

    private static boolean isInteriorVertexIntersection(Coordinate p0, Coordinate p1, boolean isEnd0, boolean isEnd1) {
        if (isEnd0 && isEnd1) {
            return false;
        }
        return p0.equals2D(p1);
    }

    private static boolean isEndSegment(SegmentString segStr, int index) {
        if (index == 0) {
            return true;
        }
        return index >= segStr.size() - 2;
    }

    @Override
    public boolean isDone() {
        if (this.findAllIntersections) {
            return false;
        }
        return this.interiorIntersection != null;
    }
}

