/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.index.strtree;

import com.hazelcast.shaded.org.locationtech.jts.geom.Envelope;
import com.hazelcast.shaded.org.locationtech.jts.index.ItemVisitor;
import com.hazelcast.shaded.org.locationtech.jts.index.SpatialIndex;
import com.hazelcast.shaded.org.locationtech.jts.index.strtree.AbstractNode;
import com.hazelcast.shaded.org.locationtech.jts.index.strtree.AbstractSTRtree;
import com.hazelcast.shaded.org.locationtech.jts.index.strtree.Boundable;
import com.hazelcast.shaded.org.locationtech.jts.index.strtree.BoundablePair;
import com.hazelcast.shaded.org.locationtech.jts.index.strtree.ItemBoundable;
import com.hazelcast.shaded.org.locationtech.jts.index.strtree.ItemDistance;
import com.hazelcast.shaded.org.locationtech.jts.util.Assert;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;

public class STRtree
extends AbstractSTRtree
implements SpatialIndex,
Serializable {
    private static final long serialVersionUID = 259274702368956900L;
    private static Comparator xComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            return AbstractSTRtree.compareDoubles(STRtree.centreX((Envelope)((Boundable)o1).getBounds()), STRtree.centreX((Envelope)((Boundable)o2).getBounds()));
        }
    };
    private static Comparator yComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            return AbstractSTRtree.compareDoubles(STRtree.centreY((Envelope)((Boundable)o1).getBounds()), STRtree.centreY((Envelope)((Boundable)o2).getBounds()));
        }
    };
    private static AbstractSTRtree.IntersectsOp intersectsOp = new AbstractSTRtree.IntersectsOp(){

        @Override
        public boolean intersects(Object aBounds, Object bBounds) {
            return ((Envelope)aBounds).intersects((Envelope)bBounds);
        }
    };
    private static final int DEFAULT_NODE_CAPACITY = 10;

    private static double centreX(Envelope e) {
        return STRtree.avg(e.getMinX(), e.getMaxX());
    }

    private static double centreY(Envelope e) {
        return STRtree.avg(e.getMinY(), e.getMaxY());
    }

    private static double avg(double a, double b) {
        return (a + b) / 2.0;
    }

    @Override
    protected List createParentBoundables(List childBoundables, int newLevel) {
        Assert.isTrue(!childBoundables.isEmpty());
        int minLeafCount = (int)Math.ceil((double)childBoundables.size() / (double)this.getNodeCapacity());
        ArrayList sortedChildBoundables = new ArrayList(childBoundables);
        Collections.sort(sortedChildBoundables, xComparator);
        List[] verticalSlices = this.verticalSlices(sortedChildBoundables, (int)Math.ceil(Math.sqrt(minLeafCount)));
        return this.createParentBoundablesFromVerticalSlices(verticalSlices, newLevel);
    }

    private List createParentBoundablesFromVerticalSlices(List[] verticalSlices, int newLevel) {
        Assert.isTrue(verticalSlices.length > 0);
        ArrayList parentBoundables = new ArrayList();
        for (int i = 0; i < verticalSlices.length; ++i) {
            parentBoundables.addAll(this.createParentBoundablesFromVerticalSlice(verticalSlices[i], newLevel));
        }
        return parentBoundables;
    }

    protected List createParentBoundablesFromVerticalSlice(List childBoundables, int newLevel) {
        return super.createParentBoundables(childBoundables, newLevel);
    }

    protected List[] verticalSlices(List childBoundables, int sliceCount) {
        int sliceCapacity = (int)Math.ceil((double)childBoundables.size() / (double)sliceCount);
        List[] slices = new List[sliceCount];
        Iterator i = childBoundables.iterator();
        for (int j = 0; j < sliceCount; ++j) {
            slices[j] = new ArrayList();
            for (int boundablesAddedToSlice = 0; i.hasNext() && boundablesAddedToSlice < sliceCapacity; ++boundablesAddedToSlice) {
                Boundable childBoundable = (Boundable)i.next();
                slices[j].add(childBoundable);
            }
        }
        return slices;
    }

    public STRtree() {
        this(10);
    }

    public STRtree(int nodeCapacity) {
        super(nodeCapacity);
    }

    public STRtree(int nodeCapacity, STRtreeNode root) {
        super(nodeCapacity, root);
    }

    public STRtree(int nodeCapacity, ArrayList itemBoundables) {
        super(nodeCapacity, itemBoundables);
    }

    @Override
    protected AbstractNode createNode(int level) {
        return new STRtreeNode(level);
    }

    @Override
    protected AbstractSTRtree.IntersectsOp getIntersectsOp() {
        return intersectsOp;
    }

    @Override
    public void insert(Envelope itemEnv, Object item) {
        if (itemEnv.isNull()) {
            return;
        }
        super.insert(itemEnv, item);
    }

    @Override
    public List query(Envelope searchEnv) {
        return super.query(searchEnv);
    }

    @Override
    public void query(Envelope searchEnv, ItemVisitor visitor) {
        super.query(searchEnv, visitor);
    }

    @Override
    public boolean remove(Envelope itemEnv, Object item) {
        return super.remove(itemEnv, item);
    }

    @Override
    public int size() {
        return super.size();
    }

    @Override
    public int depth() {
        return super.depth();
    }

    @Override
    protected Comparator getComparator() {
        return yComparator;
    }

    public Object[] nearestNeighbour(ItemDistance itemDist) {
        if (this.isEmpty()) {
            return null;
        }
        BoundablePair bp = new BoundablePair(this.getRoot(), this.getRoot(), itemDist);
        return this.nearestNeighbour(bp);
    }

    public Object nearestNeighbour(Envelope env, Object item, ItemDistance itemDist) {
        if (this.isEmpty()) {
            return null;
        }
        ItemBoundable bnd = new ItemBoundable(env, item);
        BoundablePair bp = new BoundablePair(this.getRoot(), bnd, itemDist);
        return this.nearestNeighbour(bp)[0];
    }

    public Object[] nearestNeighbour(STRtree tree, ItemDistance itemDist) {
        if (this.isEmpty() || tree.isEmpty()) {
            return null;
        }
        BoundablePair bp = new BoundablePair(this.getRoot(), tree.getRoot(), itemDist);
        return this.nearestNeighbour(bp);
    }

    private Object[] nearestNeighbour(BoundablePair initBndPair) {
        BoundablePair bndPair;
        double pairDistance;
        double distanceLowerBound = Double.POSITIVE_INFINITY;
        BoundablePair minPair = null;
        PriorityQueue<BoundablePair> priQ = new PriorityQueue<BoundablePair>();
        priQ.add(initBndPair);
        while (!priQ.isEmpty() && distanceLowerBound > 0.0 && !((pairDistance = (bndPair = (BoundablePair)priQ.poll()).getDistance()) >= distanceLowerBound)) {
            if (bndPair.isLeaves()) {
                distanceLowerBound = pairDistance;
                minPair = bndPair;
                continue;
            }
            bndPair.expandToQueue(priQ, distanceLowerBound);
        }
        if (minPair == null) {
            return null;
        }
        return new Object[]{((ItemBoundable)minPair.getBoundable(0)).getItem(), ((ItemBoundable)minPair.getBoundable(1)).getItem()};
    }

    public boolean isWithinDistance(STRtree tree, ItemDistance itemDist, double maxDistance) {
        BoundablePair bp = new BoundablePair(this.getRoot(), tree.getRoot(), itemDist);
        return this.isWithinDistance(bp, maxDistance);
    }

    private boolean isWithinDistance(BoundablePair initBndPair, double maxDistance) {
        double distanceUpperBound = Double.POSITIVE_INFINITY;
        PriorityQueue<BoundablePair> priQ = new PriorityQueue<BoundablePair>();
        priQ.add(initBndPair);
        while (!priQ.isEmpty()) {
            BoundablePair bndPair = (BoundablePair)priQ.poll();
            double pairDistance = bndPair.getDistance();
            if (pairDistance > maxDistance) {
                return false;
            }
            if (bndPair.maximumDistance() <= maxDistance) {
                return true;
            }
            if (bndPair.isLeaves()) {
                distanceUpperBound = pairDistance;
                if (!(distanceUpperBound <= maxDistance)) continue;
                return true;
            }
            bndPair.expandToQueue(priQ, distanceUpperBound);
        }
        return false;
    }

    public Object[] nearestNeighbour(Envelope env, Object item, ItemDistance itemDist, int k) {
        if (this.isEmpty()) {
            return new Object[0];
        }
        ItemBoundable bnd = new ItemBoundable(env, item);
        BoundablePair bp = new BoundablePair(this.getRoot(), bnd, itemDist);
        return this.nearestNeighbourK(bp, k);
    }

    private Object[] nearestNeighbourK(BoundablePair initBndPair, int k) {
        return this.nearestNeighbourK(initBndPair, Double.POSITIVE_INFINITY, k);
    }

    private Object[] nearestNeighbourK(BoundablePair initBndPair, double maxDistance, int k) {
        BoundablePair bndPair;
        double pairDistance;
        double distanceLowerBound = maxDistance;
        PriorityQueue<BoundablePair> priQ = new PriorityQueue<BoundablePair>();
        priQ.add(initBndPair);
        PriorityQueue<BoundablePair> kNearestNeighbors = new PriorityQueue<BoundablePair>();
        while (!priQ.isEmpty() && distanceLowerBound >= 0.0 && !((pairDistance = (bndPair = (BoundablePair)priQ.poll()).getDistance()) >= distanceLowerBound)) {
            if (bndPair.isLeaves()) {
                if (kNearestNeighbors.size() < k) {
                    kNearestNeighbors.add(bndPair);
                    continue;
                }
                BoundablePair bp1 = (BoundablePair)kNearestNeighbors.peek();
                if (bp1.getDistance() > pairDistance) {
                    kNearestNeighbors.poll();
                    kNearestNeighbors.add(bndPair);
                }
                BoundablePair bp2 = (BoundablePair)kNearestNeighbors.peek();
                distanceLowerBound = bp2.getDistance();
                continue;
            }
            bndPair.expandToQueue(priQ, distanceLowerBound);
        }
        return STRtree.getItems(kNearestNeighbors);
    }

    private static Object[] getItems(PriorityQueue kNearestNeighbors) {
        Object[] items = new Object[kNearestNeighbors.size()];
        int count = 0;
        while (!kNearestNeighbors.isEmpty()) {
            BoundablePair bp = (BoundablePair)kNearestNeighbors.poll();
            items[count] = ((ItemBoundable)bp.getBoundable(0)).getItem();
            ++count;
        }
        return items;
    }

    static final class STRtreeNode
    extends AbstractNode {
        STRtreeNode(int level) {
            super(level);
        }

        @Override
        protected Object computeBounds() {
            Envelope bounds = null;
            for (Boundable childBoundable : this.getChildBoundables()) {
                if (bounds == null) {
                    bounds = new Envelope((Envelope)childBoundable.getBounds());
                    continue;
                }
                bounds.expandToInclude((Envelope)childBoundable.getBounds());
            }
            return bounds;
        }
    }
}

