/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.codehaus.janino;

import com.hazelcast.shaded.org.codehaus.commons.compiler.util.resource.Resource;
import com.hazelcast.shaded.org.codehaus.commons.compiler.util.resource.ResourceFinder;
import com.hazelcast.shaded.org.codehaus.commons.nullanalysis.Nullable;
import com.hazelcast.shaded.org.codehaus.janino.ClassFileIClass;
import com.hazelcast.shaded.org.codehaus.janino.Descriptor;
import com.hazelcast.shaded.org.codehaus.janino.IClass;
import com.hazelcast.shaded.org.codehaus.janino.IClassLoader;
import com.hazelcast.shaded.org.codehaus.janino.util.ClassFile;
import java.io.IOException;
import java.io.InputStream;

public class ResourceFinderIClassLoader
extends IClassLoader {
    private final ResourceFinder resourceFinder;

    public ResourceFinderIClassLoader(ResourceFinder resourceFinder, @Nullable IClassLoader parentIClassLoader) {
        super(parentIClassLoader);
        this.resourceFinder = resourceFinder;
        this.postConstruct();
    }

    @Override
    @Nullable
    protected IClass findIClass(String descriptor) throws ClassNotFoundException {
        ClassFile cf;
        InputStream is;
        String className = Descriptor.toClassName(descriptor);
        Resource classFileResource = this.resourceFinder.findResource(ClassFile.getClassFileResourceName(className));
        if (classFileResource == null) {
            return null;
        }
        try {
            is = classFileResource.open();
        }
        catch (IOException ex) {
            throw new ClassNotFoundException("Opening resource \"" + classFileResource.getFileName() + "\"", ex);
        }
        try {
            cf = new ClassFile(is);
        }
        catch (IOException e) {
            throw new ClassNotFoundException("Reading resource \"" + classFileResource.getFileName() + "\"", e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        ClassFileIClass iClass = new ClassFileIClass(cf, this);
        this.defineIClass(iClass);
        return iClass;
    }
}

