/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.sql.fun;

import com.hazelcast.shaded.org.apache.calcite.avatica.util.TimeUnit;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataTypeFactory;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlCall;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlFunction;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlFunctionCategory;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlIntervalQualifier;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlKind;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlOperatorBinding;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlOperandTypeChecker;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidator;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidatorScope;

class SqlTimestampDiffFunction
extends SqlFunction {
    private static RelDataType inferReturnType2(SqlOperatorBinding opBinding) {
        RelDataType type2;
        RelDataType type1;
        TimeUnit timeUnit;
        RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
        if (opBinding.isOperandTimeFrame(0)) {
            timeUnit = opBinding.getOperandLiteralValue(0, TimeUnit.class);
            type1 = opBinding.getOperandType(1);
            type2 = opBinding.getOperandType(2);
        } else {
            type1 = opBinding.getOperandType(0);
            type2 = opBinding.getOperandType(1);
            timeUnit = opBinding.getOperandLiteralValue(2, TimeUnit.class);
        }
        SqlTypeName sqlTypeName = timeUnit == TimeUnit.NANOSECOND ? SqlTypeName.BIGINT : SqlTypeName.INTEGER;
        return typeFactory.createTypeWithNullability(typeFactory.createSqlType(sqlTypeName), type1.isNullable() || type2.isNullable());
    }

    SqlTimestampDiffFunction(String name, SqlOperandTypeChecker operandTypeChecker) {
        super(name, SqlKind.TIMESTAMP_DIFF, SqlTimestampDiffFunction::inferReturnType2, null, operandTypeChecker, SqlFunctionCategory.TIMEDATE);
    }

    @Override
    public void validateCall(SqlCall call, SqlValidator validator, SqlValidatorScope scope, SqlValidatorScope operandScope) {
        super.validateCall(call, validator, scope, operandScope);
        if (call.operand(2) instanceof SqlIntervalQualifier) {
            validator.validateTimeFrame((SqlIntervalQualifier)call.operand(2));
        } else {
            validator.validateTimeFrame((SqlIntervalQualifier)call.operand(0));
        }
    }
}

