/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.sql.fun;

import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataTypeFactory;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlCall;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlCallBinding;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlFunction;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlFunctionCategory;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlJsonConstructorNullClause;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlKind;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlLiteral;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlOperandCountRange;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.shaded.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.shaded.org.apache.calcite.sql.type.ReturnTypes;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlOperandCountRanges;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlOperandTypeChecker;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeUtil;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidator;
import com.hazelcast.shaded.org.apache.calcite.util.Static;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.Locale;
import java.util.Objects;

public class SqlJsonObjectFunction
extends SqlFunction {
    public SqlJsonObjectFunction() {
        super("JSON_OBJECT", SqlKind.OTHER_FUNCTION, ReturnTypes.VARCHAR_2000, (SqlCallBinding callBinding, RelDataType returnType, RelDataType[] operandTypes) -> {
            RelDataTypeFactory typeFactory = callBinding.getTypeFactory();
            for (int i = 0; i < operandTypes.length; ++i) {
                operandTypes[i] = i == 0 ? typeFactory.createSqlType(SqlTypeName.SYMBOL) : (i % 2 == 1 ? typeFactory.createSqlType(SqlTypeName.VARCHAR) : typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.ANY), true));
            }
        }, null, SqlFunctionCategory.SYSTEM);
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.from(1);
    }

    @Override
    protected void checkOperandCount(SqlValidator validator, @Nullable SqlOperandTypeChecker argType, SqlCall call) {
        assert (call.operandCount() % 2 == 1);
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        int count = callBinding.getOperandCount();
        for (int i = 1; i < count; i += 2) {
            RelDataType nameType = callBinding.getOperandType(i);
            if (!SqlTypeUtil.inCharFamily(nameType)) {
                if (throwOnFailure) {
                    throw callBinding.newError(Static.RESOURCE.expectedCharacter());
                }
                return false;
            }
            if (!nameType.isNullable()) continue;
            if (throwOnFailure) {
                throw callBinding.newError(Static.RESOURCE.argumentMustNotBeNull(callBinding.operand(i).toString()));
            }
            return false;
        }
        return true;
    }

    @Override
    public SqlCall createCall(@Nullable SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
        if (operands[0] == null) {
            operands[0] = SqlLiteral.createSymbol(SqlJsonConstructorNullClause.NULL_ON_NULL, pos);
        }
        return super.createCall(functionQualifier, pos, operands);
    }

    @Override
    public @Nullable String getSignatureTemplate(int operandsCount) {
        assert (operandsCount % 2 == 1);
        StringBuilder sb = new StringBuilder();
        sb.append("{0}(");
        for (int i = 1; i < operandsCount; ++i) {
            sb.append(String.format(Locale.ROOT, "{%d} ", i + 1));
        }
        sb.append("{1})");
        return sb.toString();
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        assert (call.operandCount() % 2 == 1);
        SqlWriter.Frame frame = writer.startFunCall(this.getName());
        SqlWriter.Frame listFrame = writer.startList("", "");
        for (int i = 1; i < call.operandCount(); i += 2) {
            writer.sep(",");
            writer.keyword("KEY");
            ((SqlNode)call.operand(i)).unparse(writer, leftPrec, rightPrec);
            writer.keyword("VALUE");
            ((SqlNode)call.operand(i + 1)).unparse(writer, leftPrec, rightPrec);
        }
        writer.endList(listFrame);
        SqlJsonConstructorNullClause nullClause = (SqlJsonConstructorNullClause)((Object)SqlJsonObjectFunction.getEnumValue(call.operand(0)));
        writer.keyword(nullClause.sql);
        writer.endFunCall(frame);
    }

    private static <E extends Enum<E>> E getEnumValue(SqlNode operand) {
        return (E)((Enum)Objects.requireNonNull(((SqlLiteral)operand).getValue(), "operand.value"));
    }
}

