/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.validate.operand;

import com.hazelcast.jet.sql.impl.validate.HazelcastCallBinding;
import com.hazelcast.jet.sql.impl.validate.operand.OperandChecker;
import com.hazelcast.jet.sql.impl.validate.operand.TypedOperandChecker;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeName;

public final class NumericOperandChecker
implements OperandChecker {
    public static final NumericOperandChecker INSTANCE = new NumericOperandChecker();

    private NumericOperandChecker() {
    }

    @Override
    public boolean check(HazelcastCallBinding binding, boolean throwOnFailure, int index) {
        Object operand = binding.getCall().operand(index);
        RelDataType operandType = binding.getValidator().deriveType(binding.getScope(), (SqlNode)operand);
        TypedOperandChecker checker = NumericOperandChecker.checkerForTypeName(operandType.getSqlTypeName());
        if (checker != null) {
            return checker.check(binding, throwOnFailure, index);
        }
        if (throwOnFailure) {
            throw binding.newValidationSignatureError();
        }
        return false;
    }

    private static TypedOperandChecker checkerForTypeName(SqlTypeName typeName) {
        switch (typeName) {
            case TINYINT: {
                return TypedOperandChecker.TINYINT;
            }
            case SMALLINT: {
                return TypedOperandChecker.SMALLINT;
            }
            case INTEGER: {
                return TypedOperandChecker.INTEGER;
            }
            case BIGINT: {
                return TypedOperandChecker.BIGINT;
            }
            case DECIMAL: {
                return TypedOperandChecker.DECIMAL;
            }
            case REAL: 
            case FLOAT: {
                return TypedOperandChecker.REAL;
            }
            case DOUBLE: {
                return TypedOperandChecker.DOUBLE;
            }
        }
        return null;
    }
}

