/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.parse;

import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlDrop;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlKind;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlSpecialOperator;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.shaded.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidator;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidatorScope;
import com.hazelcast.shaded.org.apache.calcite.util.ImmutableNullableList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SqlDropJob
extends SqlDrop {
    private static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("DROP JOB", SqlKind.OTHER_DDL);
    private final SqlIdentifier name;
    private final SqlIdentifier withSnapshotName;

    public SqlDropJob(SqlIdentifier name, boolean ifExists, SqlIdentifier withSnapshotName, SqlParserPos pos) {
        super(OPERATOR, pos, ifExists);
        this.name = Objects.requireNonNull(name, "Name should not be null");
        this.withSnapshotName = withSnapshotName;
        Preconditions.checkTrue((name.names.size() == 1 ? 1 : 0) != 0, (String)name.toString());
        Preconditions.checkTrue((withSnapshotName == null || withSnapshotName.names.size() == 1 ? 1 : 0) != 0, (String)String.valueOf(withSnapshotName));
    }

    public String name() {
        return this.name.toString();
    }

    public boolean ifExists() {
        return this.ifExists;
    }

    @Nullable
    public String withSnapshotName() {
        return this.withSnapshotName != null ? this.withSnapshotName.toString() : null;
    }

    @Override
    @Nonnull
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    @Nonnull
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.name);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("DROP JOB");
        if (this.ifExists) {
            writer.keyword("IF EXISTS");
        }
        this.name.unparse(writer, leftPrec, rightPrec);
    }

    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope) {
    }
}

