/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.parse;

import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.sql.impl.parse.ParseUtils;
import com.hazelcast.jet.sql.impl.parse.ParserResource;
import com.hazelcast.jet.sql.impl.parse.SqlOption;
import com.hazelcast.jet.sql.impl.parse.UnparseUtil;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlCall;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlKind;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNodeList;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlSpecialOperator;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.shaded.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

public class SqlAnalyzeStatement
extends SqlCall {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("ANALYZE", SqlKind.OTHER);
    private SqlNode query;
    private final SqlNodeList options;
    private final JobConfig jobConfig = new JobConfig();

    public SqlAnalyzeStatement(SqlParserPos pos, SqlNode query, SqlNodeList options) {
        super(pos);
        this.query = query;
        this.options = Objects.requireNonNull(options, "Options should not be null");
    }

    public SqlNode getQuery() {
        return this.query;
    }

    public void setQuery(SqlNode query) {
        this.query = query;
    }

    @Override
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return List.of(this.query);
    }

    public JobConfig getJobConfig() {
        return this.jobConfig;
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("ANALYZE");
        if (!this.options.isEmpty()) {
            UnparseUtil.unparseOptions(writer, "WITH OPTIONS", this.options);
        }
        this.query.unparse(writer, leftPrec, rightPrec);
    }

    public void validate(SqlValidator validator) {
        HashSet<String> optionNames = new HashSet<String>();
        this.jobConfig.setMetricsEnabled(true);
        this.jobConfig.setStoreMetricsAfterJobCompletion(true);
        this.jobConfig.setSplitBrainProtection(false);
        this.jobConfig.setAutoScaling(false);
        this.jobConfig.setSuspendOnFailure(false);
        this.jobConfig.setArgument("__jet.jobIsSuspendable", (Object)false);
        block21: for (SqlNode option0 : this.options) {
            SqlOption option = (SqlOption)option0;
            String key = option.keyString();
            String value = option.valueString();
            if (!optionNames.add(key)) {
                throw validator.newValidationError(option, ParserResource.RESOURCE.duplicateOption(key));
            }
            switch (key) {
                case "processingGuarantee": {
                    this.jobConfig.setProcessingGuarantee(ParseUtils.parseProcessingGuarantee(validator, option));
                    continue block21;
                }
                case "snapshotIntervalMillis": {
                    this.jobConfig.setSnapshotIntervalMillis(ParseUtils.parseLong(validator, option));
                    continue block21;
                }
                case "initialSnapshotName": {
                    this.jobConfig.setInitialSnapshotName(value);
                    continue block21;
                }
                case "maxProcessorAccumulatedRecords": {
                    this.jobConfig.setMaxProcessorAccumulatedRecords(ParseUtils.parseLong(validator, option));
                    continue block21;
                }
                case "metricsEnabled": {
                    this.jobConfig.setMetricsEnabled(Boolean.parseBoolean(value));
                    continue block21;
                }
                case "storeMetricsAfterJobCompletion": {
                    this.jobConfig.setStoreMetricsAfterJobCompletion(Boolean.parseBoolean(value));
                    continue block21;
                }
                case "userCodeNamespace": 
                case "autoScaling": 
                case "splitBrainProtectionEnabled": 
                case "suspendOnFailure": {
                    throw validator.newValidationError(option.key(), ParserResource.RESOURCE.unsupportedAnalyzeJobOption(key));
                }
            }
            throw validator.newValidationError(option.key(), ParserResource.RESOURCE.unknownJobOption(key));
        }
    }
}

