/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc.postgres;

import com.hazelcast.jet.sql.impl.connector.jdbc.DefaultTypeResolver;
import com.hazelcast.jet.sql.impl.connector.jdbc.TypeResolver;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlDialect;
import com.hazelcast.shaded.org.apache.calcite.sql.dialect.PostgresqlSqlDialect;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.Locale;

public class HazelcastPostgresDialect
extends PostgresqlSqlDialect
implements TypeResolver {
    public HazelcastPostgresDialect(SqlDialect.Context context) {
        super(context);
    }

    @Override
    public QueryDataType resolveType(String columnTypeName, int precision, int scale) {
        switch (columnTypeName.toUpperCase(Locale.ROOT)) {
            case "BOOL": 
            case "BIT": {
                return QueryDataType.BOOLEAN;
            }
            case "BPCHAR": 
            case "VARCHAR": 
            case "TEXT": {
                return QueryDataType.VARCHAR;
            }
            case "INT2": 
            case "SMALLSERIAL": {
                return QueryDataType.SMALLINT;
            }
            case "INT4": 
            case "SERIAL": {
                return QueryDataType.INT;
            }
            case "INT8": 
            case "BIGSERIAL": {
                return QueryDataType.BIGINT;
            }
            case "NUMERIC": {
                return QueryDataType.DECIMAL;
            }
            case "FLOAT4": {
                return QueryDataType.REAL;
            }
            case "FLOAT8": {
                return QueryDataType.DOUBLE;
            }
            case "DATE": {
                return QueryDataType.DATE;
            }
            case "TIME": {
                return QueryDataType.TIME;
            }
            case "TIMESTAMP": {
                return QueryDataType.TIMESTAMP;
            }
            case "TIMESTAMPTZ": {
                return QueryDataType.TIMESTAMP_WITH_TZ_OFFSET_DATE_TIME;
            }
        }
        return DefaultTypeResolver.resolveType(columnTypeName, precision, scale);
    }
}

